/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.thread;

import com.ccb.core.builder.Builder;
import com.ccb.core.util.StrUtil;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadFactoryBuilder
implements Builder {
    private static final long serialVersionUID = 1L;
    private ThreadFactory backingThreadFactory;
    private String namePrefix;
    private Boolean daemon;
    private Integer priority;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public static ThreadFactoryBuilder create() {
        return new ThreadFactoryBuilder();
    }

    public ThreadFactoryBuilder setThreadFactory(ThreadFactory threadFactory) {
        this.backingThreadFactory = threadFactory;
        return this;
    }

    public ThreadFactoryBuilder setNamePrefix(String string) {
        this.namePrefix = string;
        return this;
    }

    public ThreadFactoryBuilder setDaemon(boolean bl) {
        this.daemon = bl;
        return this;
    }

    public ThreadFactoryBuilder setPriority(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"Thread priority ({}) must be >= {}", n2, 1));
        }
        if (n2 > 10) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"Thread priority ({}) must be <= {}", n2, 10));
        }
        this.priority = n2;
        return this;
    }

    public ThreadFactoryBuilder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        return this;
    }

    @Override
    public ThreadFactory build() {
        return ThreadFactoryBuilder.build(this);
    }

    private static ThreadFactory build(ThreadFactoryBuilder threadFactoryBuilder) {
        ThreadFactory threadFactory = null != threadFactoryBuilder.backingThreadFactory ? threadFactoryBuilder.backingThreadFactory : Executors.defaultThreadFactory();
        String string = threadFactoryBuilder.namePrefix;
        Boolean bl = threadFactoryBuilder.daemon;
        Integer n2 = threadFactoryBuilder.priority;
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = threadFactoryBuilder.uncaughtExceptionHandler;
        AtomicLong atomicLong = null == string ? null : new AtomicLong();
        return runnable -> {
            Thread thread = threadFactory.newThread(runnable);
            if (null != string) {
                thread.setName(string + atomicLong.getAndIncrement());
            }
            if (null != bl) {
                thread.setDaemon(bl);
            }
            if (null != n2) {
                thread.setPriority(n2);
            }
            if (null != uncaughtExceptionHandler) {
                thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
            }
            return thread;
        };
    }
}

