/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.thread;

import com.ccb.core.exceptions.NotInitedException;
import com.ccb.core.exceptions.UtilException;
import com.ccb.core.thread.SyncFinisher$1;
import com.ccb.core.thread.SyncFinisher$2;
import com.ccb.core.thread.SyncFinisher$Worker;
import com.ccb.core.thread.ThreadUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;

public class SyncFinisher {
    private final Set workers;
    private final int threadSize;
    private final ExecutorService executorService;
    private boolean isBeginAtSameTime;
    private final CountDownLatch beginLatch = new CountDownLatch(1);
    private CountDownLatch endLatch;

    public SyncFinisher(int n2) {
        this.threadSize = n2;
        this.executorService = ThreadUtil.newExecutor(n2);
        this.workers = new LinkedHashSet();
    }

    public SyncFinisher setBeginAtSameTime(boolean bl) {
        this.isBeginAtSameTime = bl;
        return this;
    }

    public SyncFinisher addRepeatWorker(Runnable runnable) {
        for (int i2 = 0; i2 < this.threadSize; ++i2) {
            this.addWorker(new SyncFinisher$1(this, runnable));
        }
        return this;
    }

    public SyncFinisher addWorker(Runnable runnable) {
        return this.addWorker(new SyncFinisher$2(this, runnable));
    }

    public synchronized SyncFinisher addWorker(SyncFinisher$Worker syncFinisher$Worker) {
        this.workers.add(syncFinisher$Worker);
        return this;
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean bl) {
        this.endLatch = new CountDownLatch(this.workers.size());
        for (SyncFinisher$Worker syncFinisher$Worker : this.workers) {
            this.executorService.submit(syncFinisher$Worker);
        }
        this.beginLatch.countDown();
        if (bl) {
            try {
                this.endLatch.await();
            }
            catch (InterruptedException interruptedException) {
                throw new UtilException(interruptedException);
            }
        }
    }

    public void await() {
        if (this.endLatch == null) {
            throw new NotInitedException("Please call start() method first!");
        }
        this.endLatch.await();
    }

    public void clearWorker() {
        this.workers.clear();
    }

    public long count() {
        return this.endLatch.getCount();
    }

    static /* synthetic */ boolean access$000(SyncFinisher syncFinisher) {
        return syncFinisher.isBeginAtSameTime;
    }

    static /* synthetic */ CountDownLatch access$100(SyncFinisher syncFinisher) {
        return syncFinisher.beginLatch;
    }

    static /* synthetic */ CountDownLatch access$200(SyncFinisher syncFinisher) {
        return syncFinisher.endLatch;
    }
}

