/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.text.csv;

import com.ccb.core.io.FileUtil;
import com.ccb.core.io.IoUtil;
import com.ccb.core.lang.Assert;
import com.ccb.core.text.csv.CsvData;
import com.ccb.core.text.csv.CsvParser;
import com.ccb.core.text.csv.CsvReadConfig;
import com.ccb.core.text.csv.CsvRow;
import com.ccb.core.text.csv.CsvRowHandler;
import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.ObjectUtil;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CsvBaseReader
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;
    private final CsvReadConfig config;

    public CsvBaseReader() {
        this(null);
    }

    public CsvBaseReader(CsvReadConfig csvReadConfig) {
        this.config = (CsvReadConfig)ObjectUtil.defaultIfNull(csvReadConfig, CsvReadConfig.defaultConfig());
    }

    public void setFieldSeparator(char c2) {
        this.config.setFieldSeparator(c2);
    }

    public void setTextDelimiter(char c2) {
        this.config.setTextDelimiter(c2);
    }

    public void setContainsHeader(boolean bl) {
        this.config.setContainsHeader(bl);
    }

    public void setSkipEmptyRows(boolean bl) {
        this.config.setSkipEmptyRows(bl);
    }

    public void setErrorOnDifferentFieldCount(boolean bl) {
        this.config.setErrorOnDifferentFieldCount(bl);
    }

    public CsvData read(File file) {
        return this.read(file, DEFAULT_CHARSET);
    }

    public CsvData read(File file, Charset charset) {
        return this.read(Objects.requireNonNull(file.toPath(), "file must not be null"), charset);
    }

    public CsvData read(Path path) {
        return this.read(path, DEFAULT_CHARSET);
    }

    public CsvData read(Path path, Charset charset) {
        Assert.notNull(path, "path must not be null", new Object[0]);
        return this.read(FileUtil.getReader(path, charset));
    }

    public CsvData read(Reader reader) {
        CsvParser csvParser = this.parse(reader);
        ArrayList arrayList = new ArrayList();
        this.read(csvParser, arrayList::add);
        List list = this.config.containsHeader ? csvParser.getHeader() : null;
        return new CsvData(list, arrayList);
    }

    public List readMapList(Reader reader) {
        this.config.setContainsHeader(true);
        ArrayList arrayList = new ArrayList();
        this.read(reader, (CsvRow csvRow) -> arrayList.add(csvRow.getFieldMap()));
        return arrayList;
    }

    public List read(Reader reader, Class clazz) {
        this.config.setContainsHeader(true);
        ArrayList arrayList = new ArrayList();
        this.read(reader, (CsvRow csvRow) -> arrayList.add(csvRow.toBean(clazz)));
        return arrayList;
    }

    public void read(Reader reader, CsvRowHandler csvRowHandler) {
        this.read(this.parse(reader), csvRowHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(CsvParser csvParser, CsvRowHandler csvRowHandler) {
        try {
            CsvRow csvRow;
            while ((csvRow = csvParser.nextRow()) != null) {
                csvRowHandler.handle(csvRow);
            }
        }
        finally {
            IoUtil.close(csvParser);
        }
    }

    private CsvParser parse(Reader reader) {
        return new CsvParser(reader, this.config);
    }
}

