/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.text;

import com.ccb.core.lang.hash.MurmurHash;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;

public class Simhash {
    private final int bitNum = 64;
    private final int fracCount;
    private final int fracBitNum;
    private final int hammingThresh;
    private final List storage;
    private final StampedLock lock = new StampedLock();

    public Simhash() {
        this(4, 3);
    }

    public Simhash(int n2, int n3) {
        this.fracCount = n2;
        this.fracBitNum = 64 / n2;
        this.hammingThresh = n3;
        this.storage = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.storage.add(new HashMap());
        }
    }

    public long hash(Collection collection) {
        int n2 = this.bitNum;
        int[] nArray = new int[n2];
        for (CharSequence charSequence : collection) {
            long l2 = MurmurHash.hash64(charSequence);
            for (int i2 = 0; i2 < n2; ++i2) {
                if ((l2 >> i2 & 1L) == 1L) {
                    int n3 = i2;
                    nArray[n3] = nArray[n3] + 1;
                    continue;
                }
                int n4 = i2;
                nArray[n4] = nArray[n4] - 1;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i3 = 0; i3 < n2; ++i3) {
            stringBuilder.append(nArray[i3] > 0 ? 1 : 0);
        }
        return new BigInteger(stringBuilder.toString(), 2).longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Collection collection) {
        long l2 = this.hash(collection);
        List list = this.splitSimhash(l2);
        int n2 = this.hammingThresh;
        long l3 = this.lock.readLock();
        try {
            for (int i2 = 0; i2 < this.fracCount; ++i2) {
                String string = (String)list.get(i2);
                Map map = (Map)this.storage.get(i2);
                if (!map.containsKey(string)) continue;
                for (Long l4 : (List)map.get(string)) {
                    if (this.hamming(l2, l4) >= n2) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.lock.unlockRead(l3);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Long l2) {
        int n2 = this.fracCount;
        List list = this.storage;
        List list2 = this.splitSimhash(l2);
        long l3 = this.lock.writeLock();
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = (String)list2.get(i2);
                Map map = (Map)list.get(i2);
                if (map.containsKey(string)) {
                    ((List)map.get(string)).add(l2);
                    continue;
                }
                ArrayList<Long> arrayList = new ArrayList<Long>();
                arrayList.add(l2);
                map.put(string, arrayList);
            }
        }
        finally {
            this.lock.unlockWrite(l3);
        }
    }

    private int hamming(Long l2, Long l3) {
        int n2 = this.bitNum;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if ((l2 >> i2 & 1L) == (l3 >> i2 & 1L)) continue;
            ++n3;
        }
        return n3;
    }

    private List splitSimhash(Long l2) {
        int n2 = this.bitNum;
        int n3 = this.fracBitNum;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(l2 >> i2 & 1L);
            if ((i2 + 1) % n3 != 0) continue;
            arrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        return arrayList;
    }
}

