/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.swing.clipboard;

import com.ccb.core.exceptions.UtilException;
import com.ccb.core.swing.clipboard.ClipboardListener;
import com.ccb.core.swing.clipboard.ClipboardMonitor;
import com.ccb.core.swing.clipboard.ImageSelection;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class ClipboardUtil {
    public static Clipboard getClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public static void set(Transferable transferable) {
        ClipboardUtil.set(transferable, null);
    }

    public static void set(Transferable transferable, ClipboardOwner clipboardOwner) {
        ClipboardUtil.getClipboard().setContents(transferable, clipboardOwner);
    }

    public static Object get(DataFlavor dataFlavor) {
        return ClipboardUtil.get(ClipboardUtil.getClipboard().getContents(null), dataFlavor);
    }

    public static Object get(Transferable transferable, DataFlavor dataFlavor) {
        if (null != transferable && transferable.isDataFlavorSupported(dataFlavor)) {
            try {
                return transferable.getTransferData(dataFlavor);
            }
            catch (UnsupportedFlavorException | IOException exception) {
                throw new UtilException(exception);
            }
        }
        return null;
    }

    public static void setStr(String string) {
        ClipboardUtil.set(new StringSelection(string));
    }

    public static String getStr() {
        return (String)ClipboardUtil.get(DataFlavor.stringFlavor);
    }

    public static String getStr(Transferable transferable) {
        return (String)ClipboardUtil.get(transferable, DataFlavor.stringFlavor);
    }

    public static void setImage(Image image) {
        ClipboardUtil.set(new ImageSelection(image), null);
    }

    public static Image getImage() {
        return (Image)ClipboardUtil.get(DataFlavor.imageFlavor);
    }

    public static Image getImage(Transferable transferable) {
        return (Image)ClipboardUtil.get(transferable, DataFlavor.imageFlavor);
    }

    public static void listen(ClipboardListener clipboardListener) {
        ClipboardUtil.listen(clipboardListener, true);
    }

    public static void listen(ClipboardListener clipboardListener, boolean bl) {
        ClipboardUtil.listen(10, 100L, clipboardListener, bl);
    }

    public static void listen(int n2, long l2, ClipboardListener clipboardListener, boolean bl) {
        ClipboardMonitor.INSTANCE.setTryCount(n2).setDelay(l2).addListener(clipboardListener).listen(bl);
    }
}

