/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.net.url;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.collection.IterUtil;
import com.ccb.core.convert.Convert;
import com.ccb.core.map.MapUtil;
import com.ccb.core.map.TableMap;
import com.ccb.core.util.StrUtil;
import com.ccb.core.util.URLUtil;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;

public class UrlQuery {
    private final TableMap query;

    public static UrlQuery of(Map map) {
        return new UrlQuery(map);
    }

    public static UrlQuery of(String string, Charset charset) {
        UrlQuery urlQuery = new UrlQuery();
        urlQuery.parse(string, charset);
        return urlQuery;
    }

    public UrlQuery() {
        this(null);
    }

    public UrlQuery(Map map) {
        if (MapUtil.isNotEmpty(map)) {
            this.query = new TableMap(map.size());
            this.addAll(map);
        } else {
            this.query = new TableMap(16);
        }
    }

    public UrlQuery add(CharSequence charSequence, Object object) {
        this.query.put(charSequence, UrlQuery.toStr(object));
        return this;
    }

    public UrlQuery addAll(Map map) {
        if (MapUtil.isNotEmpty(map)) {
            map.forEach(this::add);
        }
        return this;
    }

    public UrlQuery parse(String string, Charset charset) {
        int n2;
        if (StrUtil.isBlank(string)) {
            return this;
        }
        int n3 = string.indexOf(63);
        if (n3 > -1 && StrUtil.isBlank(string = StrUtil.subSuf(string, n3 + 1))) {
            return this;
        }
        int n4 = string.length();
        String string2 = null;
        int n5 = 0;
        block4: for (n2 = 0; n2 < n4; ++n2) {
            char c2 = string.charAt(n2);
            switch (c2) {
                case '=': {
                    if (null != string2) continue block4;
                    string2 = string.substring(n5, n2);
                    n5 = n2 + 1;
                    continue block4;
                }
                case '&': {
                    this.addParam(string2, string.substring(n5, n2), charset);
                    string2 = null;
                    if (n2 + 4 < n4 && "amp;".equals(string.substring(n2 + 1, n2 + 5))) {
                        n2 += 4;
                    }
                    n5 = n2 + 1;
                }
            }
        }
        this.addParam(string2, string.substring(n5, n2), charset);
        return this;
    }

    public Map getQueryMap() {
        return MapUtil.unmodifiable(this.query);
    }

    public CharSequence get(CharSequence charSequence) {
        if (MapUtil.isEmpty(this.query)) {
            return null;
        }
        return (CharSequence)this.query.get(charSequence);
    }

    public String build(Charset charset) {
        if (MapUtil.isEmpty(this.query)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Map.Entry entry : this.query) {
            CharSequence charSequence;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("&");
            }
            if (!StrUtil.isNotEmpty(charSequence = (CharSequence)entry.getKey())) continue;
            stringBuilder.append(URLUtil.encodeAll(StrUtil.str(charSequence), charset));
            CharSequence charSequence2 = (CharSequence)entry.getValue();
            if (null == charSequence2) continue;
            stringBuilder.append("=").append(URLUtil.encodeAll(StrUtil.str(charSequence2), charset));
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.build(null);
    }

    private static String toStr(Object object) {
        String string = object instanceof Iterable ? CollUtil.join((Iterable)object, (CharSequence)",") : (object instanceof Iterator ? IterUtil.join((Iterator)object, (CharSequence)",") : Convert.toStr(object));
        return string;
    }

    private void addParam(String string, String string2, Charset charset) {
        if (null != string) {
            String string3 = URLUtil.decode(string, charset);
            this.query.put(string3, StrUtil.nullToEmpty(URLUtil.decode(string2, charset)));
        } else if (null != string2) {
            this.query.put(URLUtil.decode(string2, charset), (Object)null);
        }
    }
}

