/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.net.url;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.util.StrUtil;
import com.ccb.core.util.URLUtil;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class UrlPath {
    private List segments;
    private boolean withEngTag;

    public static UrlPath of(String string, Charset charset) {
        UrlPath urlPath = new UrlPath();
        urlPath.parse(string, charset);
        return urlPath;
    }

    public UrlPath setWithEndTag(boolean bl) {
        this.withEngTag = bl;
        return this;
    }

    public List getSegments() {
        return this.segments;
    }

    public String getSegment(int n2) {
        if (null == this.segments || n2 >= this.segments.size()) {
            return null;
        }
        return (String)this.segments.get(n2);
    }

    public UrlPath add(CharSequence charSequence) {
        this.add(charSequence, false);
        return this;
    }

    public UrlPath addBefore(CharSequence charSequence) {
        this.add(charSequence, true);
        return this;
    }

    public UrlPath parse(String string, Charset charset) {
        UrlPath urlPath = new UrlPath();
        if (StrUtil.isNotEmpty(string)) {
            if (StrUtil.endWith((CharSequence)(string = string.trim()), '/')) {
                this.withEngTag = true;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            while (stringTokenizer.hasMoreTokens()) {
                this.add(URLUtil.decode(stringTokenizer.nextToken(), charset));
            }
        }
        return urlPath;
    }

    public String build(Charset charset) {
        if (CollUtil.isEmpty(this.segments)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.segments) {
            stringBuilder.append('/').append(URLUtil.encodeAll(string, charset));
        }
        if (this.withEngTag || StrUtil.isEmpty(stringBuilder)) {
            stringBuilder.append('/');
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.build(null);
    }

    private void add(CharSequence charSequence, boolean bl) {
        String string = UrlPath.fixSegment(charSequence);
        if (null == string) {
            return;
        }
        if (this.segments == null) {
            this.segments = new LinkedList();
        }
        if (bl) {
            this.segments.add(0, string);
        } else {
            this.segments.add(string);
        }
    }

    private static String fixSegment(CharSequence charSequence) {
        if (StrUtil.isEmpty(charSequence) || "/".contentEquals(charSequence)) {
            return null;
        }
        String string = StrUtil.str(charSequence);
        string = StrUtil.trim(string);
        string = StrUtil.removePrefix(string, "/");
        string = StrUtil.removeSuffix(string, "/");
        string = StrUtil.trim(string);
        return string;
    }
}

