/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.net;

import com.ccb.core.util.HexUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.BitSet;

public class URLEncoder
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final URLEncoder DEFAULT = URLEncoder.createDefault();
    public static final URLEncoder QUERY = URLEncoder.createQuery();
    public static final URLEncoder ALL = URLEncoder.createAll();
    private final BitSet safeCharacters;
    private boolean encodeSpaceAsPlus = false;

    public static URLEncoder createDefault() {
        URLEncoder uRLEncoder = new URLEncoder();
        uRLEncoder.addSafeCharacter('-');
        uRLEncoder.addSafeCharacter('.');
        uRLEncoder.addSafeCharacter('_');
        uRLEncoder.addSafeCharacter('~');
        uRLEncoder.addSafeCharacter('!');
        uRLEncoder.addSafeCharacter('$');
        uRLEncoder.addSafeCharacter('&');
        uRLEncoder.addSafeCharacter('\'');
        uRLEncoder.addSafeCharacter('(');
        uRLEncoder.addSafeCharacter(')');
        uRLEncoder.addSafeCharacter('*');
        uRLEncoder.addSafeCharacter('+');
        uRLEncoder.addSafeCharacter(',');
        uRLEncoder.addSafeCharacter(';');
        uRLEncoder.addSafeCharacter('=');
        uRLEncoder.addSafeCharacter(':');
        uRLEncoder.addSafeCharacter('@');
        uRLEncoder.addSafeCharacter('/');
        return uRLEncoder;
    }

    public static URLEncoder createQuery() {
        URLEncoder uRLEncoder = new URLEncoder();
        uRLEncoder.setEncodeSpaceAsPlus(true);
        uRLEncoder.addSafeCharacter('*');
        uRLEncoder.addSafeCharacter('-');
        uRLEncoder.addSafeCharacter('.');
        uRLEncoder.addSafeCharacter('_');
        uRLEncoder.addSafeCharacter('=');
        uRLEncoder.addSafeCharacter('&');
        return uRLEncoder;
    }

    public static URLEncoder createAll() {
        URLEncoder uRLEncoder = new URLEncoder();
        uRLEncoder.addSafeCharacter('*');
        uRLEncoder.addSafeCharacter('-');
        uRLEncoder.addSafeCharacter('.');
        uRLEncoder.addSafeCharacter('_');
        return uRLEncoder;
    }

    public URLEncoder() {
        this(new BitSet(256));
        char c2;
        for (c2 = 'a'; c2 <= 'z'; c2 = (char)((char)(c2 + '\u0001'))) {
            this.addSafeCharacter(c2);
        }
        for (c2 = 'A'; c2 <= 'Z'; c2 = (char)(c2 + '\u0001')) {
            this.addSafeCharacter(c2);
        }
        for (c2 = '0'; c2 <= '9'; c2 = (char)(c2 + '\u0001')) {
            this.addSafeCharacter(c2);
        }
    }

    private URLEncoder(BitSet bitSet) {
        this.safeCharacters = bitSet;
    }

    public void addSafeCharacter(char c2) {
        this.safeCharacters.set(c2);
    }

    public void removeSafeCharacter(char c2) {
        this.safeCharacters.clear(c2);
    }

    public void setEncodeSpaceAsPlus(boolean bl) {
        this.encodeSpaceAsPlus = bl;
    }

    public String encode(String string, Charset charset) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, charset);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            byte[] byArray;
            char c2 = string.charAt(i2);
            if (this.safeCharacters.get(c2)) {
                stringBuilder.append(c2);
                continue;
            }
            if (this.encodeSpaceAsPlus && c2 == ' ') {
                stringBuilder.append('+');
                continue;
            }
            try {
                outputStreamWriter.write(c2);
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                byteArrayOutputStream.reset();
                continue;
            }
            for (byte by : byArray = byteArrayOutputStream.toByteArray()) {
                stringBuilder.append('%');
                HexUtil.appendHex(stringBuilder, by, false);
            }
            byteArrayOutputStream.reset();
        }
        return stringBuilder.toString();
    }
}

