/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.net;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.exceptions.UtilException;
import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.IoUtil;
import com.ccb.core.lang.Filter;
import com.ccb.core.net.Ipv4Util;
import com.ccb.core.util.RandomUtil;
import com.ccb.core.util.StrUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.HttpCookie;
import java.net.IDN;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class NetUtil {
    public static final String LOCAL_IP = "127.0.0.1";
    public static String localhostName;
    public static final int PORT_RANGE_MIN = 1024;
    public static final int PORT_RANGE_MAX = 65535;

    public static String longToIpv4(long l2) {
        return Ipv4Util.longToIpv4(l2);
    }

    public static long ipv4ToLong(String string) {
        return Ipv4Util.ipv4ToLong(string);
    }

    public static boolean isUsableLocalPort(int n2) {
        Throwable throwable;
        Closeable closeable;
        if (!NetUtil.isValidPort(n2)) {
            return false;
        }
        try {
            closeable = new ServerSocket(n2);
            throwable = null;
            try {
                ((ServerSocket)closeable).setReuseAddress(true);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (closeable != null) {
                    if (throwable != null) {
                        try {
                            ((ServerSocket)closeable).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((ServerSocket)closeable).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            return false;
        }
        try {
            closeable = new DatagramSocket(n2);
            throwable = null;
            try {
                ((DatagramSocket)closeable).setReuseAddress(true);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (closeable != null) {
                    if (throwable != null) {
                        try {
                            ((DatagramSocket)closeable).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((DatagramSocket)closeable).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static boolean isValidPort(int n2) {
        return n2 >= 0 && n2 <= 65535;
    }

    public static int getUsableLocalPort() {
        return NetUtil.getUsableLocalPort(1024);
    }

    public static int getUsableLocalPort(int n2) {
        return NetUtil.getUsableLocalPort(n2, 65535);
    }

    public static int getUsableLocalPort(int n2, int n3) {
        int n4 = n3 + 1;
        for (int i2 = n2; i2 < n4; ++i2) {
            int n5 = RandomUtil.randomInt(n2, n4);
            if (!NetUtil.isUsableLocalPort(n5)) continue;
            return n5;
        }
        throw new UtilException("Could not find an available port in the range [{}, {}] after {} attempts", n2, n3, n3 - n2);
    }

    public static TreeSet getUsableLocalPorts(int n2, int n3, int n4) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n5 = 0;
        while (++n5 <= n2 + 100 && treeSet.size() < n2) {
            treeSet.add(NetUtil.getUsableLocalPort(n3, n4));
        }
        if (treeSet.size() != n2) {
            throw new UtilException("Could not find {} available  ports in the range [{}, {}]", n2, n3, n4);
        }
        return treeSet;
    }

    public static boolean isInnerIP(String string) {
        long l2 = NetUtil.ipv4ToLong(string);
        long l3 = NetUtil.ipv4ToLong("10.0.0.0");
        long l4 = NetUtil.ipv4ToLong("10.255.255.255");
        long l5 = NetUtil.ipv4ToLong("172.16.0.0");
        long l6 = NetUtil.ipv4ToLong("172.31.255.255");
        long l7 = NetUtil.ipv4ToLong("192.168.0.0");
        long l8 = NetUtil.ipv4ToLong("192.168.255.255");
        boolean bl = NetUtil.isInner(l2, l3, l4) || NetUtil.isInner(l2, l5, l6) || NetUtil.isInner(l2, l7, l8) || string.equals(LOCAL_IP);
        return bl;
    }

    public static String toAbsoluteUrl(String string, String string2) {
        try {
            URL uRL = new URL(string);
            return new URL(uRL, string2).toString();
        }
        catch (Exception exception) {
            throw new UtilException(exception, "To absolute url [{}] base [{}] error!", string2, string);
        }
    }

    public static String hideIpPart(String string) {
        return StrUtil.builder(string.length()).append(string, 0, string.lastIndexOf(".") + 1).append("*").toString();
    }

    public static String hideIpPart(long l2) {
        return NetUtil.hideIpPart(NetUtil.longToIpv4(l2));
    }

    public static InetSocketAddress buildInetSocketAddress(String string, int n2) {
        int n3;
        String string2;
        int n4;
        if (StrUtil.isBlank(string)) {
            string = LOCAL_IP;
        }
        if ((n4 = string.indexOf(":")) != -1) {
            string2 = string.substring(0, n4);
            n3 = Integer.parseInt(string.substring(n4 + 1));
        } else {
            string2 = string;
            n3 = n2;
        }
        return new InetSocketAddress(string2, n3);
    }

    public static String getIpByHost(String string) {
        try {
            return InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    public static NetworkInterface getNetworkInterface(String string) {
        Enumeration<NetworkInterface> enumeration;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            return null;
        }
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            if (null == networkInterface || !string.equals(networkInterface.getName())) continue;
            return networkInterface;
        }
        return null;
    }

    public static Collection getNetworkInterfaces() {
        Enumeration<NetworkInterface> enumeration;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            return null;
        }
        return CollUtil.addAll(new ArrayList(), enumeration);
    }

    public static LinkedHashSet localIpv4s() {
        LinkedHashSet linkedHashSet = NetUtil.localAddressList(inetAddress -> inetAddress instanceof Inet4Address);
        return NetUtil.toIpList(linkedHashSet);
    }

    public static LinkedHashSet localIpv6s() {
        LinkedHashSet linkedHashSet = NetUtil.localAddressList(inetAddress -> inetAddress instanceof Inet6Address);
        return NetUtil.toIpList(linkedHashSet);
    }

    public static LinkedHashSet toIpList(Set set) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (InetAddress inetAddress : set) {
            linkedHashSet.add(inetAddress.getHostAddress());
        }
        return linkedHashSet;
    }

    public static LinkedHashSet localIps() {
        LinkedHashSet linkedHashSet = NetUtil.localAddressList(null);
        return NetUtil.toIpList(linkedHashSet);
    }

    public static LinkedHashSet localAddressList(Filter filter) {
        Enumeration<NetworkInterface> enumeration;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            throw new UtilException(socketException);
        }
        if (enumeration == null) {
            throw new UtilException("Get network interface error!");
        }
        LinkedHashSet<InetAddress> linkedHashSet = new LinkedHashSet<InetAddress>();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                if (inetAddress == null || null != filter && !filter.accept(inetAddress)) continue;
                linkedHashSet.add(inetAddress);
            }
        }
        return linkedHashSet;
    }

    public static String getLocalhostStr() {
        InetAddress inetAddress = NetUtil.getLocalhost();
        if (null != inetAddress) {
            return inetAddress.getHostAddress();
        }
        return null;
    }

    public static InetAddress getLocalhost() {
        LinkedHashSet linkedHashSet = NetUtil.localAddressList(inetAddress -> false == inetAddress.isLoopbackAddress() && false == inetAddress.isSiteLocalAddress() && inetAddress instanceof Inet4Address);
        if (CollUtil.isNotEmpty(linkedHashSet)) {
            return (InetAddress)CollUtil.get(linkedHashSet, 0);
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static String getLocalMacAddress() {
        return NetUtil.getMacAddress(NetUtil.getLocalhost());
    }

    public static String getMacAddress(InetAddress inetAddress) {
        return NetUtil.getMacAddress(inetAddress, "-");
    }

    public static String getMacAddress(InetAddress inetAddress, String string) {
        Object object;
        if (null == inetAddress) {
            return null;
        }
        byte[] byArray = null;
        try {
            object = NetworkInterface.getByInetAddress(inetAddress);
            if (null != object) {
                byArray = ((NetworkInterface)object).getHardwareAddress();
            }
        }
        catch (SocketException socketException) {
            throw new UtilException(socketException);
        }
        if (null != byArray) {
            object = new StringBuilder();
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                String string2;
                if (i2 != 0) {
                    ((StringBuilder)object).append(string);
                }
                ((StringBuilder)object).append((string2 = Integer.toHexString(byArray[i2] & 0xFF)).length() == 1 ? 0 + string2 : string2);
            }
            return ((StringBuilder)object).toString();
        }
        return null;
    }

    public static String getLocalHostName() {
        if (StrUtil.isNotBlank(localhostName)) {
            return localhostName;
        }
        InetAddress inetAddress = NetUtil.getLocalhost();
        if (null != inetAddress) {
            String string = inetAddress.getHostName();
            if (StrUtil.isEmpty(string)) {
                string = inetAddress.getHostAddress();
            }
            localhostName = string;
        }
        return localhostName;
    }

    public static InetSocketAddress createAddress(String string, int n2) {
        if (StrUtil.isBlank(string)) {
            return new InetSocketAddress(n2);
        }
        return new InetSocketAddress(string, n2);
    }

    public static void netCat(String string, int n2, boolean bl, ByteBuffer byteBuffer) {
        try (SocketChannel socketChannel = SocketChannel.open(NetUtil.createAddress(string, n2));){
            socketChannel.configureBlocking(bl);
            socketChannel.write(byteBuffer);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static void netCat(String string, int n2, byte[] byArray) {
        OutputStream outputStream = null;
        try (Socket socket = new Socket(string, n2);){
            outputStream = socket.getOutputStream();
            outputStream.write(byArray);
            outputStream.flush();
        }
        catch (IOException iOException) {
            try {
                throw new IORuntimeException(iOException);
            }
            catch (Throwable throwable) {
                IoUtil.close(outputStream);
                throw throwable;
            }
        }
        IoUtil.close(outputStream);
    }

    public static boolean isInRange(String string, String string2) {
        String string3;
        String[] stringArray;
        int n2;
        int n3;
        int n4;
        String[] stringArray2 = StrUtil.splitToArray(string, '.');
        int n5 = Integer.parseInt(stringArray2[0]) << 24 | Integer.parseInt(stringArray2[1]) << 16 | Integer.parseInt(stringArray2[2]) << 8 | Integer.parseInt(stringArray2[3]);
        return (n5 & (n4 = -1 << 32 - (n3 = Integer.parseInt(string2.replaceAll(".*/", ""))))) == ((n2 = Integer.parseInt((stringArray = (string3 = string2.replaceAll("/.*", "")).split("\\."))[0]) << 24 | Integer.parseInt(stringArray[1]) << 16 | Integer.parseInt(stringArray[2]) << 8 | Integer.parseInt(stringArray[3])) & n4);
    }

    public static String idnToASCII(String string) {
        return IDN.toASCII(string);
    }

    public static String getMultistageReverseProxyIp(String string) {
        if (string != null && string.indexOf(",") > 0) {
            String[] stringArray;
            for (String string2 : stringArray = string.trim().split(",")) {
                if (NetUtil.isUnknown(string2)) continue;
                string = string2;
                break;
            }
        }
        return string;
    }

    public static boolean isUnknow(String string) {
        return NetUtil.isUnknown(string);
    }

    public static boolean isUnknown(String string) {
        return StrUtil.isBlank(string) || "unknown".equalsIgnoreCase(string);
    }

    public static boolean ping(String string) {
        return NetUtil.ping(string, 200);
    }

    public static boolean ping(String string, int n2) {
        try {
            return InetAddress.getByName(string).isReachable(n2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static List parseCookies(String string) {
        if (StrUtil.isBlank(string)) {
            return Collections.emptyList();
        }
        return HttpCookie.parse(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isOpen(InetSocketAddress inetSocketAddress, int n2) {
        try (Socket socket = new Socket();){
            socket.connect(inetSocketAddress, n2);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isInner(long l2, long l3, long l4) {
        return l2 >= l3 && l2 <= l4;
    }
}

