/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.math;

import com.ccb.core.util.NumberUtil;
import com.ccb.core.util.StrUtil;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Stack;

public class Calculator {
    private final Stack postfixStack = new Stack();
    private final Stack opStack = new Stack();
    private final int[] operatPriority = new int[]{0, 3, 2, 1, -1, 1, 0, 2};

    public static double conversion(String string) {
        Calculator calculator = new Calculator();
        string = Calculator.transform(string);
        return calculator.calculate(string);
    }

    private static String transform(String string) {
        string = StrUtil.cleanBlank(string);
        string = StrUtil.removeSuffix(string, "=");
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] != '-') continue;
            if (i2 == 0) {
                cArray[i2] = 126;
                continue;
            }
            char c2 = cArray[i2 - 1];
            if (c2 != '+' && c2 != '-' && c2 != '*' && c2 != '/' && c2 != '(' && c2 != 'E' && c2 != 'e') continue;
            cArray[i2] = 126;
        }
        if (cArray[0] == '~' || cArray[1] == '(') {
            cArray[0] = 45;
            return "0" + new String(cArray);
        }
        return new String(cArray);
    }

    public double calculate(String string) {
        Stack<String> stack = new Stack<String>();
        this.prepare(string);
        Collections.reverse(this.postfixStack);
        while (!this.postfixStack.isEmpty()) {
            String string2 = (String)this.postfixStack.pop();
            if (!this.isOperator(string2.charAt(0))) {
                string2 = string2.replace("~", "-");
                stack.push(string2);
                continue;
            }
            String string3 = (String)stack.pop();
            String string4 = (String)stack.pop();
            string4 = string4.replace("~", "-");
            string3 = string3.replace("~", "-");
            BigDecimal bigDecimal = this.calculate(string4, string3, string2.charAt(0));
            stack.push(bigDecimal.toString());
        }
        return Double.parseDouble((String)stack.pop());
    }

    private void prepare(String string) {
        this.opStack.push(Character.valueOf(','));
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (this.isOperator(c2)) {
                if (n3 > 0) {
                    this.postfixStack.push(new String(cArray, n2, n3));
                }
                char c3 = ((Character)this.opStack.peek()).charValue();
                if (c2 == ')') {
                    while (((Character)this.opStack.peek()).charValue() != '(') {
                        this.postfixStack.push(String.valueOf(this.opStack.pop()));
                    }
                    this.opStack.pop();
                } else {
                    while (c2 != '(' && c3 != ',' && this.compare(c2, c3)) {
                        this.postfixStack.push(String.valueOf(this.opStack.pop()));
                        c3 = ((Character)this.opStack.peek()).charValue();
                    }
                    this.opStack.push(Character.valueOf(c2));
                }
                n3 = 0;
                n2 = i2 + 1;
                continue;
            }
            ++n3;
        }
        if (n3 > 1 || n3 == 1 && !this.isOperator(cArray[n2])) {
            this.postfixStack.push(new String(cArray, n2, n3));
        }
        while (((Character)this.opStack.peek()).charValue() != ',') {
            this.postfixStack.push(String.valueOf(this.opStack.pop()));
        }
    }

    private boolean isOperator(char c2) {
        return c2 == '+' || c2 == '-' || c2 == '*' || c2 == '/' || c2 == '(' || c2 == ')';
    }

    public boolean compare(char c2, char c3) {
        boolean bl = false;
        if (this.operatPriority[c3 - 40] >= this.operatPriority[c2 - 40]) {
            bl = true;
        }
        return bl;
    }

    private BigDecimal calculate(String string, String string2, char c2) {
        BigDecimal bigDecimal;
        switch (c2) {
            case '+': {
                bigDecimal = NumberUtil.add(string, string2);
                break;
            }
            case '-': {
                bigDecimal = NumberUtil.sub(string, string2);
                break;
            }
            case '*': {
                bigDecimal = NumberUtil.mul(string, string2);
                break;
            }
            case '/': {
                bigDecimal = NumberUtil.div(string, string2);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + c2);
            }
        }
        return bigDecimal;
    }
}

