/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.map;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.collection.ListUtil;
import com.ccb.core.map.TableMap$1;
import com.ccb.core.map.TableMap$Entry;
import com.ccb.core.util.ObjectUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableMap
implements Serializable,
Iterable,
Map {
    private static final long serialVersionUID = 1L;
    private final List keys;
    private final List values;

    public TableMap(int n2) {
        this.keys = new ArrayList(n2);
        this.values = new ArrayList(n2);
    }

    public TableMap(Object[] objectArray, Object[] objectArray2) {
        this.keys = CollUtil.toList(objectArray);
        this.values = CollUtil.toList(objectArray2);
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return CollUtil.isEmpty(this.keys);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.keys.contains(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.values.contains(object);
    }

    public Object get(Object object) {
        int n2 = this.keys.indexOf(object);
        if (n2 > -1 && n2 < this.values.size()) {
            return this.values.get(n2);
        }
        return null;
    }

    public Object getKey(Object object) {
        int n2 = this.values.indexOf(object);
        if (n2 > -1 && n2 < this.keys.size()) {
            return this.keys.get(n2);
        }
        return null;
    }

    public List getValues(Object object) {
        return CollUtil.getAny(this.values, ListUtil.indexOfAll(this.keys, object2 -> ObjectUtil.equal(object2, object)));
    }

    public List getKeys(Object object) {
        return CollUtil.getAny(this.keys, ListUtil.indexOfAll(this.values, object2 -> ObjectUtil.equal(object2, object)));
    }

    public Object put(Object object, Object object2) {
        this.keys.add(object);
        this.values.add(object2);
        return null;
    }

    public Object remove(Object object) {
        int n2 = this.keys.indexOf(object);
        if (n2 > -1) {
            this.keys.remove(n2);
            if (n2 < this.values.size()) {
                this.values.remove(n2);
            }
        }
        return null;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.values.clear();
    }

    public Set keySet() {
        return new HashSet(this.keys);
    }

    public Collection values() {
        return Collections.unmodifiableList(this.values);
    }

    public Set entrySet() {
        LinkedHashSet<TableMap$Entry> linkedHashSet = new LinkedHashSet<TableMap$Entry>();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            linkedHashSet.add(new TableMap$Entry(this.keys.get(i2), this.values.get(i2)));
        }
        return linkedHashSet;
    }

    public Iterator iterator() {
        return new TableMap$1(this);
    }

    public String toString() {
        return "TableMap{keys=" + this.keys + ", values=" + this.values + '}';
    }

    static /* synthetic */ List access$000(TableMap tableMap) {
        return tableMap.keys;
    }

    static /* synthetic */ List access$100(TableMap tableMap) {
        return tableMap.values;
    }
}

