/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang.tree;

import com.ccb.core.lang.Assert;
import com.ccb.core.lang.tree.Node;
import com.ccb.core.lang.tree.TreeNodeConfig;
import com.ccb.core.lang.tree.TreeUtil;
import com.ccb.core.util.ObjectUtil;
import java.util.LinkedHashMap;
import java.util.List;

public class Tree
extends LinkedHashMap
implements Node {
    private static final long serialVersionUID = 1L;
    private final TreeNodeConfig treeNodeConfig;
    private Tree parent;

    public Tree() {
        this((TreeNodeConfig)null);
    }

    public Tree(TreeNodeConfig treeNodeConfig) {
        this.treeNodeConfig = (TreeNodeConfig)ObjectUtil.defaultIfNull(treeNodeConfig, TreeNodeConfig.DEFAULT_CONFIG);
    }

    public Tree getParent() {
        return this.parent;
    }

    public Tree getNode(Object object) {
        return TreeUtil.getNode(this, object);
    }

    public List getParentsName(Object object, boolean bl) {
        return TreeUtil.getParentsName(this.getNode(object), bl);
    }

    public List getParentsName(boolean bl) {
        return TreeUtil.getParentsName(this, bl);
    }

    public Tree setParent(Tree tree) {
        this.parent = tree;
        if (null != tree) {
            this.setParentId(tree.getId());
        }
        return this;
    }

    @Override
    public Object getId() {
        return this.get(this.treeNodeConfig.getIdKey());
    }

    @Override
    public Tree setId(Object object) {
        this.put(this.treeNodeConfig.getIdKey(), object);
        return this;
    }

    @Override
    public Object getParentId() {
        return this.get(this.treeNodeConfig.getParentIdKey());
    }

    @Override
    public Tree setParentId(Object object) {
        this.put(this.treeNodeConfig.getParentIdKey(), object);
        return this;
    }

    @Override
    public CharSequence getName() {
        return (CharSequence)this.get(this.treeNodeConfig.getNameKey());
    }

    @Override
    public Tree setName(CharSequence charSequence) {
        this.put(this.treeNodeConfig.getNameKey(), charSequence);
        return this;
    }

    @Override
    public Comparable getWeight() {
        return (Comparable)this.get(this.treeNodeConfig.getWeightKey());
    }

    @Override
    public Tree setWeight(Comparable comparable) {
        this.put(this.treeNodeConfig.getWeightKey(), comparable);
        return this;
    }

    public List getChildren() {
        return (List)this.get(this.treeNodeConfig.getChildrenKey());
    }

    public void setChildren(List list) {
        this.put(this.treeNodeConfig.getChildrenKey(), list);
    }

    public void putExtra(String string, Object object) {
        Assert.notEmpty(string, "Key must be not empty !", new Object[0]);
        this.put(string, object);
    }
}

