/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang.reflect;

import com.ccb.core.lang.SimpleCache;
import com.ccb.core.util.TypeUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class ActualTypeMapperPool {
    private static final SimpleCache CACHE = new SimpleCache();

    public static Map get(Type type) {
        return (Map)CACHE.get(type, () -> ActualTypeMapperPool.createTypeMap(type));
    }

    public static Type getActualType(Type type, TypeVariable typeVariable) {
        Map map = ActualTypeMapperPool.get(type);
        Type type2 = (Type)map.get(typeVariable);
        while (type2 instanceof TypeVariable) {
            type2 = (Type)map.get(type2);
        }
        return type2;
    }

    public static Type[] getActualTypes(Type type, Type ... typeArray) {
        Type[] typeArray2 = new Type[typeArray.length];
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            typeArray2[i2] = typeArray[i2] instanceof TypeVariable ? ActualTypeMapperPool.getActualType(type, (TypeVariable)typeArray[i2]) : typeArray[i2];
        }
        return typeArray2;
    }

    private static Map createTypeMap(Type type) {
        ParameterizedType parameterizedType;
        HashMap hashMap = new HashMap();
        while (null != type && null != (parameterizedType = TypeUtil.toParameterizedType(type))) {
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            Class clazz = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] typeVariableArray = clazz.getTypeParameters();
            for (int i2 = 0; i2 < typeVariableArray.length; ++i2) {
                hashMap.put(typeVariableArray[i2], typeArray[i2]);
            }
            type = clazz;
        }
        return hashMap;
    }
}

