/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang.mutable;

import com.ccb.core.lang.mutable.Mutable;
import com.ccb.core.util.NumberUtil;

public class MutableFloat
extends Number
implements Mutable,
Comparable {
    private static final long serialVersionUID = 1L;
    private float value;

    public MutableFloat() {
    }

    public MutableFloat(float f2) {
        this.value = f2;
    }

    public MutableFloat(Number number) {
        this(number.floatValue());
    }

    public MutableFloat(String string) {
        this.value = Float.parseFloat(string);
    }

    @Override
    public Float get() {
        return Float.valueOf(this.value);
    }

    public void set(float f2) {
        this.value = f2;
    }

    public void set(Number number) {
        this.value = number.floatValue();
    }

    public MutableFloat increment() {
        this.value += 1.0f;
        return this;
    }

    public MutableFloat decrement() {
        this.value -= 1.0f;
        return this;
    }

    public MutableFloat add(float f2) {
        this.value += f2;
        return this;
    }

    public MutableFloat add(Number number) {
        this.value += number.floatValue();
        return this;
    }

    public MutableFloat subtract(float f2) {
        this.value -= f2;
        return this;
    }

    public MutableFloat subtract(Number number) {
        this.value -= number.floatValue();
        return this;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof MutableFloat) {
            return Float.floatToIntBits(((MutableFloat)object).value) == Float.floatToIntBits(this.value);
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public int compareTo(MutableFloat mutableFloat) {
        return NumberUtil.compare(this.value, mutableFloat.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

