/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang.hash;

import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.StrUtil;
import java.io.Serializable;
import java.nio.charset.Charset;

public class MurmurHash
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int C1_32 = -862048943;
    private static final int C2_32 = 461845907;
    private static final int R1_32 = 15;
    private static final int R2_32 = 13;
    private static final int M_32 = 5;
    private static final int N_32 = -430675100;
    private static final long C1 = -8663945395140668459L;
    private static final long C2 = 5545529020109919103L;
    private static final int R1 = 31;
    private static final int R2 = 27;
    private static final int R3 = 33;
    private static final int M = 5;
    private static final int N1 = 1390208809;
    private static final int N2 = 944331445;
    private static final int DEFAULT_SEED = 0;
    private static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;

    public static int hash32(CharSequence charSequence) {
        return MurmurHash.hash32(StrUtil.bytes(charSequence, DEFAULT_CHARSET));
    }

    public static int hash32(byte[] byArray) {
        return MurmurHash.hash32(byArray, byArray.length, 0);
    }

    public static int hash32(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n3;
        int n7 = n2 >> 2;
        for (n5 = 0; n5 < n7; ++n5) {
            n4 = n5 << 2;
            int n8 = byArray[n4] & 0xFF | (byArray[n4 + 1] & 0xFF) << 8 | (byArray[n4 + 2] & 0xFF) << 16 | (byArray[n4 + 3] & 0xFF) << 24;
            n8 *= -862048943;
            n8 = Integer.rotateLeft(n8, 15);
            n6 ^= (n8 *= 461845907);
            n6 = Integer.rotateLeft(n6, 13) * 5 + -430675100;
        }
        n5 = n7 << 2;
        n4 = 0;
        switch (n2 - n5) {
            case 3: {
                n4 ^= byArray[n5 + 2] << 16;
            }
            case 2: {
                n4 ^= byArray[n5 + 1] << 8;
            }
            case 1: {
                n4 ^= byArray[n5];
                n4 *= -862048943;
                n4 = Integer.rotateLeft(n4, 15);
                n6 ^= (n4 *= 461845907);
            }
        }
        n6 ^= n2;
        n6 ^= n6 >>> 16;
        n6 *= -2048144789;
        n6 ^= n6 >>> 13;
        n6 *= -1028477387;
        n6 ^= n6 >>> 16;
        return n6;
    }

    public static long hash64(CharSequence charSequence) {
        return MurmurHash.hash64(StrUtil.bytes(charSequence, DEFAULT_CHARSET));
    }

    public static long hash64(byte[] byArray) {
        return MurmurHash.hash64(byArray, byArray.length, 0);
    }

    public static long hash64(byte[] byArray, int n2, int n3) {
        long l2 = n3;
        int n4 = n2 >> 3;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 << 3;
            long l3 = (long)byArray[n5] & 0xFFL | ((long)byArray[n5 + 1] & 0xFFL) << 8 | ((long)byArray[n5 + 2] & 0xFFL) << 16 | ((long)byArray[n5 + 3] & 0xFFL) << 24 | ((long)byArray[n5 + 4] & 0xFFL) << 32 | ((long)byArray[n5 + 5] & 0xFFL) << 40 | ((long)byArray[n5 + 6] & 0xFFL) << 48 | ((long)byArray[n5 + 7] & 0xFFL) << 56;
            l3 *= -8663945395140668459L;
            l3 = Long.rotateLeft(l3, 31);
            l2 ^= (l3 *= 5545529020109919103L);
            l2 = Long.rotateLeft(l2, 27) * 5L + 1390208809L;
        }
        long l4 = 0L;
        int n6 = n4 << 3;
        switch (n2 - n6) {
            case 7: {
                l4 ^= ((long)byArray[n6 + 6] & 0xFFL) << 48;
            }
            case 6: {
                l4 ^= ((long)byArray[n6 + 5] & 0xFFL) << 40;
            }
            case 5: {
                l4 ^= ((long)byArray[n6 + 4] & 0xFFL) << 32;
            }
            case 4: {
                l4 ^= ((long)byArray[n6 + 3] & 0xFFL) << 24;
            }
            case 3: {
                l4 ^= ((long)byArray[n6 + 2] & 0xFFL) << 16;
            }
            case 2: {
                l4 ^= ((long)byArray[n6 + 1] & 0xFFL) << 8;
            }
            case 1: {
                l4 ^= (long)byArray[n6] & 0xFFL;
                l4 *= -8663945395140668459L;
                l4 = Long.rotateLeft(l4, 31);
                l2 ^= (l4 *= 5545529020109919103L);
            }
        }
        l2 ^= (long)n2;
        l2 = MurmurHash.fmix64(l2);
        return l2;
    }

    public static long[] hash128(CharSequence charSequence) {
        return MurmurHash.hash128(StrUtil.bytes(charSequence, DEFAULT_CHARSET));
    }

    public static long[] hash128(byte[] byArray) {
        return MurmurHash.hash128(byArray, byArray.length, 0);
    }

    public static long[] hash128(byte[] byArray, int n2, int n3) {
        long l2;
        long l3 = n3;
        long l4 = n3;
        int n4 = n2 >> 4;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = i2 << 4;
            l2 = (long)byArray[n5] & 0xFFL | ((long)byArray[n5 + 1] & 0xFFL) << 8 | ((long)byArray[n5 + 2] & 0xFFL) << 16 | ((long)byArray[n5 + 3] & 0xFFL) << 24 | ((long)byArray[n5 + 4] & 0xFFL) << 32 | ((long)byArray[n5 + 5] & 0xFFL) << 40 | ((long)byArray[n5 + 6] & 0xFFL) << 48 | ((long)byArray[n5 + 7] & 0xFFL) << 56;
            long l5 = (long)byArray[n5 + 8] & 0xFFL | ((long)byArray[n5 + 9] & 0xFFL) << 8 | ((long)byArray[n5 + 10] & 0xFFL) << 16 | ((long)byArray[n5 + 11] & 0xFFL) << 24 | ((long)byArray[n5 + 12] & 0xFFL) << 32 | ((long)byArray[n5 + 13] & 0xFFL) << 40 | ((long)byArray[n5 + 14] & 0xFFL) << 48 | ((long)byArray[n5 + 15] & 0xFFL) << 56;
            l2 *= -8663945395140668459L;
            l2 = Long.rotateLeft(l2, 31);
            l3 ^= (l2 *= 5545529020109919103L);
            l3 = Long.rotateLeft(l3, 27);
            l3 += l4;
            l3 = l3 * 5L + 1390208809L;
            l5 *= 5545529020109919103L;
            l5 = Long.rotateLeft(l5, 33);
            l4 ^= (l5 *= -8663945395140668459L);
            l4 = Long.rotateLeft(l4, 31);
            l4 += l3;
            l4 = l4 * 5L + 944331445L;
        }
        long l6 = 0L;
        l2 = 0L;
        int n6 = n4 << 4;
        switch (n2 - n6) {
            case 15: {
                l2 ^= (long)(byArray[n6 + 14] & 0xFF) << 48;
            }
            case 14: {
                l2 ^= (long)(byArray[n6 + 13] & 0xFF) << 40;
            }
            case 13: {
                l2 ^= (long)(byArray[n6 + 12] & 0xFF) << 32;
            }
            case 12: {
                l2 ^= (long)(byArray[n6 + 11] & 0xFF) << 24;
            }
            case 11: {
                l2 ^= (long)(byArray[n6 + 10] & 0xFF) << 16;
            }
            case 10: {
                l2 ^= (long)(byArray[n6 + 9] & 0xFF) << 8;
            }
            case 9: {
                l2 ^= (long)(byArray[n6 + 8] & 0xFF);
                l2 *= 5545529020109919103L;
                l2 = Long.rotateLeft(l2, 33);
                l4 ^= (l2 *= -8663945395140668459L);
            }
            case 8: {
                l6 ^= (long)(byArray[n6 + 7] & 0xFF) << 56;
            }
            case 7: {
                l6 ^= (long)(byArray[n6 + 6] & 0xFF) << 48;
            }
            case 6: {
                l6 ^= (long)(byArray[n6 + 5] & 0xFF) << 40;
            }
            case 5: {
                l6 ^= (long)(byArray[n6 + 4] & 0xFF) << 32;
            }
            case 4: {
                l6 ^= (long)(byArray[n6 + 3] & 0xFF) << 24;
            }
            case 3: {
                l6 ^= (long)(byArray[n6 + 2] & 0xFF) << 16;
            }
            case 2: {
                l6 ^= (long)(byArray[n6 + 1] & 0xFF) << 8;
            }
            case 1: {
                l6 ^= (long)(byArray[n6] & 0xFF);
                l6 *= -8663945395140668459L;
                l6 = Long.rotateLeft(l6, 31);
                l3 ^= (l6 *= 5545529020109919103L);
            }
        }
        l3 ^= (long)n2;
        l3 += (l4 ^= (long)n2);
        l4 += l3;
        l3 = MurmurHash.fmix64(l3);
        l4 = MurmurHash.fmix64(l4);
        l3 += l4;
        return new long[]{l3, l4 += l3};
    }

    private static long fmix64(long l2) {
        l2 ^= l2 >>> 33;
        l2 *= -49064778989728563L;
        l2 ^= l2 >>> 33;
        l2 *= -4265267296055464877L;
        l2 ^= l2 >>> 33;
        return l2;
    }
}

