/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang.caller;

import com.ccb.core.lang.caller.Caller;
import com.ccb.core.lang.caller.SecurityManagerCaller;
import com.ccb.core.lang.caller.StackTraceCaller;
import java.io.Serializable;

public class CallerUtil {
    private static final Caller INSTANCE = CallerUtil.tryCreateCaller();

    public static Class getCaller() {
        return INSTANCE.getCaller();
    }

    public static Class getCallerCaller() {
        return INSTANCE.getCallerCaller();
    }

    public static Class getCaller(int n2) {
        return INSTANCE.getCaller(n2);
    }

    public static boolean isCalledBy(Class clazz) {
        return INSTANCE.isCalledBy(clazz);
    }

    public static String getCallerMethodName(boolean bl) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
        String string = stackTraceElement.getMethodName();
        if (!bl) {
            return string;
        }
        return stackTraceElement.getClassName() + "." + string;
    }

    private static Caller tryCreateCaller() {
        Serializable serializable;
        try {
            serializable = new SecurityManagerCaller();
            if (null != serializable.getCaller() && null != serializable.getCallerCaller()) {
                return serializable;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        serializable = new StackTraceCaller();
        return serializable;
    }
}

