/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang;

import com.ccb.core.date.DateUtil;
import com.ccb.core.exceptions.ValidateException;
import com.ccb.core.lang.Assert;
import com.ccb.core.lang.PatternPool;
import com.ccb.core.util.CreditCodeUtil;
import com.ccb.core.util.IdcardUtil;
import com.ccb.core.util.NumberUtil;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.ReUtil;
import com.ccb.core.util.StrUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validator {
    public static final Pattern GENERAL = PatternPool.GENERAL;
    public static final Pattern NUMBERS = PatternPool.NUMBERS;
    public static final Pattern GROUP_VAR = PatternPool.GROUP_VAR;
    public static final Pattern IPV4 = PatternPool.IPV4;
    public static final Pattern IPV6 = PatternPool.IPV6;
    public static final Pattern MONEY = PatternPool.MONEY;
    public static final Pattern EMAIL = PatternPool.EMAIL;
    public static final Pattern MOBILE = PatternPool.MOBILE;
    public static final Pattern CITIZEN_ID = PatternPool.CITIZEN_ID;
    public static final Pattern ZIP_CODE = PatternPool.ZIP_CODE;
    public static final Pattern BIRTHDAY = PatternPool.BIRTHDAY;
    public static final Pattern URL = PatternPool.URL;
    public static final Pattern URL_HTTP = PatternPool.URL_HTTP;
    public static final Pattern GENERAL_WITH_CHINESE = PatternPool.GENERAL_WITH_CHINESE;
    public static final Pattern UUID = PatternPool.UUID;
    public static final Pattern UUID_SIMPLE = PatternPool.UUID_SIMPLE;
    public static final Pattern PLATE_NUMBER = PatternPool.PLATE_NUMBER;

    public static boolean isTrue(boolean bl) {
        return bl;
    }

    public static boolean isFalse(boolean bl) {
        return false == bl;
    }

    public static boolean validateTrue(boolean bl, String string, Object ... objectArray) {
        if (Validator.isFalse(bl)) {
            throw new ValidateException(string, objectArray);
        }
        return true;
    }

    public static boolean validateFalse(boolean bl, String string, Object ... objectArray) {
        if (Validator.isTrue(bl)) {
            throw new ValidateException(string, objectArray);
        }
        return false;
    }

    public static boolean isNull(Object object) {
        return null == object;
    }

    public static boolean isNotNull(Object object) {
        return null != object;
    }

    public static Object validateNull(Object object, String string, Object ... objectArray) {
        if (Validator.isNotNull(object)) {
            throw new ValidateException(string, objectArray);
        }
        return null;
    }

    public static Object validateNotNull(Object object, String string, Object ... objectArray) {
        if (Validator.isNull(object)) {
            throw new ValidateException(string, objectArray);
        }
        return object;
    }

    public static boolean isEmpty(Object object) {
        return null == object || object instanceof String && StrUtil.isEmpty((String)object);
    }

    public static boolean isNotEmpty(Object object) {
        return false == Validator.isEmpty(object);
    }

    public static Object validateEmpty(Object object, String string) {
        if (Validator.isNotEmpty(object)) {
            throw new ValidateException(string);
        }
        return object;
    }

    public static Object validateNotEmpty(Object object, String string) {
        if (Validator.isEmpty(object)) {
            throw new ValidateException(string);
        }
        return object;
    }

    public static boolean equal(Object object, Object object2) {
        return ObjectUtil.equal(object, object2);
    }

    public static Object validateEqual(Object object, Object object2, String string) {
        if (!Validator.equal(object, object2)) {
            throw new ValidateException(string);
        }
        return object;
    }

    public static void validateNotEqual(Object object, Object object2, String string) {
        if (Validator.equal(object, object2)) {
            throw new ValidateException(string);
        }
    }

    public static void validateNotEmptyAndEqual(Object object, Object object2, String string) {
        Validator.validateNotEmpty(object, string);
        Validator.validateEqual(object, object2, string);
    }

    public static void validateNotEmptyAndNotEqual(Object object, Object object2, String string) {
        Validator.validateNotEmpty(object, string);
        Validator.validateNotEqual(object, object2, string);
    }

    public static CharSequence validateMatchRegex(String string, CharSequence charSequence, String string2) {
        if (!Validator.isMatchRegex(string, charSequence)) {
            throw new ValidateException(string2);
        }
        return charSequence;
    }

    public static boolean isMactchRegex(Pattern pattern, CharSequence charSequence) {
        return ReUtil.isMatch(pattern, charSequence);
    }

    public static boolean isMactchRegex(String string, CharSequence charSequence) {
        return ReUtil.isMatch(string, charSequence);
    }

    public static boolean isMatchRegex(Pattern pattern, CharSequence charSequence) {
        return ReUtil.isMatch(pattern, charSequence);
    }

    public static boolean isMatchRegex(String string, CharSequence charSequence) {
        return ReUtil.isMatch(string, charSequence);
    }

    public static boolean isGeneral(CharSequence charSequence) {
        return Validator.isMatchRegex(GENERAL, charSequence);
    }

    public static CharSequence validateGeneral(CharSequence charSequence, String string) {
        if (!Validator.isGeneral(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isGeneral(CharSequence charSequence, int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        String string = "^\\w{" + n2 + "," + n3 + "}$";
        if (n3 <= 0) {
            string = "^\\w{" + n2 + ",}$";
        }
        return Validator.isMatchRegex(string, charSequence);
    }

    public static CharSequence validateGeneral(CharSequence charSequence, int n2, int n3, String string) {
        if (!Validator.isGeneral(charSequence, n2, n3)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isGeneral(CharSequence charSequence, int n2) {
        return Validator.isGeneral(charSequence, n2, 0);
    }

    public static CharSequence validateGeneral(CharSequence charSequence, int n2, String string) {
        return Validator.validateGeneral(charSequence, n2, 0, string);
    }

    public static boolean isLetter(CharSequence charSequence) {
        return StrUtil.isAllCharMatch(charSequence, Character::isLetter);
    }

    public static CharSequence validateLetter(CharSequence charSequence, String string) {
        if (!Validator.isLetter(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isUpperCase(CharSequence charSequence) {
        return StrUtil.isAllCharMatch(charSequence, Character::isUpperCase);
    }

    public static CharSequence validateUpperCase(CharSequence charSequence, String string) {
        if (!Validator.isUpperCase(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isLowerCase(CharSequence charSequence) {
        return StrUtil.isAllCharMatch(charSequence, Character::isLowerCase);
    }

    public static CharSequence validateLowerCase(CharSequence charSequence, String string) {
        if (!Validator.isLowerCase(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isNumber(CharSequence charSequence) {
        return NumberUtil.isNumber(charSequence);
    }

    public static String validateNumber(String string, String string2) {
        if (!Validator.isNumber(string)) {
            throw new ValidateException(string2);
        }
        return string;
    }

    public static boolean isWord(CharSequence charSequence) {
        return Validator.isMatchRegex(PatternPool.WORD, charSequence);
    }

    public static CharSequence validateWord(CharSequence charSequence, String string) {
        if (!Validator.isWord(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isMoney(CharSequence charSequence) {
        return Validator.isMatchRegex(MONEY, charSequence);
    }

    public static CharSequence validateMoney(CharSequence charSequence, String string) {
        if (!Validator.isMoney(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isZipCode(CharSequence charSequence) {
        return Validator.isMatchRegex(ZIP_CODE, charSequence);
    }

    public static CharSequence validateZipCode(CharSequence charSequence, String string) {
        if (!Validator.isZipCode(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isEmail(CharSequence charSequence) {
        return Validator.isMatchRegex(EMAIL, charSequence);
    }

    public static CharSequence validateEmail(CharSequence charSequence, String string) {
        if (!Validator.isEmail(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isMobile(CharSequence charSequence) {
        return Validator.isMatchRegex(MOBILE, charSequence);
    }

    public static CharSequence validateMobile(CharSequence charSequence, String string) {
        if (!Validator.isMobile(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isCitizenId(CharSequence charSequence) {
        return IdcardUtil.isValidCard(String.valueOf(charSequence));
    }

    public static CharSequence validateCitizenIdNumber(CharSequence charSequence, String string) {
        if (!Validator.isCitizenId(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isBirthday(int n2, int n3, int n4) {
        int n5 = DateUtil.thisYear();
        if (n2 < 1900 || n2 > n5) {
            return false;
        }
        if (n3 < 1 || n3 > 12) {
            return false;
        }
        if (n4 < 1 || n4 > 31) {
            return false;
        }
        if (n4 == 31 && (n3 == 4 || n3 == 6 || n3 == 9 || n3 == 11)) {
            return false;
        }
        if (n3 == 2) {
            return n4 < 29 || n4 == 29 && DateUtil.isLeapYear(n2);
        }
        return true;
    }

    public static boolean isBirthday(CharSequence charSequence) {
        Matcher matcher = BIRTHDAY.matcher(charSequence);
        if (matcher.find()) {
            int n2 = Integer.parseInt(matcher.group(1));
            int n3 = Integer.parseInt(matcher.group(3));
            int n4 = Integer.parseInt(matcher.group(5));
            return Validator.isBirthday(n2, n3, n4);
        }
        return false;
    }

    public static CharSequence validateBirthday(CharSequence charSequence, String string) {
        if (!Validator.isBirthday(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isIpv4(CharSequence charSequence) {
        return Validator.isMatchRegex(IPV4, charSequence);
    }

    public static CharSequence validateIpv4(CharSequence charSequence, String string) {
        if (!Validator.isIpv4(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isIpv6(CharSequence charSequence) {
        return Validator.isMatchRegex(IPV6, charSequence);
    }

    public static CharSequence validateIpv6(CharSequence charSequence, String string) {
        if (!Validator.isIpv6(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isMac(CharSequence charSequence) {
        return Validator.isMatchRegex(PatternPool.MAC_ADDRESS, charSequence);
    }

    public static CharSequence validateMac(CharSequence charSequence, String string) {
        if (!Validator.isMac(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isPlateNumber(CharSequence charSequence) {
        return Validator.isMatchRegex(PLATE_NUMBER, charSequence);
    }

    public static CharSequence validatePlateNumber(CharSequence charSequence, String string) {
        if (!Validator.isPlateNumber(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isUrl(CharSequence charSequence) {
        try {
            new URL(StrUtil.str(charSequence));
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    public static CharSequence validateUrl(CharSequence charSequence, String string) {
        if (!Validator.isUrl(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isChinese(CharSequence charSequence) {
        return Validator.isMatchRegex(PatternPool.CHINESES, charSequence);
    }

    public static boolean hasChinese(CharSequence charSequence) {
        return ReUtil.contains("[\u4e00-\u9fff]+", charSequence);
    }

    public static CharSequence validateChinese(CharSequence charSequence, String string) {
        if (!Validator.isChinese(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isGeneralWithChinese(CharSequence charSequence) {
        return Validator.isMatchRegex(GENERAL_WITH_CHINESE, charSequence);
    }

    public static CharSequence validateGeneralWithChinese(CharSequence charSequence, String string) {
        if (!Validator.isGeneralWithChinese(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isUUID(CharSequence charSequence) {
        return Validator.isMatchRegex(UUID, charSequence) || Validator.isMatchRegex(UUID_SIMPLE, charSequence);
    }

    public static CharSequence validateUUID(CharSequence charSequence, String string) {
        if (!Validator.isUUID(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isHex(CharSequence charSequence) {
        return Validator.isMatchRegex(PatternPool.HEX, charSequence);
    }

    public static CharSequence validateHex(CharSequence charSequence, String string) {
        if (!Validator.isHex(charSequence)) {
            throw new ValidateException(string);
        }
        return charSequence;
    }

    public static boolean isBetween(Number number, Number number2, Number number3) {
        Assert.notNull(number);
        Assert.notNull(number2);
        Assert.notNull(number3);
        double d2 = number.doubleValue();
        return d2 >= number2.doubleValue() && d2 <= number3.doubleValue();
    }

    public static void validateBetween(Number number, Number number2, Number number3, String string) {
        if (!Validator.isBetween(number, number2, number3)) {
            throw new ValidateException(string);
        }
    }

    public static boolean isCreditCode(CharSequence charSequence) {
        return CreditCodeUtil.isCreditCode(charSequence);
    }
}

