/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang;

import com.ccb.core.bean.BeanUtil;
import com.ccb.core.collection.CollUtil;
import com.ccb.core.convert.Convert;
import com.ccb.core.getter.BasicTypeGetter;
import com.ccb.core.lang.Assert;
import com.ccb.core.lang.Pair;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class Dict
extends LinkedHashMap
implements BasicTypeGetter {
    private static final long serialVersionUID = 6135423866861206530L;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    private boolean caseInsensitive;

    public static Dict create() {
        return new Dict();
    }

    public static Dict parse(Object object) {
        return Dict.create().parseBean(object);
    }

    public static Dict of(Pair ... pairArray) {
        Dict dict = Dict.create();
        for (Pair pair : pairArray) {
            dict.put((String)pair.getKey(), pair.getValue());
        }
        return dict;
    }

    public static Dict of(Object ... objectArray) {
        Dict dict = Dict.create();
        String string = null;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 % 2 == 0) {
                string = Convert.toStr(objectArray[i2]);
                continue;
            }
            dict.put(string, objectArray[i2]);
        }
        return dict;
    }

    public Dict() {
        this(false);
    }

    public Dict(boolean bl) {
        this(16, bl);
    }

    public Dict(int n2) {
        this(n2, false);
    }

    public Dict(int n2, boolean bl) {
        this(n2, 0.75f, bl);
    }

    public Dict(int n2, float f2) {
        this(n2, f2, false);
    }

    public Dict(int n2, float f2, boolean bl) {
        super(n2, f2);
        this.caseInsensitive = bl;
    }

    public Dict(Map map) {
        super(null == map ? new HashMap() : map);
    }

    public Object toBean(Object object) {
        return this.toBean(object, false);
    }

    public Object toBeanIgnoreCase(Object object) {
        BeanUtil.fillBeanWithMapIgnoreCase(this, object, false);
        return object;
    }

    public Object toBean(Object object, boolean bl) {
        BeanUtil.fillBeanWithMap((Map)this, object, bl, false);
        return object;
    }

    public Object toBeanWithCamelCase(Object object) {
        BeanUtil.fillBeanWithMap((Map)this, object, true, false);
        return object;
    }

    public Object toBean(Class clazz) {
        return BeanUtil.toBean(this, clazz);
    }

    public Object toBeanIgnoreCase(Class clazz) {
        return BeanUtil.toBeanIgnoreCase(this, clazz, false);
    }

    public Dict parseBean(Object object) {
        Assert.notNull(object, "Bean class must be not null", new Object[0]);
        this.putAll(BeanUtil.beanToMap(object));
        return this;
    }

    public Dict parseBean(Object object, boolean bl, boolean bl2) {
        Assert.notNull(object, "Bean class must be not null", new Object[0]);
        this.putAll(BeanUtil.beanToMap(object, bl, bl2));
        return this;
    }

    public void removeEqual(Dict dict, String ... stringArray) {
        HashSet hashSet = CollUtil.newHashSet(stringArray);
        for (Map.Entry entry : dict.entrySet()) {
            Object object;
            if (hashSet.contains(entry.getKey()) || null == (object = this.get(entry.getKey())) || !object.equals(entry.getValue())) continue;
            this.remove(entry.getKey());
        }
    }

    public Dict filter(String ... stringArray) {
        Dict dict = new Dict(stringArray.length, 1.0f);
        for (String string : stringArray) {
            if (!this.containsKey(string)) continue;
            dict.put(string, this.get(string));
        }
        return dict;
    }

    public Dict set(String string, Object object) {
        this.put(string, object);
        return this;
    }

    public Dict setIgnoreNull(String string, Object object) {
        if (null != string && null != object) {
            this.set(string, object);
        }
        return this;
    }

    public Object getObj(String string) {
        return super.get(string);
    }

    public Object getBean(String string) {
        return this.get(string, null);
    }

    public Object get(String string, Object object) {
        Object object2 = this.get(string);
        return object2 != null ? object2 : object;
    }

    public String getStr(String string) {
        return Convert.toStr(this.get(string), null);
    }

    public Integer getInt(String string) {
        return Convert.toInt(this.get(string), null);
    }

    public Long getLong(String string) {
        return Convert.toLong(this.get(string), null);
    }

    public Float getFloat(String string) {
        return Convert.toFloat(this.get(string), null);
    }

    public Short getShort(String string) {
        return Convert.toShort(this.get(string), null);
    }

    public Character getChar(String string) {
        return Convert.toChar(this.get(string), null);
    }

    public Double getDouble(String string) {
        return Convert.toDouble(this.get(string), null);
    }

    public Byte getByte(String string) {
        return Convert.toByte(this.get(string), null);
    }

    public Boolean getBool(String string) {
        return Convert.toBool(this.get(string), null);
    }

    public BigDecimal getBigDecimal(String string) {
        return Convert.toBigDecimal(this.get(string));
    }

    public BigInteger getBigInteger(String string) {
        return Convert.toBigInteger(this.get(string));
    }

    public Enum getEnum(Class clazz, String string) {
        return Convert.toEnum(clazz, this.get(string));
    }

    public byte[] getBytes(String string) {
        return (byte[])this.get(string, null);
    }

    public Date getDate(String string) {
        return (Date)this.get(string, null);
    }

    public Time getTime(String string) {
        return (Time)this.get(string, null);
    }

    public Timestamp getTimestamp(String string) {
        return (Timestamp)this.get(string, null);
    }

    public Number getNumber(String string) {
        return (Number)this.get(string, null);
    }

    @Override
    public Object get(Object object) {
        return super.get(this.customKey((String)object));
    }

    @Override
    public Object put(String string, Object object) {
        return super.put(this.customKey(string), object);
    }

    @Override
    public void putAll(Map map) {
        map.forEach(this::put);
    }

    @Override
    public Dict clone() {
        return (Dict)super.clone();
    }

    private String customKey(String string) {
        if (this.caseInsensitive && null != string) {
            string = string.toLowerCase();
        }
        return string;
    }
}

