/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang;

import com.ccb.core.convert.Convert;
import com.ccb.core.lang.Console;
import com.ccb.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConsoleTable {
    private static final char ROW_LINE = '-';
    private static final char COLUMN_LINE = '|';
    private static final char CORNER = '+';
    private static final char SPACE = '\u3000';
    private static final char LF = '\n';
    private final List HEADER_LIST = new ArrayList();
    private final List BODY_LIST = new ArrayList();
    private List columnCharNumber;

    public static ConsoleTable create() {
        return new ConsoleTable();
    }

    public ConsoleTable addHeader(String ... stringArray) {
        if (this.columnCharNumber == null) {
            this.columnCharNumber = new ArrayList<Integer>(Collections.nCopies(stringArray.length, 0));
        }
        ArrayList arrayList = new ArrayList();
        this.fillColumns(arrayList, stringArray);
        this.HEADER_LIST.add(arrayList);
        return this;
    }

    public ConsoleTable addBody(String ... stringArray) {
        ArrayList arrayList = new ArrayList();
        this.BODY_LIST.add(arrayList);
        this.fillColumns(arrayList, stringArray);
        return this;
    }

    private void fillColumns(List list, String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            String string2 = Convert.toSBC(string);
            list.add(string2);
            int n2 = string2.length();
            if (n2 <= (Integer)this.columnCharNumber.get(i2)) continue;
            this.columnCharNumber.set(i2, n2);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.fillBorder(stringBuilder);
        this.fillRow(stringBuilder, this.HEADER_LIST);
        this.fillBorder(stringBuilder);
        this.fillRow(stringBuilder, this.BODY_LIST);
        this.fillBorder(stringBuilder);
        return stringBuilder.toString();
    }

    private void fillRow(StringBuilder stringBuilder, List list) {
        for (List list2 : list) {
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                if (i2 == 0) {
                    stringBuilder.append('|');
                }
                String string = (String)list2.get(i2);
                stringBuilder.append('\u3000');
                stringBuilder.append(string);
                stringBuilder.append('\u3000');
                int n2 = string.length();
                int n3 = (Integer)this.columnCharNumber.get(i2);
                if (n3 > n2) {
                    for (int i3 = 0; i3 < n3 - n2; ++i3) {
                        stringBuilder.append('\u3000');
                    }
                }
                stringBuilder.append('|');
            }
            stringBuilder.append('\n');
        }
    }

    private void fillBorder(StringBuilder stringBuilder) {
        stringBuilder.append('+');
        for (Integer n2 : this.columnCharNumber) {
            stringBuilder.append(Convert.toSBC(StrUtil.fillAfter("", '-', n2 + 2)));
            stringBuilder.append('+');
        }
        stringBuilder.append('\n');
    }

    public void print() {
        Console.print(this.toString());
    }
}

