/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang;

import com.ccb.core.lang.Assert;
import com.ccb.core.lang.ConsoleTable;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.StrUtil;
import java.util.Scanner;

public class Console {
    private static final String TEMPLATE_VAR = "{}";

    public static void log() {
        System.out.println();
    }

    public static void log(Object object) {
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            Console.log(throwable, throwable.getMessage(), new Object[0]);
        } else {
            Console.log(TEMPLATE_VAR, object);
        }
    }

    public static void log(Object object, Object ... objectArray) {
        if (ArrayUtil.isEmpty(objectArray)) {
            Console.log(object);
        } else {
            Console.log(Console.buildTemplateSplitBySpace(objectArray.length + 1), ArrayUtil.insert(objectArray, 0, object));
        }
    }

    public static void log(String string, Object ... objectArray) {
        if (ArrayUtil.isEmpty(objectArray) || StrUtil.contains((CharSequence)string, TEMPLATE_VAR)) {
            Console.logInternal(string, objectArray);
        } else {
            Console.logInternal(Console.buildTemplateSplitBySpace(objectArray.length + 1), ArrayUtil.insert(objectArray, 0, new Object[]{string}));
        }
    }

    public static void log(Throwable throwable, String string, Object ... objectArray) {
        System.out.println(StrUtil.format((CharSequence)string, objectArray));
        if (null != throwable) {
            throwable.printStackTrace();
            System.out.flush();
        }
    }

    private static void logInternal(String string, Object ... objectArray) {
        Console.log(null, string, objectArray);
    }

    public static void table(ConsoleTable consoleTable) {
        Console.print(consoleTable.toString());
    }

    public static void print(Object object) {
        Console.print(TEMPLATE_VAR, object);
    }

    public static void print(Object object, Object ... objectArray) {
        if (ArrayUtil.isEmpty(objectArray)) {
            Console.print(object);
        } else {
            Console.print(Console.buildTemplateSplitBySpace(objectArray.length + 1), ArrayUtil.insert(objectArray, 0, object));
        }
    }

    public static void print(String string, Object ... objectArray) {
        if (ArrayUtil.isEmpty(objectArray) || StrUtil.contains((CharSequence)string, TEMPLATE_VAR)) {
            Console.printInternal(string, objectArray);
        } else {
            Console.printInternal(Console.buildTemplateSplitBySpace(objectArray.length + 1), ArrayUtil.insert(objectArray, 0, new Object[]{string}));
        }
    }

    public static void printProgress(char c2, int n2) {
        Console.print("{}{}", Character.valueOf('\r'), StrUtil.repeat(c2, n2));
    }

    public static void printProgress(char c2, int n2, double d2) {
        Assert.isTrue(d2 >= 0.0 && d2 <= 1.0, "Rate must between 0 and 1 (both include)", new Object[0]);
        Console.printProgress(c2, (int)((double)n2 * d2));
    }

    private static void printInternal(String string, Object ... objectArray) {
        System.out.print(StrUtil.format((CharSequence)string, objectArray));
    }

    public static void error() {
        System.err.println();
    }

    public static void error(Object object) {
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            Console.error(throwable, throwable.getMessage(), new Object[0]);
        } else {
            Console.error(TEMPLATE_VAR, object);
        }
    }

    public static void error(Object object, Object ... objectArray) {
        if (ArrayUtil.isEmpty(objectArray)) {
            Console.error(object);
        } else {
            Console.error(Console.buildTemplateSplitBySpace(objectArray.length + 1), ArrayUtil.insert(objectArray, 0, object));
        }
    }

    public static void error(String string, Object ... objectArray) {
        if (ArrayUtil.isEmpty(objectArray) || StrUtil.contains((CharSequence)string, TEMPLATE_VAR)) {
            Console.errorInternal(string, objectArray);
        } else {
            Console.errorInternal(Console.buildTemplateSplitBySpace(objectArray.length + 1), ArrayUtil.insert(objectArray, 0, new Object[]{string}));
        }
    }

    public static void error(Throwable throwable, String string, Object ... objectArray) {
        System.err.println(StrUtil.format((CharSequence)string, objectArray));
        if (null != throwable) {
            throwable.printStackTrace(System.err);
            System.err.flush();
        }
    }

    private static void errorInternal(String string, Object ... objectArray) {
        Console.error(null, string, objectArray);
    }

    public static Scanner scanner() {
        return new Scanner(System.in);
    }

    public static String input() {
        return Console.scanner().next();
    }

    public static String where() {
        StackTraceElement stackTraceElement = new Throwable().getStackTrace()[1];
        String string = stackTraceElement.getClassName();
        String string2 = stackTraceElement.getMethodName();
        String string3 = stackTraceElement.getFileName();
        Integer n2 = stackTraceElement.getLineNumber();
        return String.format("%s.%s(%s:%s)", string, string2, string3, n2);
    }

    public static Integer lineNumber() {
        return new Throwable().getStackTrace()[1].getLineNumber();
    }

    private static String buildTemplateSplitBySpace(int n2) {
        return StrUtil.repeatAndJoin(TEMPLATE_VAR, n2, " ");
    }
}

