/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang;

import com.ccb.core.lang.hash.Hash32;
import com.ccb.core.util.HashUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConsistentHash
implements Serializable {
    private static final long serialVersionUID = 1L;
    Hash32 hashFunc;
    private final int numberOfReplicas;
    private final SortedMap circle = new TreeMap();

    public ConsistentHash(int n2, Collection collection) {
        this.numberOfReplicas = n2;
        this.hashFunc = object -> HashUtil.fnvHash(object.toString());
        for (Object e2 : collection) {
            this.add(e2);
        }
    }

    public ConsistentHash(Hash32 hash32, int n2, Collection collection) {
        this.numberOfReplicas = n2;
        this.hashFunc = hash32;
        for (Object e2 : collection) {
            this.add(e2);
        }
    }

    public void add(Object object) {
        for (int i2 = 0; i2 < this.numberOfReplicas; ++i2) {
            this.circle.put(this.hashFunc.hash32(object.toString() + i2), object);
        }
    }

    public void remove(Object object) {
        for (int i2 = 0; i2 < this.numberOfReplicas; ++i2) {
            this.circle.remove(this.hashFunc.hash32(object.toString() + i2));
        }
    }

    public Object get(Object object) {
        if (this.circle.isEmpty()) {
            return null;
        }
        int n2 = this.hashFunc.hash32(object);
        if (!this.circle.containsKey(n2)) {
            SortedMap sortedMap = this.circle.tailMap(n2);
            n2 = sortedMap.isEmpty() ? ((Integer)this.circle.firstKey()).intValue() : sortedMap.firstKey().intValue();
        }
        return this.circle.get(n2);
    }
}

