/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.map.MapUtil;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.StrUtil;
import java.util.Map;
import java.util.function.Supplier;

public class Assert {
    public static void isTrue(boolean bl, Supplier supplier) {
        if (!bl) {
            throw (Throwable)supplier.get();
        }
    }

    public static void isTrue(boolean bl, String string, Object ... objectArray) {
        Assert.isTrue(bl, () -> new IllegalArgumentException(StrUtil.format((CharSequence)string, objectArray)));
    }

    public static void isTrue(boolean bl) {
        Assert.isTrue(bl, "[Assertion failed] - this expression must be true", new Object[0]);
    }

    public static void isFalse(boolean bl, Supplier supplier) {
        if (bl) {
            throw (Throwable)supplier.get();
        }
    }

    public static void isFalse(boolean bl, String string, Object ... objectArray) {
        Assert.isFalse(bl, () -> new IllegalArgumentException(StrUtil.format((CharSequence)string, objectArray)));
    }

    public static void isFalse(boolean bl) {
        Assert.isFalse(bl, "[Assertion failed] - this expression must be false", new Object[0]);
    }

    public static void isNull(Object object, Supplier supplier) {
        if (null != object) {
            throw (Throwable)supplier.get();
        }
    }

    public static void isNull(Object object, String string, Object ... objectArray) {
        Assert.isNull(object, () -> new IllegalArgumentException(StrUtil.format((CharSequence)string, objectArray)));
    }

    public static void isNull(Object object) {
        Assert.isNull(object, "[Assertion failed] - the object argument must be null", new Object[0]);
    }

    public static Object notNull(Object object, Supplier supplier) {
        if (null == object) {
            throw (Throwable)supplier.get();
        }
        return object;
    }

    public static Object notNull(Object object, String string, Object ... objectArray) {
        return Assert.notNull(object, () -> new IllegalArgumentException(StrUtil.format((CharSequence)string, objectArray)));
    }

    public static Object notNull(Object object) {
        return Assert.notNull(object, "[Assertion failed] - this argument is required; it must not be null", new Object[0]);
    }

    public static CharSequence notEmpty(CharSequence charSequence, Supplier supplier) {
        if (StrUtil.isEmpty(charSequence)) {
            throw (Throwable)supplier.get();
        }
        return charSequence;
    }

    public static CharSequence notEmpty(CharSequence charSequence, String string, Object ... objectArray) {
        return Assert.notEmpty(charSequence, () -> new IllegalArgumentException(StrUtil.format((CharSequence)string, objectArray)));
    }

    public static CharSequence notEmpty(CharSequence charSequence) {
        return Assert.notEmpty(charSequence, "[Assertion failed] - this String argument must have length; it must not be null or empty", new Object[0]);
    }

    public static CharSequence notBlank(CharSequence charSequence, Supplier supplier) {
        if (StrUtil.isBlank(charSequence)) {
            throw (Throwable)supplier.get();
        }
        return charSequence;
    }

    public static CharSequence notBlank(CharSequence charSequence, String string, Object ... objectArray) {
        return Assert.notBlank(charSequence, () -> new IllegalArgumentException(StrUtil.format((CharSequence)string, objectArray)));
    }

    public static CharSequence notBlank(CharSequence charSequence) {
        return Assert.notBlank(charSequence, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank", new Object[0]);
    }

    public static CharSequence notContain(CharSequence charSequence, CharSequence charSequence2, Supplier supplier) {
        if (StrUtil.contains(charSequence, charSequence2)) {
            throw (Throwable)supplier.get();
        }
        return charSequence2;
    }

    public static String notContain(String string, String string2, String string3, Object ... objectArray) {
        return (String)Assert.notContain(string, string2, () -> new IllegalArgumentException(StrUtil.format((CharSequence)string3, objectArray)));
    }

    public static String notContain(String string, String string2) {
        return Assert.notContain(string, string2, "[Assertion failed] - this String argument must not contain the substring [{}]", string2);
    }

    public static Object[] notEmpty(Object[] objectArray, Supplier supplier) {
        if (ArrayUtil.isEmpty(objectArray)) {
            throw (Throwable)supplier.get();
        }
        return objectArray;
    }

    public static Object[] notEmpty(Object[] objectArray, String string, Object ... objectArray2) {
        return Assert.notEmpty(objectArray, () -> new IllegalArgumentException(StrUtil.format((CharSequence)string, objectArray2)));
    }

    public static Object[] notEmpty(Object[] objectArray) {
        return Assert.notEmpty(objectArray, "[Assertion failed] - this array must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static Object[] noNullElements(Object[] objectArray, Supplier supplier) {
        if (ArrayUtil.hasNull(objectArray)) {
            throw (Throwable)supplier.get();
        }
        return objectArray;
    }

    public static Object[] noNullElements(Object[] objectArray, String string, Object ... objectArray2) {
        return Assert.noNullElements(objectArray, () -> new IllegalArgumentException(StrUtil.format((CharSequence)string, objectArray2)));
    }

    public static Object[] noNullElements(Object[] objectArray) {
        return Assert.noNullElements(objectArray, "[Assertion failed] - this array must not contain any null elements", new Object[0]);
    }

    public static Iterable notEmpty(Iterable iterable, Supplier supplier) {
        if (CollUtil.isEmpty(iterable)) {
            throw (Throwable)supplier.get();
        }
        return iterable;
    }

    public static Iterable notEmpty(Iterable iterable, String string, Object ... objectArray) {
        return Assert.notEmpty(iterable, () -> new IllegalArgumentException(StrUtil.format((CharSequence)string, objectArray)));
    }

    public static Iterable notEmpty(Iterable iterable) {
        return Assert.notEmpty(iterable, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static Map notEmpty(Map map, Supplier supplier) {
        if (MapUtil.isEmpty(map)) {
            throw (Throwable)supplier.get();
        }
        return map;
    }

    public static Map notEmpty(Map map, String string, Object ... objectArray) {
        return Assert.notEmpty(map, () -> new IllegalArgumentException(StrUtil.format((CharSequence)string, objectArray)));
    }

    public static Map notEmpty(Map map) {
        return Assert.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least one entry", new Object[0]);
    }

    public static Object isInstanceOf(Class clazz, Object object) {
        return Assert.isInstanceOf(clazz, object, "Object [{}] is not instanceof [{}]", object, clazz);
    }

    public static Object isInstanceOf(Class clazz, Object object, String string, Object ... objectArray) {
        Assert.notNull(clazz, "Type to check against must not be null", new Object[0]);
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)string, objectArray));
        }
        return object;
    }

    public static void isAssignable(Class clazz, Class clazz2) {
        Assert.isAssignable(clazz, clazz2, "{} is not assignable to {})", clazz2, clazz);
    }

    public static void isAssignable(Class clazz, Class clazz2, String string, Object ... objectArray) {
        Assert.notNull(clazz, "Type to check against must not be null", new Object[0]);
        if (clazz2 == null || !clazz.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)string, objectArray));
        }
    }

    public static void state(boolean bl, Supplier supplier) {
        if (!bl) {
            throw new IllegalStateException((String)supplier.get());
        }
    }

    public static void state(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw new IllegalStateException(StrUtil.format((CharSequence)string, objectArray));
        }
    }

    public static void state(boolean bl) {
        Assert.state(bl, "[Assertion failed] - this state invariant must be true", new Object[0]);
    }

    public static int checkIndex(int n2, int n3) {
        return Assert.checkIndex(n2, n3, "[Assertion failed]", new Object[0]);
    }

    public static int checkIndex(int n2, int n3, String string, Object ... objectArray) {
        if (n2 < 0 || n2 >= n3) {
            throw new IndexOutOfBoundsException(Assert.badIndexMsg(n2, n3, string, objectArray));
        }
        return n2;
    }

    public static int checkBetween(int n2, int n3, int n4) {
        if (n2 < n3 || n2 > n4) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"Length must be between {} and {}.", n3, n4));
        }
        return n2;
    }

    public static long checkBetween(long l2, long l3, long l4) {
        if (l2 < l3 || l2 > l4) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"Length must be between {} and {}.", l3, l4));
        }
        return l2;
    }

    public static double checkBetween(double d2, double d3, double d4) {
        if (d2 < d3 || d2 > d4) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"Length must be between {} and {}.", d3, d4));
        }
        return d2;
    }

    public static Number checkBetween(Number number, Number number2, Number number3) {
        Assert.notNull(number);
        Assert.notNull(number2);
        Assert.notNull(number3);
        double d2 = number.doubleValue();
        double d3 = number2.doubleValue();
        double d4 = number3.doubleValue();
        if (d2 < d3 || d2 > d4) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"Length must be between {} and {}.", number2, number3));
        }
        return number;
    }

    private static String badIndexMsg(int n2, int n3, String string, Object ... objectArray) {
        if (n2 < 0) {
            return StrUtil.format((CharSequence)"{} ({}) must not be negative", StrUtil.format((CharSequence)string, objectArray), n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("negative size: " + n3);
        }
        return StrUtil.format((CharSequence)"{} ({}) must be less than size ({})", StrUtil.format((CharSequence)string, objectArray), n2, n3);
    }
}

