/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.watch;

import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.watch.WatchMonitor;
import com.ccb.core.io.watch.Watcher;
import com.ccb.core.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;

public class WatchUtil {
    public static WatchMonitor create(URL uRL, WatchEvent.Kind ... kindArray) {
        return WatchUtil.create(uRL, 0, kindArray);
    }

    public static WatchMonitor create(URL uRL, int n2, WatchEvent.Kind ... kindArray) {
        return WatchUtil.create(URLUtil.toURI(uRL), n2, kindArray);
    }

    public static WatchMonitor create(URI uRI, WatchEvent.Kind ... kindArray) {
        return WatchUtil.create(uRI, 0, kindArray);
    }

    public static WatchMonitor create(URI uRI, int n2, WatchEvent.Kind ... kindArray) {
        return WatchUtil.create(Paths.get(uRI), n2, kindArray);
    }

    public static WatchMonitor create(File file, WatchEvent.Kind ... kindArray) {
        return WatchUtil.create(file, 0, kindArray);
    }

    public static WatchMonitor create(File file, int n2, WatchEvent.Kind ... kindArray) {
        return WatchUtil.create(file.toPath(), n2, kindArray);
    }

    public static WatchMonitor create(String string, WatchEvent.Kind ... kindArray) {
        return WatchUtil.create(string, 0, kindArray);
    }

    public static WatchMonitor create(String string, int n2, WatchEvent.Kind ... kindArray) {
        return WatchUtil.create(Paths.get(string, new String[0]), n2, kindArray);
    }

    public static WatchMonitor create(Path path, WatchEvent.Kind ... kindArray) {
        return WatchUtil.create(path, 0, kindArray);
    }

    public static WatchMonitor create(Path path, int n2, WatchEvent.Kind ... kindArray) {
        return new WatchMonitor(path, n2, kindArray);
    }

    public static WatchMonitor createAll(URL uRL, Watcher watcher) {
        return WatchUtil.createAll(uRL, 0, watcher);
    }

    public static WatchMonitor createAll(URL uRL, int n2, Watcher watcher) {
        return WatchUtil.createAll(URLUtil.toURI(uRL), n2, watcher);
    }

    public static WatchMonitor createAll(URI uRI, Watcher watcher) {
        return WatchUtil.createAll(uRI, 0, watcher);
    }

    public static WatchMonitor createAll(URI uRI, int n2, Watcher watcher) {
        return WatchUtil.createAll(Paths.get(uRI), n2, watcher);
    }

    public static WatchMonitor createAll(File file, Watcher watcher) {
        return WatchUtil.createAll(file, 0, watcher);
    }

    public static WatchMonitor createAll(File file, int n2, Watcher watcher) {
        return WatchUtil.createAll(file.toPath(), 0, watcher);
    }

    public static WatchMonitor createAll(String string, Watcher watcher) {
        return WatchUtil.createAll(string, 0, watcher);
    }

    public static WatchMonitor createAll(String string, int n2, Watcher watcher) {
        return WatchUtil.createAll(Paths.get(string, new String[0]), n2, watcher);
    }

    public static WatchMonitor createAll(Path path, Watcher watcher) {
        return WatchUtil.createAll(path, 0, watcher);
    }

    public static WatchMonitor createAll(Path path, int n2, Watcher watcher) {
        WatchMonitor watchMonitor = WatchUtil.create(path, n2, WatchMonitor.EVENTS_ALL);
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }

    public static WatchMonitor createModify(URL uRL, Watcher watcher) {
        return WatchUtil.createModify(uRL, 0, watcher);
    }

    public static WatchMonitor createModify(URL uRL, int n2, Watcher watcher) {
        return WatchUtil.createModify(URLUtil.toURI(uRL), n2, watcher);
    }

    public static WatchMonitor createModify(URI uRI, Watcher watcher) {
        return WatchUtil.createModify(uRI, 0, watcher);
    }

    public static WatchMonitor createModify(URI uRI, int n2, Watcher watcher) {
        return WatchUtil.createModify(Paths.get(uRI), n2, watcher);
    }

    public static WatchMonitor createModify(File file, Watcher watcher) {
        return WatchUtil.createModify(file, 0, watcher);
    }

    public static WatchMonitor createModify(File file, int n2, Watcher watcher) {
        return WatchUtil.createModify(file.toPath(), 0, watcher);
    }

    public static WatchMonitor createModify(String string, Watcher watcher) {
        return WatchUtil.createModify(string, 0, watcher);
    }

    public static WatchMonitor createModify(String string, int n2, Watcher watcher) {
        return WatchUtil.createModify(Paths.get(string, new String[0]), n2, watcher);
    }

    public static WatchMonitor createModify(Path path, Watcher watcher) {
        return WatchUtil.createModify(path, 0, watcher);
    }

    public static WatchMonitor createModify(Path path, int n2, Watcher watcher) {
        WatchMonitor watchMonitor = WatchUtil.create(path, n2, WatchMonitor.ENTRY_MODIFY);
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }

    public static WatchKey register(Watchable watchable, WatchService watchService, WatchEvent.Kind ... kindArray) {
        try {
            return watchable.register(watchService, kindArray);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }
}

