/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.unit;

import com.ccb.core.io.unit.DataSize;
import com.ccb.core.util.StrUtil;

public enum DataUnit {
    BYTES("B", DataSize.ofBytes(1L)),
    KILOBYTES("KB", DataSize.ofKilobytes(1L)),
    MEGABYTES("MB", DataSize.ofMegabytes(1L)),
    GIGABYTES("GB", DataSize.ofGigabytes(1L)),
    TERABYTES("TB", DataSize.ofTerabytes(1L));

    public static final String[] UNIT_NAMES;
    private final String suffix;
    private final DataSize size;

    /*
     * WARNING - void declaration
     */
    private DataUnit() {
        void var4_1;
        void var3_2;
        this.suffix = var3_2;
        this.size = var4_1;
    }

    DataSize size() {
        return this.size;
    }

    public static DataUnit fromSuffix(String string) {
        for (DataUnit dataUnit : DataUnit.values()) {
            if (!StrUtil.startWithIgnoreCase(dataUnit.suffix, string)) continue;
            return dataUnit;
        }
        throw new IllegalArgumentException("Unknown data unit suffix '" + string + "'");
    }

    static {
        UNIT_NAMES = new String[]{"B", "kB", "MB", "GB", "TB", "EB"};
    }
}

