/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.unit;

import com.ccb.core.io.unit.DataUnit;
import com.ccb.core.lang.Assert;
import com.ccb.core.util.StrUtil;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DataSize
implements Comparable {
    private static final Pattern PATTERN = Pattern.compile("^([+-]?\\d+(\\.\\d+)?)([a-zA-Z]{0,2})$");
    private static final long BYTES_PER_KB = 1024L;
    private static final long BYTES_PER_MB = 0x100000L;
    private static final long BYTES_PER_GB = 0x40000000L;
    private static final long BYTES_PER_TB = 0x10000000000L;
    private final long bytes;

    private DataSize(long l2) {
        this.bytes = l2;
    }

    public static DataSize ofBytes(long l2) {
        return new DataSize(l2);
    }

    public static DataSize ofKilobytes(long l2) {
        return new DataSize(Math.multiplyExact(l2, 1024L));
    }

    public static DataSize ofMegabytes(long l2) {
        return new DataSize(Math.multiplyExact(l2, 0x100000L));
    }

    public static DataSize ofGigabytes(long l2) {
        return new DataSize(Math.multiplyExact(l2, 0x40000000L));
    }

    public static DataSize ofTerabytes(long l2) {
        return new DataSize(Math.multiplyExact(l2, 0x10000000000L));
    }

    public static DataSize of(long l2, DataUnit dataUnit) {
        if (null == dataUnit) {
            dataUnit = DataUnit.BYTES;
        }
        return new DataSize(Math.multiplyExact(l2, dataUnit.size().toBytes()));
    }

    public static DataSize of(BigDecimal bigDecimal, DataUnit dataUnit) {
        if (null == dataUnit) {
            dataUnit = DataUnit.BYTES;
        }
        return new DataSize(bigDecimal.multiply(new BigDecimal(dataUnit.size().toBytes())).longValue());
    }

    public static DataSize parse(CharSequence charSequence) {
        return DataSize.parse(charSequence, null);
    }

    public static DataSize parse(CharSequence charSequence, DataUnit dataUnit) {
        Assert.notNull(charSequence, "Text must not be null", new Object[0]);
        try {
            Matcher matcher = PATTERN.matcher(charSequence);
            Assert.state(matcher.matches(), "Does not match data size pattern", new Object[0]);
            DataUnit dataUnit2 = DataSize.determineDataUnit(matcher.group(3), dataUnit);
            return DataSize.of(new BigDecimal(matcher.group(1)), dataUnit2);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("'" + charSequence + "' is not a valid data size", exception);
        }
    }

    private static DataUnit determineDataUnit(String string, DataUnit dataUnit) {
        DataUnit dataUnit2 = dataUnit != null ? dataUnit : DataUnit.BYTES;
        return StrUtil.isNotEmpty(string) ? DataUnit.fromSuffix(string) : dataUnit2;
    }

    public boolean isNegative() {
        return this.bytes < 0L;
    }

    public long toBytes() {
        return this.bytes;
    }

    public long toKilobytes() {
        return this.bytes / 1024L;
    }

    public long toMegabytes() {
        return this.bytes / 0x100000L;
    }

    public long toGigabytes() {
        return this.bytes / 0x40000000L;
    }

    public long toTerabytes() {
        return this.bytes / 0x10000000000L;
    }

    public int compareTo(DataSize dataSize) {
        return Long.compare(this.bytes, dataSize.bytes);
    }

    public String toString() {
        return String.format("%dB", this.bytes);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DataSize dataSize = (DataSize)object;
        return this.bytes == dataSize.bytes;
    }

    public int hashCode() {
        return Long.hashCode(this.bytes);
    }
}

