/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.resource;

import com.ccb.core.io.FileUtil;
import com.ccb.core.io.IoUtil;
import com.ccb.core.io.resource.NoResourceException;
import com.ccb.core.io.resource.Resource;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.URLUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;

public class UrlResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    protected URL url;
    protected String name;

    public UrlResource(URL uRL) {
        this(uRL, null);
    }

    public UrlResource(URL uRL, String string) {
        this.url = uRL;
        this.name = (String)ObjectUtil.defaultIfNull(string, null != uRL ? FileUtil.getName(uRL.getPath()) : null);
    }

    public UrlResource(File file) {
        this.url = URLUtil.getURL(file);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public InputStream getStream() {
        if (null == this.url) {
            throw new NoResourceException("Resource URL is null!");
        }
        return URLUtil.getStream(this.url);
    }

    @Override
    public BufferedReader getReader(Charset charset) {
        return URLUtil.getReader(this.url, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readStr(Charset charset) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = this.getReader(charset);
            String string = IoUtil.read(bufferedReader);
            return string;
        }
        finally {
            IoUtil.close(bufferedReader);
        }
    }

    @Override
    public byte[] readBytes() {
        InputStream inputStream = null;
        try {
            inputStream = this.getStream();
            byte[] byArray = IoUtil.readBytes(inputStream);
            return byArray;
        }
        finally {
            IoUtil.close(inputStream);
        }
    }

    public File getFile() {
        return FileUtil.file(this.url);
    }

    public String toString() {
        return null == this.url ? "null" : this.url.toString();
    }
}

