/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.resource;

import com.ccb.core.io.IoUtil;
import com.ccb.core.io.resource.Resource;
import com.ccb.core.util.CharsetUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;

public class StringResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String data;
    private final String name;
    private final Charset charset;

    public StringResource(String string) {
        this(string, null);
    }

    public StringResource(String string, String string2) {
        this(string, string2, CharsetUtil.CHARSET_UTF_8);
    }

    public StringResource(String string, String string2, Charset charset) {
        this.data = string;
        this.name = string2;
        this.charset = charset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.readBytes());
    }

    @Override
    public BufferedReader getReader(Charset charset) {
        return IoUtil.getReader(new StringReader(this.data));
    }

    @Override
    public String readStr(Charset charset) {
        return this.data;
    }

    @Override
    public byte[] readBytes() {
        return this.data.getBytes(this.charset);
    }
}

