/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.resource;

import com.ccb.core.io.IoUtil;
import com.ccb.core.io.resource.Resource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;

public class InputStreamResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final InputStream in;
    private final String name;

    public InputStreamResource(InputStream inputStream) {
        this(inputStream, null);
    }

    public InputStreamResource(InputStream inputStream, String string) {
        this.in = inputStream;
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public InputStream getStream() {
        return this.in;
    }

    @Override
    public BufferedReader getReader(Charset charset) {
        return IoUtil.getReader(this.in, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readStr(Charset charset) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = this.getReader(charset);
            String string = IoUtil.read(bufferedReader);
            return string;
        }
        finally {
            IoUtil.close(bufferedReader);
        }
    }

    @Override
    public byte[] readBytes() {
        InputStream inputStream = null;
        try {
            inputStream = this.getStream();
            byte[] byArray = IoUtil.readBytes(inputStream);
            return byArray;
        }
        finally {
            IoUtil.close(inputStream);
        }
    }
}

