/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.resource;

import com.ccb.core.io.FileUtil;
import com.ccb.core.io.resource.NoResourceException;
import com.ccb.core.io.resource.UrlResource;
import com.ccb.core.lang.Assert;
import com.ccb.core.util.ClassUtil;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.StrUtil;
import com.ccb.core.util.URLUtil;
import java.net.URL;

public class ClassPathResource
extends UrlResource {
    private static final long serialVersionUID = 1L;
    private final String path;
    private final ClassLoader classLoader;
    private final Class clazz;

    public ClassPathResource(String string) {
        this(string, null, null);
    }

    public ClassPathResource(String string, ClassLoader classLoader) {
        this(string, classLoader, null);
    }

    public ClassPathResource(String string, Class clazz) {
        this(string, null, clazz);
    }

    public ClassPathResource(String string, ClassLoader classLoader, Class clazz) {
        super((URL)null);
        String string2;
        Assert.notNull(string, "Path must not be null", new Object[0]);
        this.path = string2 = this.normalizePath(string);
        this.name = StrUtil.isBlank(string2) ? null : FileUtil.getName(string2);
        this.classLoader = (ClassLoader)ObjectUtil.defaultIfNull(classLoader, ClassUtil.getClassLoader());
        this.clazz = clazz;
        this.initUrl();
    }

    public final String getPath() {
        return this.path;
    }

    public final String getAbsolutePath() {
        if (FileUtil.isAbsolutePath(this.path)) {
            return this.path;
        }
        return FileUtil.normalize(URLUtil.getDecodedPath(this.url));
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void initUrl() {
        this.url = null != this.clazz ? this.clazz.getResource(this.path) : (null != this.classLoader ? this.classLoader.getResource(this.path) : ClassLoader.getSystemResource(this.path));
        if (null == this.url) {
            throw new NoResourceException("Resource of path [{}] not exist!", this.path);
        }
    }

    @Override
    public String toString() {
        return null == this.path ? super.toString() : "classpath:" + this.path;
    }

    private String normalizePath(String string) {
        string = FileUtil.normalize(string);
        string = StrUtil.removePrefix(string, "/");
        Assert.isFalse(FileUtil.isAbsolutePath(string), "Path [{}] must be a relative path !", string);
        return string;
    }
}

