/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.file;

import com.ccb.core.io.FileUtil;
import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.IoUtil;
import com.ccb.core.io.file.FileWrapper;
import com.ccb.core.io.file.LineSeparator;
import com.ccb.core.lang.Assert;
import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.StrUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;

public class FileWriter
extends FileWrapper {
    private static final long serialVersionUID = 1L;

    public static FileWriter create(File file, Charset charset) {
        return new FileWriter(file, charset);
    }

    public static FileWriter create(File file) {
        return new FileWriter(file);
    }

    public FileWriter(File file, Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public FileWriter(File file, String string) {
        this(file, CharsetUtil.charset(string));
    }

    public FileWriter(String string, Charset charset) {
        this(FileUtil.file(string), charset);
    }

    public FileWriter(String string, String string2) {
        this(FileUtil.file(string), CharsetUtil.charset(string2));
    }

    public FileWriter(File file) {
        this(file, DEFAULT_CHARSET);
    }

    public FileWriter(String string) {
        this(string, DEFAULT_CHARSET);
    }

    public File write(String string, boolean bl) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = this.getWriter(bl);
            bufferedWriter.write(string);
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        finally {
            IoUtil.close(bufferedWriter);
        }
        return this.file;
    }

    public File write(String string) {
        return this.write(string, false);
    }

    public File append(String string) {
        return this.write(string, true);
    }

    public File writeLines(Collection collection) {
        return this.writeLines(collection, false);
    }

    public File appendLines(Collection collection) {
        return this.writeLines(collection, true);
    }

    public File writeLines(Collection collection, boolean bl) {
        return this.writeLines(collection, null, bl);
    }

    public File writeLines(Collection collection, LineSeparator lineSeparator, boolean bl) {
        try (PrintWriter printWriter = this.getPrintWriter(bl);){
            for (Object e2 : collection) {
                if (null == e2) continue;
                printWriter.print(e2.toString());
                this.printNewLine(printWriter, lineSeparator);
                printWriter.flush();
            }
        }
        return this.file;
    }

    public File writeMap(Map map, String string, boolean bl) {
        return this.writeMap(map, null, string, bl);
    }

    public File writeMap(Map map, LineSeparator lineSeparator, String string, boolean bl) {
        if (null == string) {
            string = " = ";
        }
        try (PrintWriter printWriter = this.getPrintWriter(bl);){
            for (Map.Entry entry : map.entrySet()) {
                if (null == entry) continue;
                printWriter.print(StrUtil.format((CharSequence)"{}{}{}", entry.getKey(), string, entry.getValue()));
                this.printNewLine(printWriter, lineSeparator);
                printWriter.flush();
            }
        }
        return this.file;
    }

    public File write(byte[] byArray, int n2, int n3) {
        return this.write(byArray, n2, n3, false);
    }

    public File append(byte[] byArray, int n2, int n3) {
        return this.write(byArray, n2, n3, true);
    }

    public File write(byte[] byArray, int n2, int n3, boolean bl) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(FileUtil.touch(this.file), bl);
            fileOutputStream.write(byArray, n2, n3);
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
            try {
                throw new IORuntimeException(iOException);
            }
            catch (Throwable throwable) {
                IoUtil.close(fileOutputStream);
                throw throwable;
            }
        }
        IoUtil.close(fileOutputStream);
        return this.file;
    }

    public File writeFromStream(InputStream inputStream) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(FileUtil.touch(this.file));
            IoUtil.copy(inputStream, (OutputStream)fileOutputStream);
        }
        catch (IOException iOException) {
            try {
                throw new IORuntimeException(iOException);
            }
            catch (Throwable throwable) {
                IoUtil.close(fileOutputStream);
                throw throwable;
            }
        }
        IoUtil.close(fileOutputStream);
        return this.file;
    }

    public BufferedOutputStream getOutputStream() {
        try {
            return new BufferedOutputStream(new FileOutputStream(FileUtil.touch(this.file)));
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public BufferedWriter getWriter(boolean bl) {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileUtil.touch(this.file), bl), this.charset));
        }
        catch (Exception exception) {
            throw new IORuntimeException(exception);
        }
    }

    public PrintWriter getPrintWriter(boolean bl) {
        return new PrintWriter(this.getWriter(bl));
    }

    private void checkFile() {
        Assert.notNull(this.file, "File to write content is null !", new Object[0]);
        if (this.file.exists() && !this.file.isFile()) {
            throw new IORuntimeException("File [{}] is not a file !", this.file.getAbsoluteFile());
        }
    }

    private void printNewLine(PrintWriter printWriter, LineSeparator lineSeparator) {
        if (null == lineSeparator) {
            printWriter.println();
        } else {
            printWriter.print(lineSeparator.getValue());
        }
    }
}

