/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.file;

import com.ccb.core.util.CharUtil;
import com.ccb.core.util.ReUtil;
import com.ccb.core.util.StrUtil;
import java.io.File;
import java.util.regex.Pattern;

public class FileNameUtil {
    public static final char UNIX_SEPARATOR = '/';
    public static final char WINDOWS_SEPARATOR = '\\';
    private static final Pattern FILE_NAME_INVALID_PATTERN_WIN = Pattern.compile("[\\\\/:*?\"<>|]");

    public static String getName(File file) {
        return null != file ? file.getName() : null;
    }

    public static String getName(String string) {
        if (null == string) {
            return null;
        }
        int n2 = string.length();
        if (0 == n2) {
            return string;
        }
        if (CharUtil.isFileSeparator(string.charAt(n2 - 1))) {
            --n2;
        }
        int n3 = 0;
        for (int i2 = n2 - 1; i2 > -1; --i2) {
            char c2 = string.charAt(i2);
            if (!CharUtil.isFileSeparator(c2)) continue;
            n3 = i2 + 1;
            break;
        }
        return string.substring(n3, n2);
    }

    public static String getSuffix(File file) {
        return FileNameUtil.extName(file);
    }

    public static String getSuffix(String string) {
        return FileNameUtil.extName(string);
    }

    public static String getPrefix(File file) {
        return FileNameUtil.mainName(file);
    }

    public static String getPrefix(String string) {
        return FileNameUtil.mainName(string);
    }

    public static String mainName(File file) {
        if (file.isDirectory()) {
            return file.getName();
        }
        return FileNameUtil.mainName(file.getName());
    }

    public static String mainName(String string) {
        if (null == string) {
            return null;
        }
        int n2 = string.length();
        if (0 == n2) {
            return string;
        }
        if (CharUtil.isFileSeparator(string.charAt(n2 - 1))) {
            --n2;
        }
        int n3 = 0;
        int n4 = n2;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            char c2 = string.charAt(i2);
            if (n2 == n4 && '.' == c2) {
                n4 = i2;
            }
            if (!CharUtil.isFileSeparator(c2)) continue;
            n3 = i2 + 1;
            break;
        }
        return string.substring(n3, n4);
    }

    public static String extName(File file) {
        if (null == file) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        return FileNameUtil.extName(file.getName());
    }

    public static String extName(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf(".");
        if (n2 == -1) {
            return "";
        }
        String string2 = string.substring(n2 + 1);
        return StrUtil.containsAny((CharSequence)string2, '/', '\\') ? "" : string2;
    }

    public static String cleanInvalid(String string) {
        return StrUtil.isBlank(string) ? string : ReUtil.delAll(FILE_NAME_INVALID_PATTERN_WIN, (CharSequence)string);
    }

    public static boolean containsInvalid(String string) {
        return false == StrUtil.isBlank(string) && ReUtil.contains(FILE_NAME_INVALID_PATTERN_WIN, (CharSequence)string);
    }
}

