/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.file;

import com.ccb.core.io.FileUtil;
import com.ccb.core.io.IORuntimeException;
import com.ccb.core.lang.Assert;
import com.ccb.core.lang.copier.SrcToDestCopier;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;

public class FileCopier
extends SrcToDestCopier {
    private static final long serialVersionUID = 1L;
    private boolean isOverride;
    private boolean isCopyAttributes;
    private boolean isCopyContentIfDir;
    private boolean isOnlyCopyFile;

    public static FileCopier create(String string, String string2) {
        return new FileCopier(FileUtil.file(string), FileUtil.file(string2));
    }

    public static FileCopier create(File file, File file2) {
        return new FileCopier(file, file2);
    }

    public FileCopier(File file, File file2) {
        this.src = file;
        this.dest = file2;
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    public FileCopier setOverride(boolean bl) {
        this.isOverride = bl;
        return this;
    }

    public boolean isCopyAttributes() {
        return this.isCopyAttributes;
    }

    public FileCopier setCopyAttributes(boolean bl) {
        this.isCopyAttributes = bl;
        return this;
    }

    public boolean isCopyContentIfDir() {
        return this.isCopyContentIfDir;
    }

    public FileCopier setCopyContentIfDir(boolean bl) {
        this.isCopyContentIfDir = bl;
        return this;
    }

    public boolean isOnlyCopyFile() {
        return this.isOnlyCopyFile;
    }

    public FileCopier setOnlyCopyFile(boolean bl) {
        this.isOnlyCopyFile = bl;
        return this;
    }

    @Override
    public File copy() {
        File file = (File)this.src;
        File file2 = (File)this.dest;
        Assert.notNull(file, "Source File is null !", new Object[0]);
        if (!file.exists()) {
            throw new IORuntimeException("File not exist: " + file);
        }
        Assert.notNull(file2, "Destination File or directiory is null !", new Object[0]);
        if (FileUtil.equals(file, file2)) {
            throw new IORuntimeException("Files '{}' and '{}' are equal", file, file2);
        }
        if (file.isDirectory()) {
            if (file2.exists() && !file2.isDirectory()) {
                throw new IORuntimeException("Src is a directory but dest is a file!");
            }
            if (FileUtil.isSub(file, file2)) {
                throw new IORuntimeException("Dest is a sub directory of src !");
            }
            File file3 = this.isCopyContentIfDir ? file2 : FileUtil.mkdir(FileUtil.file(file2, file.getName()));
            this.internalCopyDirContent(file, file3);
        } else {
            this.internalCopyFile(file, file2);
        }
        return file2;
    }

    private void internalCopyDirContent(File file, File file2) {
        if (null != this.copyFilter && !this.copyFilter.accept(file)) {
            return;
        }
        if (!file2.exists()) {
            file2.mkdirs();
        } else if (!file2.isDirectory()) {
            throw new IORuntimeException(StrUtil.format((CharSequence)"Src [{}] is a directory but dest [{}] is a file!", file.getPath(), file2.getPath()));
        }
        Object[] objectArray = file.list();
        if (ArrayUtil.isNotEmpty(objectArray)) {
            for (Object object : objectArray) {
                File file3;
                File file4 = new File(file, (String)object);
                File file5 = file3 = this.isOnlyCopyFile ? file2 : new File(file2, (String)object);
                if (file4.isDirectory()) {
                    this.internalCopyDirContent(file4, file3);
                    continue;
                }
                this.internalCopyFile(file4, file3);
            }
        }
    }

    private void internalCopyFile(File file, File file2) {
        if (null != this.copyFilter && !this.copyFilter.accept(file)) {
            return;
        }
        if (file2.exists()) {
            if (file2.isDirectory()) {
                file2 = new File(file2, file.getName());
            }
            if (file2.exists() && !this.isOverride) {
                return;
            }
        } else {
            file2.getParentFile().mkdirs();
        }
        ArrayList<StandardCopyOption> arrayList = new ArrayList<StandardCopyOption>(2);
        if (this.isOverride) {
            arrayList.add(StandardCopyOption.REPLACE_EXISTING);
        }
        if (this.isCopyAttributes) {
            arrayList.add(StandardCopyOption.COPY_ATTRIBUTES);
        }
        try {
            Files.copy(file.toPath(), file2.toPath(), arrayList.toArray(new CopyOption[0]));
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }
}

