/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io;

import com.ccb.core.collection.CollUtil;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashSet;
import java.util.Set;

public class ValidateObjectInputStream
extends ObjectInputStream {
    private Set whiteClassSet;
    private Set blackClassSet;

    public ValidateObjectInputStream(InputStream inputStream, Class ... classArray) {
        super(inputStream);
        this.accept(classArray);
    }

    public void refuse(Class ... classArray) {
        if (null == this.blackClassSet) {
            this.blackClassSet = new HashSet();
        }
        for (Class clazz : classArray) {
            this.blackClassSet.add(clazz.getName());
        }
    }

    public void accept(Class ... classArray) {
        if (null == this.whiteClassSet) {
            this.whiteClassSet = new HashSet();
        }
        for (Class clazz : classArray) {
            this.whiteClassSet.add(clazz.getName());
        }
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) {
        this.validateClassName(objectStreamClass.getName());
        return super.resolveClass(objectStreamClass);
    }

    private void validateClassName(String string) {
        if (CollUtil.isNotEmpty(this.blackClassSet) && this.blackClassSet.contains(string)) {
            throw new InvalidClassException("Unauthorized deserialization attempt by black list", string);
        }
        if (CollUtil.isEmpty(this.whiteClassSet)) {
            return;
        }
        if (string.startsWith("java.")) {
            return;
        }
        if (this.whiteClassSet.contains(string)) {
            return;
        }
        throw new InvalidClassException("Unauthorized deserialization attempt", string);
    }
}

