/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.io.BOMInputStream;
import com.ccb.core.io.FileTypeUtil;
import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.IoUtil;
import com.ccb.core.io.LineHandler;
import com.ccb.core.io.file.FileCopier;
import com.ccb.core.io.file.FileMode;
import com.ccb.core.io.file.FileNameUtil;
import com.ccb.core.io.file.FileReader;
import com.ccb.core.io.file.FileReader$ReaderHandler;
import com.ccb.core.io.file.FileWriter;
import com.ccb.core.io.file.LineSeparator;
import com.ccb.core.io.file.PathUtil;
import com.ccb.core.io.file.Tailer;
import com.ccb.core.io.resource.ResourceUtil;
import com.ccb.core.io.unit.DataSizeUtil;
import com.ccb.core.lang.Assert;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.CharUtil;
import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.ClassUtil;
import com.ccb.core.util.StrUtil;
import com.ccb.core.util.URLUtil;
import com.ccb.core.util.ZipUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class FileUtil
extends PathUtil {
    public static final String CLASS_EXT = ".class";
    public static final String JAR_FILE_EXT = ".jar";
    public static final String JAR_PATH_EXT = ".jar!";
    public static final String PATH_FILE_PRE = "file:";

    public static boolean isWindows() {
        return '\\' == File.separatorChar;
    }

    public static File[] ls(String string) {
        if (string == null) {
            return null;
        }
        File file = FileUtil.file(string);
        if (file.isDirectory()) {
            return file.listFiles();
        }
        throw new IORuntimeException(StrUtil.format((CharSequence)"Path [{}] is not directory!", string));
    }

    public static boolean isEmpty(File file) {
        if (null == file) {
            return true;
        }
        if (file.isDirectory()) {
            Object[] objectArray = file.list();
            return ArrayUtil.isEmpty(objectArray);
        }
        if (file.isFile()) {
            return file.length() <= 0L;
        }
        return false;
    }

    public static boolean isNotEmpty(File file) {
        return false == FileUtil.isEmpty(file);
    }

    public static boolean isDirEmpty(File file) {
        return FileUtil.isDirEmpty(file.toPath());
    }

    public static List loopFiles(String string, FileFilter fileFilter) {
        return FileUtil.loopFiles(FileUtil.file(string), fileFilter);
    }

    public static List loopFiles(File file, FileFilter fileFilter) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (null == file || !file.exists()) {
            return arrayList;
        }
        if (file.isDirectory()) {
            Object[] objectArray = file.listFiles();
            if (ArrayUtil.isNotEmpty(objectArray)) {
                for (Object object : objectArray) {
                    arrayList.addAll(FileUtil.loopFiles((File)object, fileFilter));
                }
            }
        } else if (null == fileFilter || fileFilter.accept(file)) {
            arrayList.add(file);
        }
        return arrayList;
    }

    public static List loopFiles(File file, int n2, FileFilter fileFilter) {
        return FileUtil.loopFiles(file.toPath(), n2, fileFilter);
    }

    public static List loopFiles(String string) {
        return FileUtil.loopFiles(FileUtil.file(string));
    }

    public static List loopFiles(File file) {
        return FileUtil.loopFiles(file, null);
    }

    public static List listFileNames(String string) {
        List list;
        if (string == null) {
            return new ArrayList(0);
        }
        int n2 = string.lastIndexOf(JAR_PATH_EXT);
        if (n2 < 0) {
            File[] fileArray;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (File file : fileArray = FileUtil.ls(string)) {
                if (!file.isFile()) continue;
                arrayList.add(file.getName());
            }
            return arrayList;
        }
        string = FileUtil.getAbsolutePath(string);
        n2 += JAR_FILE_EXT.length();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(string.substring(0, n2));
            list = ZipUtil.listFileNames(jarFile, StrUtil.removePrefix(string.substring(n2 + 1), "/"));
        }
        catch (IOException iOException) {
            try {
                throw new IORuntimeException(StrUtil.format((CharSequence)"Can not read file path of [{}]", string), iOException);
            }
            catch (Throwable throwable) {
                IoUtil.close(jarFile);
                throw throwable;
            }
        }
        IoUtil.close(jarFile);
        return list;
    }

    public static File newFile(String string) {
        return new File(string);
    }

    public static File file(String string) {
        if (null == string) {
            return null;
        }
        return new File(FileUtil.getAbsolutePath(string));
    }

    public static File file(String string, String string2) {
        return FileUtil.file(new File(string), string2);
    }

    public static File file(File file, String string) {
        if (StrUtil.isBlank(string)) {
            throw new NullPointerException("File path is blank!");
        }
        return FileUtil.checkSlip(file, new File(file, string));
    }

    public static File file(File file, String ... stringArray) {
        Assert.notNull(file, "directorydirectory must not be null", new Object[0]);
        if (ArrayUtil.isEmpty(stringArray)) {
            return file;
        }
        File file2 = file;
        for (String string : stringArray) {
            if (null == string) continue;
            file2 = FileUtil.file(file2, string);
        }
        return file2;
    }

    public static File file(String ... stringArray) {
        if (ArrayUtil.isEmpty(stringArray)) {
            return null;
        }
        File file = null;
        for (String string : stringArray) {
            file = file == null ? FileUtil.file(string) : FileUtil.file(file, string);
        }
        return file;
    }

    public static File file(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("File uri is null!");
        }
        return new File(uRI);
    }

    public static File file(URL uRL) {
        return new File(URLUtil.toURI(uRL));
    }

    public static String getTmpDirPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getTmpDir() {
        return FileUtil.file(FileUtil.getTmpDirPath());
    }

    public static String getUserHomePath() {
        return System.getProperty("user.home");
    }

    public static File getUserHomeDir() {
        return FileUtil.file(FileUtil.getUserHomePath());
    }

    public static boolean exist(String string) {
        return null != string && FileUtil.file(string).exists();
    }

    public static boolean exist(File file) {
        return null != file && file.exists();
    }

    public static boolean exist(String string, String string2) {
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return false;
        }
        for (String string3 : stringArray) {
            if (!string3.matches(string2)) continue;
            return true;
        }
        return false;
    }

    public static Date lastModifiedTime(File file) {
        if (!FileUtil.exist(file)) {
            return null;
        }
        return new Date(file.lastModified());
    }

    public static Date lastModifiedTime(String string) {
        return FileUtil.lastModifiedTime(new File(string));
    }

    public static long size(File file) {
        if (null == file || !file.exists()) {
            return 0L;
        }
        if (file.isDirectory()) {
            long l2 = 0L;
            Object[] objectArray = file.listFiles();
            if (ArrayUtil.isEmpty(objectArray)) {
                return 0L;
            }
            for (Object object : objectArray) {
                l2 += FileUtil.size((File)object);
            }
            return l2;
        }
        return file.length();
    }

    public static boolean newerThan(File file, File file2) {
        if (null == file2 || !file2.exists()) {
            return true;
        }
        return FileUtil.newerThan(file, file2.lastModified());
    }

    public static boolean newerThan(File file, long l2) {
        if (null == file || !file.exists()) {
            return false;
        }
        return file.lastModified() > l2;
    }

    public static File touch(String string) {
        if (string == null) {
            return null;
        }
        return FileUtil.touch(FileUtil.file(string));
    }

    public static File touch(File file) {
        if (null == file) {
            return null;
        }
        if (!file.exists()) {
            FileUtil.mkParentDirs(file);
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                throw new IORuntimeException(exception);
            }
        }
        return file;
    }

    public static File touch(File file, String string) {
        return FileUtil.touch(FileUtil.file(file, string));
    }

    public static File touch(String string, String string2) {
        return FileUtil.touch(FileUtil.file(string, string2));
    }

    public static File mkParentDirs(File file) {
        File file2 = file.getParentFile();
        if (null != file2 && !file2.exists()) {
            file2.mkdirs();
        }
        return file2;
    }

    public static File mkParentDirs(String string) {
        if (string == null) {
            return null;
        }
        return FileUtil.mkParentDirs(FileUtil.file(string));
    }

    public static boolean del(String string) {
        return FileUtil.del(FileUtil.file(string));
    }

    public static boolean del(File file) {
        boolean bl;
        if (file == null || !file.exists()) {
            return true;
        }
        if (file.isDirectory() && !(bl = FileUtil.clean(file))) {
            return false;
        }
        return file.delete();
    }

    public static boolean clean(String string) {
        return FileUtil.clean(FileUtil.file(string));
    }

    public static boolean clean(File file) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return true;
        }
        File[] fileArray = file.listFiles();
        if (null != fileArray) {
            for (File file2 : fileArray) {
                boolean bl = FileUtil.del(file2);
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean cleanEmpty(File file) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return true;
        }
        Object[] objectArray = file.listFiles();
        if (ArrayUtil.isEmpty(objectArray)) {
            file.delete();
        } else {
            for (Object object : objectArray) {
                FileUtil.cleanEmpty((File)object);
            }
        }
        return true;
    }

    public static File mkdir(String string) {
        if (string == null) {
            return null;
        }
        File file = FileUtil.file(string);
        return FileUtil.mkdir(file);
    }

    public static File mkdir(File file) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static File createTempFile(File file) {
        return FileUtil.createTempFile("hutool", null, file, true);
    }

    public static File createTempFile(File file, boolean bl) {
        return FileUtil.createTempFile("hutool", null, file, bl);
    }

    public static File createTempFile(String string, String string2, File file, boolean bl) {
        int n2 = 0;
        while (true) {
            try {
                File file2 = File.createTempFile(string, string2, file).getCanonicalFile();
                if (bl) {
                    file2.delete();
                    file2.createNewFile();
                }
                return file2;
            }
            catch (IOException iOException) {
                if (++n2 < 50) continue;
                throw new IORuntimeException(iOException);
            }
            break;
        }
    }

    public static File copyFile(String string, String string2, StandardCopyOption ... standardCopyOptionArray) {
        Assert.notBlank(string, "Source File path is blank !", new Object[0]);
        Assert.notNull(string, "Destination File path is null !", new Object[0]);
        return FileUtil.copyFile(Paths.get(string, new String[0]), Paths.get(string2, new String[0]), standardCopyOptionArray).toFile();
    }

    public static File copyFile(File file, File file2, StandardCopyOption ... standardCopyOptionArray) {
        Assert.notNull(file, "Source File is null !", new Object[0]);
        if (!file.exists()) {
            throw new IORuntimeException("File not exist: " + file);
        }
        Assert.notNull(file2, "Destination File or directiory is null !", new Object[0]);
        if (FileUtil.equals(file, file2)) {
            throw new IORuntimeException("Files '{}' and '{}' are equal", file, file2);
        }
        return FileUtil.copyFile(file.toPath(), file2.toPath(), standardCopyOptionArray).toFile();
    }

    public static File copy(String string, String string2, boolean bl) {
        return FileUtil.copy(FileUtil.file(string), FileUtil.file(string2), bl);
    }

    public static File copy(File file, File file2, boolean bl) {
        return FileCopier.create(file, file2).setOverride(bl).copy();
    }

    public static File copyContent(File file, File file2, boolean bl) {
        return FileCopier.create(file, file2).setCopyContentIfDir(true).setOverride(bl).copy();
    }

    public static File copyFilesFromDir(File file, File file2, boolean bl) {
        return FileCopier.create(file, file2).setCopyContentIfDir(true).setOnlyCopyFile(true).setOverride(bl).copy();
    }

    public static void move(File file, File file2, boolean bl) {
        if (!file.exists()) {
            throw new IORuntimeException("File not found: " + file);
        }
        if (file.isDirectory() && file2.isFile()) {
            throw new IORuntimeException(StrUtil.format((CharSequence)"Can not move directory [{}] to file [{}]", file, file2));
        }
        if (bl && file2.isFile()) {
            file2.delete();
        }
        if (file.isFile() && file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        if (!file.renameTo(file2)) {
            try {
                FileUtil.copy(file, file2, bl);
            }
            catch (Exception exception) {
                throw new IORuntimeException(StrUtil.format((CharSequence)"Move [{}] to [{}] failed!", file, file2), exception);
            }
            FileUtil.del(file);
        }
    }

    public static File rename(File file, String string, boolean bl) {
        return FileUtil.rename(file, string, false, bl);
    }

    public static File rename(File file, String string, boolean bl, boolean bl2) {
        String string2;
        if (bl && StrUtil.isNotBlank(string2 = FileUtil.extName(file))) {
            string = string.concat(".").concat(string2);
        }
        return FileUtil.rename(file.toPath(), string, bl2).toFile();
    }

    public static String getCanonicalPath(File file) {
        if (null == file) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static String getAbsolutePath(String string, Class clazz) {
        String string2;
        if (string == null) {
            string2 = "";
        } else {
            string2 = FileUtil.normalize(string);
            if (FileUtil.isAbsolutePath(string2)) {
                return string2;
            }
        }
        URL uRL = ResourceUtil.getResource(string2, clazz);
        if (null != uRL) {
            return FileUtil.normalize(URLUtil.getDecodedPath(uRL));
        }
        String string3 = ClassUtil.getClassPath();
        if (null == string3) {
            return string;
        }
        return FileUtil.normalize(string3.concat(Objects.requireNonNull(string)));
    }

    public static String getAbsolutePath(String string) {
        return FileUtil.getAbsolutePath(string, null);
    }

    public static String getAbsolutePath(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static boolean isAbsolutePath(String string) {
        if (StrUtil.isEmpty(string)) {
            return false;
        }
        return '/' == string.charAt(0) || string.matches("^[a-zA-Z]:([/\\\\].*)?");
    }

    public static boolean isDirectory(String string) {
        return null != string && FileUtil.file(string).isDirectory();
    }

    public static boolean isDirectory(File file) {
        return null != file && file.isDirectory();
    }

    public static boolean isFile(String string) {
        return null != string && FileUtil.file(string).isFile();
    }

    public static boolean isFile(File file) {
        return null != file && file.isFile();
    }

    public static boolean equals(File file, File file2) {
        Assert.notNull(file);
        Assert.notNull(file2);
        if (!file.exists() || !file2.exists()) {
            return false == file.exists() && false == file2.exists() && FileUtil.pathEquals(file, file2);
        }
        return FileUtil.equals(file.toPath(), file2.toPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEquals(File file, File file2) {
        boolean bl = file.exists();
        if (bl != file2.exists()) {
            return false;
        }
        if (!bl) {
            return true;
        }
        if (file.isDirectory() || file2.isDirectory()) {
            throw new IORuntimeException("Can't compare directories, only files");
        }
        if (file.length() != file2.length()) {
            return false;
        }
        if (FileUtil.equals(file, file2)) {
            return true;
        }
        BufferedInputStream bufferedInputStream = null;
        BufferedInputStream bufferedInputStream2 = null;
        try {
            bufferedInputStream = FileUtil.getInputStream(file);
            bufferedInputStream2 = FileUtil.getInputStream(file2);
            boolean bl2 = IoUtil.contentEquals(bufferedInputStream, bufferedInputStream2);
            return bl2;
        }
        finally {
            IoUtil.close(bufferedInputStream);
            IoUtil.close(bufferedInputStream2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEqualsIgnoreEOL(File file, File file2, Charset charset) {
        boolean bl;
        boolean bl2 = file.exists();
        if (bl2 != file2.exists()) {
            return false;
        }
        if (!bl2) {
            return true;
        }
        if (file.isDirectory() || file2.isDirectory()) {
            throw new IORuntimeException("Can't compare directories, only files");
        }
        if (FileUtil.equals(file, file2)) {
            return true;
        }
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        try {
            bufferedReader = FileUtil.getReader(file, charset);
            bufferedReader2 = FileUtil.getReader(file2, charset);
            bl = IoUtil.contentEqualsIgnoreEOL(bufferedReader, bufferedReader2);
        }
        catch (Throwable throwable) {
            IoUtil.close(bufferedReader);
            IoUtil.close(bufferedReader2);
            throw throwable;
        }
        IoUtil.close(bufferedReader);
        IoUtil.close(bufferedReader2);
        return bl;
    }

    public static boolean pathEquals(File file, File file2) {
        block8: {
            if (FileUtil.isWindows()) {
                try {
                    if (StrUtil.equalsIgnoreCase(file.getCanonicalPath(), file2.getCanonicalPath())) {
                        return true;
                    }
                    break block8;
                }
                catch (Exception exception) {
                    if (StrUtil.equalsIgnoreCase(file.getAbsolutePath(), file2.getAbsolutePath())) {
                        return true;
                    }
                    break block8;
                }
            }
            try {
                if (StrUtil.equals(file.getCanonicalPath(), file2.getCanonicalPath())) {
                    return true;
                }
            }
            catch (Exception exception) {
                if (!StrUtil.equals(file.getAbsolutePath(), file2.getAbsolutePath())) break block8;
                return true;
            }
        }
        return false;
    }

    public static int lastIndexOfSeparator(String string) {
        if (StrUtil.isNotEmpty(string)) {
            int n2 = string.length();
            while (--n2 >= 0) {
                char c2 = string.charAt(n2);
                if (!CharUtil.isFileSeparator(c2)) continue;
                return n2;
            }
        }
        return -1;
    }

    public static boolean isModifed(File file, long l2) {
        if (null == file || !file.exists()) {
            return true;
        }
        return file.lastModified() != l2;
    }

    public static String normalize(String string) {
        if (string == null) {
            return null;
        }
        String string2 = StrUtil.removePrefixIgnoreCase(string, "classpath:");
        if ((string2 = StrUtil.removePrefixIgnoreCase(string2, PATH_FILE_PRE)).startsWith("~")) {
            string2 = string2.replace("~", FileUtil.getUserHomePath());
        }
        string2 = string2.replaceAll("[/\\\\]+", "/").trim();
        if (string.startsWith("\\\\")) {
            string2 = "\\" + string2;
        }
        String string3 = "";
        int n2 = string2.indexOf(":");
        if (n2 > -1) {
            string3 = string2.substring(0, n2 + 1);
            if (StrUtil.startWith((CharSequence)string3, '/')) {
                string3 = string3.substring(1);
            }
            if (!string3.contains("/")) {
                string2 = string2.substring(n2 + 1);
            } else {
                string3 = "";
            }
        }
        if (string2.startsWith("/")) {
            string3 = string3 + "/";
            string2 = string2.substring(1);
        }
        List list = StrUtil.split((CharSequence)string2, '/');
        LinkedList<String> linkedList = new LinkedList<String>();
        int n3 = 0;
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            String string4 = (String)list.get(i2);
            if (".".equals(string4)) continue;
            if ("..".equals(string4)) {
                ++n3;
                continue;
            }
            if (n3 > 0) {
                --n3;
                continue;
            }
            linkedList.add(0, string4);
        }
        return string3 + CollUtil.join(linkedList, (CharSequence)"/");
    }

    public static String subPath(String string, File file) {
        try {
            return FileUtil.subPath(string, file.getCanonicalPath());
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static String subPath(String string, String string2) {
        if (StrUtil.isNotEmpty(string) && StrUtil.isNotEmpty(string2)) {
            string = StrUtil.removeSuffix(FileUtil.normalize(string), "/");
            string2 = FileUtil.normalize(string2);
            String string3 = StrUtil.removePrefixIgnoreCase(string2, string);
            return StrUtil.removePrefix(string3, "/");
        }
        return string2;
    }

    public static String getName(File file) {
        return FileNameUtil.getName(file);
    }

    public static String getName(String string) {
        return FileNameUtil.getName(string);
    }

    public static String getSuffix(File file) {
        return FileNameUtil.getSuffix(file);
    }

    public static String getSuffix(String string) {
        return FileNameUtil.getSuffix(string);
    }

    public static String getPrefix(File file) {
        return FileNameUtil.getPrefix(file);
    }

    public static String getPrefix(String string) {
        return FileNameUtil.getPrefix(string);
    }

    public static String mainName(File file) {
        return FileNameUtil.mainName(file);
    }

    public static String mainName(String string) {
        return FileNameUtil.mainName(string);
    }

    public static String extName(File file) {
        return FileNameUtil.extName(file);
    }

    public static String extName(String string) {
        return FileNameUtil.extName(string);
    }

    public static boolean pathEndsWith(File file, String string) {
        return file.getPath().toLowerCase().endsWith(string);
    }

    public static String getType(File file) {
        return FileTypeUtil.getType(file);
    }

    public static BufferedInputStream getInputStream(File file) {
        return IoUtil.toBuffered(IoUtil.toStream(file));
    }

    public static BufferedInputStream getInputStream(String string) {
        return FileUtil.getInputStream(FileUtil.file(string));
    }

    public static BOMInputStream getBOMInputStream(File file) {
        try {
            return new BOMInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static BufferedReader getUtf8Reader(File file) {
        return FileUtil.getReader(file, CharsetUtil.CHARSET_UTF_8);
    }

    public static BufferedReader getUtf8Reader(String string) {
        return FileUtil.getReader(string, CharsetUtil.CHARSET_UTF_8);
    }

    public static BufferedReader getReader(File file, String string) {
        return IoUtil.getReader((InputStream)FileUtil.getInputStream(file), string);
    }

    public static BufferedReader getReader(File file, Charset charset) {
        return IoUtil.getReader((InputStream)FileUtil.getInputStream(file), charset);
    }

    public static BufferedReader getReader(String string, String string2) {
        return FileUtil.getReader(FileUtil.file(string), string2);
    }

    public static BufferedReader getReader(String string, Charset charset) {
        return FileUtil.getReader(FileUtil.file(string), charset);
    }

    public static byte[] readBytes(File file) {
        return FileReader.create(file).readBytes();
    }

    public static byte[] readBytes(String string) {
        return FileUtil.readBytes(FileUtil.file(string));
    }

    public static String readUtf8String(File file) {
        return FileUtil.readString(file, CharsetUtil.CHARSET_UTF_8);
    }

    public static String readUtf8String(String string) {
        return FileUtil.readString(string, CharsetUtil.CHARSET_UTF_8);
    }

    public static String readString(File file, String string) {
        return FileUtil.readString(file, CharsetUtil.charset(string));
    }

    public static String readString(File file, Charset charset) {
        return FileReader.create(file, charset).readString();
    }

    public static String readString(String string, String string2) {
        return FileUtil.readString(FileUtil.file(string), string2);
    }

    public static String readString(String string, Charset charset) {
        return FileUtil.readString(FileUtil.file(string), charset);
    }

    public static String readString(URL uRL, String string) {
        if (uRL == null) {
            throw new NullPointerException("Empty url provided!");
        }
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            String string2 = IoUtil.read(inputStream, string);
            return string2;
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        finally {
            IoUtil.close(inputStream);
        }
    }

    public static Collection readUtf8Lines(String string, Collection collection) {
        return FileUtil.readLines(string, CharsetUtil.CHARSET_UTF_8, collection);
    }

    public static Collection readLines(String string, String string2, Collection collection) {
        return FileUtil.readLines(FileUtil.file(string), string2, collection);
    }

    public static Collection readLines(String string, Charset charset, Collection collection) {
        return FileUtil.readLines(FileUtil.file(string), charset, collection);
    }

    public static Collection readUtf8Lines(File file, Collection collection) {
        return FileUtil.readLines(file, CharsetUtil.CHARSET_UTF_8, collection);
    }

    public static Collection readLines(File file, String string, Collection collection) {
        return FileReader.create(file, CharsetUtil.charset(string)).readLines(collection);
    }

    public static Collection readLines(File file, Charset charset, Collection collection) {
        return FileReader.create(file, charset).readLines(collection);
    }

    public static Collection readUtf8Lines(URL uRL, Collection collection) {
        return FileUtil.readLines(uRL, CharsetUtil.CHARSET_UTF_8, collection);
    }

    public static Collection readLines(URL uRL, String string, Collection collection) {
        return FileUtil.readLines(uRL, CharsetUtil.charset(string), collection);
    }

    public static Collection readLines(URL uRL, Charset charset, Collection collection) {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            Collection collection2 = IoUtil.readLines(inputStream, charset, collection);
            return collection2;
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        finally {
            IoUtil.close(inputStream);
        }
    }

    public static List readUtf8Lines(URL uRL) {
        return FileUtil.readLines(uRL, CharsetUtil.CHARSET_UTF_8);
    }

    public static List readLines(URL uRL, String string) {
        return (List)FileUtil.readLines(uRL, string, new ArrayList());
    }

    public static List readLines(URL uRL, Charset charset) {
        return (List)FileUtil.readLines(uRL, charset, new ArrayList());
    }

    public static List readUtf8Lines(String string) {
        return FileUtil.readLines(string, CharsetUtil.CHARSET_UTF_8);
    }

    public static List readLines(String string, String string2) {
        return (List)FileUtil.readLines(string, string2, new ArrayList());
    }

    public static List readLines(String string, Charset charset) {
        return (List)FileUtil.readLines(string, charset, new ArrayList());
    }

    public static List readUtf8Lines(File file) {
        return FileUtil.readLines(file, CharsetUtil.CHARSET_UTF_8);
    }

    public static List readLines(File file, String string) {
        return (List)FileUtil.readLines(file, string, new ArrayList());
    }

    public static List readLines(File file, Charset charset) {
        return (List)FileUtil.readLines(file, charset, new ArrayList());
    }

    public static void readUtf8Lines(File file, LineHandler lineHandler) {
        FileUtil.readLines(file, CharsetUtil.CHARSET_UTF_8, lineHandler);
    }

    public static void readLines(File file, Charset charset, LineHandler lineHandler) {
        FileReader.create(file, charset).readLines(lineHandler);
    }

    public static void readLines(RandomAccessFile randomAccessFile, Charset charset, LineHandler lineHandler) {
        try {
            String string;
            while ((string = randomAccessFile.readLine()) != null) {
                lineHandler.handle(CharsetUtil.convert(string, CharsetUtil.CHARSET_ISO_8859_1, charset));
            }
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static void readLine(RandomAccessFile randomAccessFile, Charset charset, LineHandler lineHandler) {
        String string = FileUtil.readLine(randomAccessFile, charset);
        if (null != string) {
            lineHandler.handle(string);
        }
    }

    public static String readLine(RandomAccessFile randomAccessFile, Charset charset) {
        String string;
        try {
            string = randomAccessFile.readLine();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        if (null != string) {
            return CharsetUtil.convert(string, CharsetUtil.CHARSET_ISO_8859_1, charset);
        }
        return null;
    }

    public static Object loadUtf8(String string, FileReader$ReaderHandler fileReader$ReaderHandler) {
        return FileUtil.load(string, CharsetUtil.CHARSET_UTF_8, fileReader$ReaderHandler);
    }

    public static Object load(String string, String string2, FileReader$ReaderHandler fileReader$ReaderHandler) {
        return FileReader.create(FileUtil.file(string), CharsetUtil.charset(string2)).read(fileReader$ReaderHandler);
    }

    public static Object load(String string, Charset charset, FileReader$ReaderHandler fileReader$ReaderHandler) {
        return FileReader.create(FileUtil.file(string), charset).read(fileReader$ReaderHandler);
    }

    public static Object loadUtf8(File file, FileReader$ReaderHandler fileReader$ReaderHandler) {
        return FileUtil.load(file, CharsetUtil.CHARSET_UTF_8, fileReader$ReaderHandler);
    }

    public static Object load(File file, Charset charset, FileReader$ReaderHandler fileReader$ReaderHandler) {
        return FileReader.create(file, charset).read(fileReader$ReaderHandler);
    }

    public static BufferedOutputStream getOutputStream(File file) {
        FileOutputStream fileOutputStream;
        try {
            fileOutputStream = new FileOutputStream(FileUtil.touch(file));
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        return IoUtil.toBuffered(fileOutputStream);
    }

    public static BufferedOutputStream getOutputStream(String string) {
        return FileUtil.getOutputStream(FileUtil.touch(string));
    }

    public static BufferedWriter getWriter(String string, String string2, boolean bl) {
        return FileUtil.getWriter(FileUtil.touch(string), Charset.forName(string2), bl);
    }

    public static BufferedWriter getWriter(String string, Charset charset, boolean bl) {
        return FileUtil.getWriter(FileUtil.touch(string), charset, bl);
    }

    public static BufferedWriter getWriter(File file, String string, boolean bl) {
        return FileUtil.getWriter(file, Charset.forName(string), bl);
    }

    public static BufferedWriter getWriter(File file, Charset charset, boolean bl) {
        return FileWriter.create(file, charset).getWriter(bl);
    }

    public static PrintWriter getPrintWriter(String string, String string2, boolean bl) {
        return new PrintWriter(FileUtil.getWriter(string, string2, bl));
    }

    public static PrintWriter getPrintWriter(String string, Charset charset, boolean bl) {
        return new PrintWriter(FileUtil.getWriter(string, charset, bl));
    }

    public static PrintWriter getPrintWriter(File file, String string, boolean bl) {
        return new PrintWriter(FileUtil.getWriter(file, string, bl));
    }

    public static PrintWriter getPrintWriter(File file, Charset charset, boolean bl) {
        return new PrintWriter(FileUtil.getWriter(file, charset, bl));
    }

    public static String getLineSeparator() {
        return System.lineSeparator();
    }

    public static File writeUtf8String(String string, String string2) {
        return FileUtil.writeString(string, string2, CharsetUtil.CHARSET_UTF_8);
    }

    public static File writeUtf8String(String string, File file) {
        return FileUtil.writeString(string, file, CharsetUtil.CHARSET_UTF_8);
    }

    public static File writeString(String string, String string2, String string3) {
        return FileUtil.writeString(string, FileUtil.touch(string2), string3);
    }

    public static File writeString(String string, String string2, Charset charset) {
        return FileUtil.writeString(string, FileUtil.touch(string2), charset);
    }

    public static File writeString(String string, File file, String string2) {
        return FileWriter.create(file, CharsetUtil.charset(string2)).write(string);
    }

    public static File writeString(String string, File file, Charset charset) {
        return FileWriter.create(file, charset).write(string);
    }

    public static File appendUtf8String(String string, String string2) {
        return FileUtil.appendString(string, string2, CharsetUtil.CHARSET_UTF_8);
    }

    public static File appendString(String string, String string2, String string3) {
        return FileUtil.appendString(string, FileUtil.touch(string2), string3);
    }

    public static File appendString(String string, String string2, Charset charset) {
        return FileUtil.appendString(string, FileUtil.touch(string2), charset);
    }

    public static File appendUtf8String(String string, File file) {
        return FileUtil.appendString(string, file, CharsetUtil.CHARSET_UTF_8);
    }

    public static File appendString(String string, File file, String string2) {
        return FileWriter.create(file, CharsetUtil.charset(string2)).append(string);
    }

    public static File appendString(String string, File file, Charset charset) {
        return FileWriter.create(file, charset).append(string);
    }

    public static File writeUtf8Lines(Collection collection, String string) {
        return FileUtil.writeLines(collection, string, CharsetUtil.CHARSET_UTF_8);
    }

    public static File writeUtf8Lines(Collection collection, File file) {
        return FileUtil.writeLines(collection, file, CharsetUtil.CHARSET_UTF_8);
    }

    public static File writeLines(Collection collection, String string, String string2) {
        return FileUtil.writeLines(collection, string, string2, false);
    }

    public static File writeLines(Collection collection, String string, Charset charset) {
        return FileUtil.writeLines(collection, string, charset, false);
    }

    public static File writeLines(Collection collection, File file, String string) {
        return FileUtil.writeLines(collection, file, string, false);
    }

    public static File writeLines(Collection collection, File file, Charset charset) {
        return FileUtil.writeLines(collection, file, charset, false);
    }

    public static File appendUtf8Lines(Collection collection, File file) {
        return FileUtil.appendLines(collection, file, CharsetUtil.CHARSET_UTF_8);
    }

    public static File appendUtf8Lines(Collection collection, String string) {
        return FileUtil.appendLines(collection, string, CharsetUtil.CHARSET_UTF_8);
    }

    public static File appendLines(Collection collection, String string, String string2) {
        return FileUtil.writeLines(collection, string, string2, true);
    }

    public static File appendLines(Collection collection, File file, String string) {
        return FileUtil.writeLines(collection, file, string, true);
    }

    public static File appendLines(Collection collection, String string, Charset charset) {
        return FileUtil.writeLines(collection, string, charset, true);
    }

    public static File appendLines(Collection collection, File file, Charset charset) {
        return FileUtil.writeLines(collection, file, charset, true);
    }

    public static File writeLines(Collection collection, String string, String string2, boolean bl) {
        return FileUtil.writeLines(collection, FileUtil.file(string), string2, bl);
    }

    public static File writeLines(Collection collection, String string, Charset charset, boolean bl) {
        return FileUtil.writeLines(collection, FileUtil.file(string), charset, bl);
    }

    public static File writeLines(Collection collection, File file, String string, boolean bl) {
        return FileWriter.create(file, CharsetUtil.charset(string)).writeLines(collection, bl);
    }

    public static File writeLines(Collection collection, File file, Charset charset, boolean bl) {
        return FileWriter.create(file, charset).writeLines(collection, bl);
    }

    public static File writeUtf8Map(Map map, File file, String string, boolean bl) {
        return FileWriter.create(file, CharsetUtil.CHARSET_UTF_8).writeMap(map, string, bl);
    }

    public static File writeMap(Map map, File file, Charset charset, String string, boolean bl) {
        return FileWriter.create(file, charset).writeMap(map, string, bl);
    }

    public static File writeBytes(byte[] byArray, String string) {
        return FileUtil.writeBytes(byArray, FileUtil.touch(string));
    }

    public static File writeBytes(byte[] byArray, File file) {
        return FileUtil.writeBytes(byArray, file, 0, byArray.length, false);
    }

    public static File writeBytes(byte[] byArray, File file, int n2, int n3, boolean bl) {
        return FileWriter.create(file).write(byArray, n2, n3, bl);
    }

    public static File writeFromStream(InputStream inputStream, File file) {
        return FileWriter.create(file).writeFromStream(inputStream);
    }

    public static File writeFromStream(InputStream inputStream, String string) {
        return FileUtil.writeFromStream(inputStream, FileUtil.touch(string));
    }

    public static long writeToStream(File file, OutputStream outputStream) {
        return FileReader.create(file).writeToStream(outputStream);
    }

    public static long writeToStream(String string, OutputStream outputStream) {
        return FileUtil.writeToStream(FileUtil.touch(string), outputStream);
    }

    public static String readableFileSize(File file) {
        return FileUtil.readableFileSize(file.length());
    }

    public static String readableFileSize(long l2) {
        return DataSizeUtil.format(l2);
    }

    public static File convertCharset(File file, Charset charset, Charset charset2) {
        return CharsetUtil.convert(file, charset, charset2);
    }

    public static File convertLineSeparator(File file, Charset charset, LineSeparator lineSeparator) {
        List list = FileUtil.readLines(file, charset);
        return FileWriter.create(file, charset).writeLines(list, lineSeparator, false);
    }

    public static String cleanInvalid(String string) {
        return FileNameUtil.cleanInvalid(string);
    }

    public static boolean containsInvalid(String string) {
        return FileNameUtil.containsInvalid(string);
    }

    public static long checksumCRC32(File file) {
        return FileUtil.checksum(file, new CRC32()).getValue();
    }

    public static Checksum checksum(File file, Checksum checksum) {
        Assert.notNull(file, "File is null !", new Object[0]);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Checksums can't be computed on directories");
        }
        try {
            return IoUtil.checksum(new FileInputStream(file), checksum);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IORuntimeException(fileNotFoundException);
        }
    }

    public static File getWebRoot() {
        String string = ClassUtil.getClassPath();
        if (StrUtil.isNotBlank(string)) {
            return FileUtil.getParent(FileUtil.file(string), 2);
        }
        return null;
    }

    public static String getParent(String string, int n2) {
        File file = FileUtil.getParent(FileUtil.file(string), n2);
        try {
            return null == file ? null : file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static File getParent(File file, int n2) {
        File file2;
        if (n2 < 1 || null == file) {
            return file;
        }
        try {
            file2 = file.getCanonicalFile().getParentFile();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        if (1 == n2) {
            return file2;
        }
        return FileUtil.getParent(file2, n2 - 1);
    }

    public static File checkSlip(File file, File file2) {
        if (null != file && null != file2) {
            String string;
            String string2;
            try {
                string2 = file.getCanonicalPath();
                string = file2.getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new IORuntimeException(iOException);
            }
            if (!string.startsWith(string2)) {
                throw new IllegalArgumentException("New file is outside of the parent dir: " + file2.getName());
            }
        }
        return file2;
    }

    public static String getMimeType(String string) {
        return URLConnection.getFileNameMap().getContentTypeFor(string);
    }

    public static boolean isSymlink(File file) {
        return FileUtil.isSymlink(file.toPath());
    }

    public static boolean isSub(File file, File file2) {
        Assert.notNull(file);
        Assert.notNull(file2);
        return file2.toPath().startsWith(file.toPath());
    }

    public static RandomAccessFile createRandomAccessFile(Path path, FileMode fileMode) {
        return FileUtil.createRandomAccessFile(path.toFile(), fileMode);
    }

    public static RandomAccessFile createRandomAccessFile(File file, FileMode fileMode) {
        try {
            return new RandomAccessFile(file, fileMode.name());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IORuntimeException(fileNotFoundException);
        }
    }

    public static void tail(File file, LineHandler lineHandler) {
        FileUtil.tail(file, CharsetUtil.CHARSET_UTF_8, lineHandler);
    }

    public static void tail(File file, Charset charset, LineHandler lineHandler) {
        new Tailer(file, charset, lineHandler).start();
    }

    public static void tail(File file, Charset charset) {
        FileUtil.tail(file, charset, Tailer.CONSOLE_HANDLER);
    }
}

