/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io;

import com.ccb.core.io.IORuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class BOMInputStream
extends InputStream {
    private final PushbackInputStream in;
    private boolean isInited = false;
    private final String defaultCharset;
    private String charset;
    private static final int BOM_SIZE = 4;

    public BOMInputStream(InputStream inputStream) {
        this(inputStream, "UTF-8");
    }

    public BOMInputStream(InputStream inputStream, String string) {
        this.in = new PushbackInputStream(inputStream, 4);
        this.defaultCharset = string;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    public String getCharset() {
        if (!this.isInited) {
            try {
                this.init();
            }
            catch (IOException iOException) {
                throw new IORuntimeException(iOException);
            }
        }
        return this.charset;
    }

    @Override
    public void close() {
        this.isInited = true;
        this.in.close();
    }

    @Override
    public int read() {
        this.isInited = true;
        return this.in.read();
    }

    protected void init() {
        int n2;
        if (this.isInited) {
            return;
        }
        byte[] byArray = new byte[4];
        int n3 = this.in.read(byArray, 0, byArray.length);
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
            this.charset = "UTF-32BE";
            n2 = n3 - 4;
        } else if (byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
            this.charset = "UTF-32LE";
            n2 = n3 - 4;
        } else if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            this.charset = "UTF-8";
            n2 = n3 - 3;
        } else if (byArray[0] == -2 && byArray[1] == -1) {
            this.charset = "UTF-16BE";
            n2 = n3 - 2;
        } else if (byArray[0] == -1 && byArray[1] == -2) {
            this.charset = "UTF-16LE";
            n2 = n3 - 2;
        } else {
            this.charset = this.defaultCharset;
            n2 = n3;
        }
        if (n2 > 0) {
            this.in.unread(byArray, n3 - n2, n2);
        }
        this.isInited = true;
    }
}

