/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.img.gif;

import com.ccb.core.img.gif.LZWEncoder;
import com.ccb.core.img.gif.NeuQuant;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class AnimatedGifEncoder {
    protected int width;
    protected int height;
    protected Color transparent = null;
    protected boolean transparentExactMatch = false;
    protected Color background = null;
    protected int transIndex;
    protected int repeat = -1;
    protected int delay = 0;
    protected boolean started = false;
    protected OutputStream out;
    protected BufferedImage image;
    protected byte[] pixels;
    protected byte[] indexedPixels;
    protected int colorDepth;
    protected byte[] colorTab;
    protected boolean[] usedEntry = new boolean[256];
    protected int palSize = 7;
    protected int dispose = -1;
    protected boolean closeStream = false;
    protected boolean firstFrame = true;
    protected boolean sizeSet = false;
    protected int sample = 10;

    public void setDelay(int n2) {
        this.delay = Math.round((float)n2 / 10.0f);
    }

    public void setDispose(int n2) {
        if (n2 >= 0) {
            this.dispose = n2;
        }
    }

    public void setRepeat(int n2) {
        if (n2 >= 0) {
            this.repeat = n2;
        }
    }

    public void setTransparent(Color color) {
        this.setTransparent(color, false);
    }

    public void setTransparent(Color color, boolean bl) {
        this.transparent = color;
        this.transparentExactMatch = bl;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public boolean addFrame(BufferedImage bufferedImage) {
        if (bufferedImage == null || !this.started) {
            return false;
        }
        boolean bl = true;
        try {
            if (!this.sizeSet) {
                this.setSize(bufferedImage.getWidth(), bufferedImage.getHeight());
            }
            this.image = bufferedImage;
            this.getImagePixels();
            this.analyzePixels();
            if (this.firstFrame) {
                this.writeLSD();
                this.writePalette();
                if (this.repeat >= 0) {
                    this.writeNetscapeExt();
                }
            }
            this.writeGraphicCtrlExt();
            this.writeImageDesc();
            if (!this.firstFrame) {
                this.writePalette();
            }
            this.writePixels();
            this.firstFrame = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public boolean finish() {
        if (!this.started) {
            return false;
        }
        boolean bl = true;
        this.started = false;
        try {
            this.out.write(59);
            this.out.flush();
            if (this.closeStream) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.transIndex = 0;
        this.out = null;
        this.image = null;
        this.pixels = null;
        this.indexedPixels = null;
        this.colorTab = null;
        this.closeStream = false;
        this.firstFrame = true;
        return bl;
    }

    public void setFrameRate(float f2) {
        if (f2 != 0.0f) {
            this.delay = Math.round(100.0f / f2);
        }
    }

    public void setQuality(int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        this.sample = n2;
    }

    public void setSize(int n2, int n3) {
        if (this.started && !this.firstFrame) {
            return;
        }
        this.width = n2;
        this.height = n3;
        if (this.width < 1) {
            this.width = 320;
        }
        if (this.height < 1) {
            this.height = 240;
        }
        this.sizeSet = true;
    }

    public boolean start(OutputStream outputStream) {
        if (outputStream == null) {
            return false;
        }
        boolean bl = true;
        this.closeStream = false;
        this.out = outputStream;
        try {
            this.writeString("GIF89a");
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.started = bl;
        return this.started;
    }

    public boolean start(String string) {
        boolean bl;
        try {
            this.out = new BufferedOutputStream(new FileOutputStream(string));
            bl = this.start(this.out);
            this.closeStream = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.started = bl;
        return this.started;
    }

    public boolean isStarted() {
        return this.started;
    }

    protected void analyzePixels() {
        int n2;
        int n3;
        int n4 = this.pixels.length;
        int n5 = n4 / 3;
        this.indexedPixels = new byte[n5];
        NeuQuant neuQuant = new NeuQuant(this.pixels, n4, this.sample);
        this.colorTab = neuQuant.process();
        for (n3 = 0; n3 < this.colorTab.length; n3 += 3) {
            n2 = this.colorTab[n3];
            this.colorTab[n3] = this.colorTab[n3 + 2];
            this.colorTab[n3 + 2] = n2;
            this.usedEntry[n3 / 3] = false;
        }
        n3 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            int n6 = neuQuant.map(this.pixels[n3++] & 0xFF, this.pixels[n3++] & 0xFF, this.pixels[n3++] & 0xFF);
            this.usedEntry[n6] = true;
            this.indexedPixels[n2] = (byte)n6;
        }
        this.pixels = null;
        this.colorDepth = 8;
        this.palSize = 7;
        if (this.transparent != null) {
            this.transIndex = this.transparentExactMatch ? this.findExact(this.transparent) : this.findClosest(this.transparent);
        }
    }

    protected int findClosest(Color color) {
        if (this.colorTab == null) {
            return -1;
        }
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        int n5 = 0;
        int n6 = 0x1000000;
        int n7 = this.colorTab.length;
        for (int i2 = 0; i2 < n7; ++i2) {
            int n8 = n2 - (this.colorTab[i2++] & 0xFF);
            int n9 = n3 - (this.colorTab[i2++] & 0xFF);
            int n10 = n4 - (this.colorTab[i2] & 0xFF);
            int n11 = n8 * n8 + n9 * n9 + n10 * n10;
            int n12 = i2 / 3;
            if (!this.usedEntry[n12] || n11 >= n6) continue;
            n6 = n11;
            n5 = n12;
        }
        return n5;
    }

    boolean isColorUsed(Color color) {
        return this.findExact(color) != -1;
    }

    protected int findExact(Color color) {
        if (this.colorTab == null) {
            return -1;
        }
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        int n5 = this.colorTab.length / 3;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n6 = i2 * 3;
            if (!this.usedEntry[i2] || n2 != (this.colorTab[n6] & 0xFF) || n3 != (this.colorTab[n6 + 1] & 0xFF) || n4 != (this.colorTab[n6 + 2] & 0xFF)) continue;
            return i2;
        }
        return -1;
    }

    protected void getImagePixels() {
        int n2 = this.image.getWidth();
        int n3 = this.image.getHeight();
        int n4 = this.image.getType();
        if (n2 != this.width || n3 != this.height || n4 != 5) {
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 5);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(this.background);
            graphics2D.fillRect(0, 0, this.width, this.height);
            graphics2D.drawImage((Image)this.image, 0, 0, null);
            this.image = bufferedImage;
        }
        this.pixels = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
    }

    protected void writeGraphicCtrlExt() {
        int n2;
        int n3;
        this.out.write(33);
        this.out.write(249);
        this.out.write(4);
        if (this.transparent == null) {
            n3 = 0;
            n2 = 0;
        } else {
            n3 = 1;
            n2 = 2;
        }
        if (this.dispose >= 0) {
            n2 = this.dispose & 7;
        }
        this.out.write(0 | (n2 <<= 2) | 0 | n3);
        this.writeShort(this.delay);
        this.out.write(this.transIndex);
        this.out.write(0);
    }

    protected void writeImageDesc() {
        this.out.write(44);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.width);
        this.writeShort(this.height);
        if (this.firstFrame) {
            this.out.write(0);
        } else {
            this.out.write(0x80 | this.palSize);
        }
    }

    protected void writeLSD() {
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(0xF0 | this.palSize);
        this.out.write(0);
        this.out.write(0);
    }

    protected void writeNetscapeExt() {
        this.out.write(33);
        this.out.write(255);
        this.out.write(11);
        this.writeString("NETSCAPE2.0");
        this.out.write(3);
        this.out.write(1);
        this.writeShort(this.repeat);
        this.out.write(0);
    }

    protected void writePalette() {
        this.out.write(this.colorTab, 0, this.colorTab.length);
        int n2 = 768 - this.colorTab.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.out.write(0);
        }
    }

    protected void writePixels() {
        LZWEncoder lZWEncoder = new LZWEncoder(this.width, this.height, this.indexedPixels, this.colorDepth);
        lZWEncoder.encode(this.out);
    }

    protected void writeShort(int n2) {
        this.out.write(n2 & 0xFF);
        this.out.write(n2 >> 8 & 0xFF);
    }

    protected void writeString(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            this.out.write((byte)string.charAt(i2));
        }
    }
}

