/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.img;

import com.ccb.core.codec.Base64;
import com.ccb.core.convert.Convert;
import com.ccb.core.img.BackgroundRemoval;
import com.ccb.core.img.FontUtil;
import com.ccb.core.img.GraphicsUtil;
import com.ccb.core.img.Img;
import com.ccb.core.io.FileUtil;
import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.IoUtil;
import com.ccb.core.io.resource.Resource;
import com.ccb.core.lang.Assert;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.NumberUtil;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.RandomUtil;
import com.ccb.core.util.StrUtil;
import com.ccb.core.util.URLUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class ImgUtil {
    public static final String IMAGE_TYPE_GIF = "gif";
    public static final String IMAGE_TYPE_JPG = "jpg";
    public static final String IMAGE_TYPE_JPEG = "jpeg";
    public static final String IMAGE_TYPE_BMP = "bmp";
    public static final String IMAGE_TYPE_PNG = "png";
    public static final String IMAGE_TYPE_PSD = "psd";
    private static final int RGB_COLOR_BOUND = 256;

    public static void scale(File file, File file2, float f2) {
        ImgUtil.scale((Image)ImgUtil.read(file), file2, f2);
    }

    public static void scale(InputStream inputStream, OutputStream outputStream, float f2) {
        ImgUtil.scale((Image)ImgUtil.read(inputStream), outputStream, f2);
    }

    public static void scale(ImageInputStream imageInputStream, ImageOutputStream imageOutputStream, float f2) {
        ImgUtil.scale((Image)ImgUtil.read(imageInputStream), imageOutputStream, f2);
    }

    public static void scale(Image image, File file, float f2) {
        Img.from(image).setTargetImageType(FileUtil.extName(file)).scale(f2).write(file);
    }

    public static void scale(Image image, OutputStream outputStream, float f2) {
        ImgUtil.scale(image, ImgUtil.getImageOutputStream(outputStream), f2);
    }

    public static void scale(Image image, ImageOutputStream imageOutputStream, float f2) {
        ImgUtil.writeJpg(ImgUtil.scale(image, f2), imageOutputStream);
    }

    public static Image scale(Image image, float f2) {
        return Img.from(image).scale(f2).getImg();
    }

    public static Image scale(Image image, int n2, int n3) {
        return Img.from(image).scale(n2, n3).getImg();
    }

    public static void scale(File file, File file2, int n2, int n3, Color color) {
        Img.from(file).setTargetImageType(FileUtil.extName(file2)).scale(n2, n3, color).write(file2);
    }

    public static void scale(InputStream inputStream, OutputStream outputStream, int n2, int n3, Color color) {
        ImgUtil.scale(ImgUtil.read(inputStream), ImgUtil.getImageOutputStream(outputStream), n2, n3, color);
    }

    public static void scale(ImageInputStream imageInputStream, ImageOutputStream imageOutputStream, int n2, int n3, Color color) {
        ImgUtil.scale(ImgUtil.read(imageInputStream), imageOutputStream, n2, n3, color);
    }

    public static void scale(Image image, ImageOutputStream imageOutputStream, int n2, int n3, Color color) {
        ImgUtil.writeJpg(ImgUtil.scale(image, n2, n3, color), imageOutputStream);
    }

    public static Image scale(Image image, int n2, int n3, Color color) {
        return Img.from(image).scale(n2, n3, color).getImg();
    }

    public static void cut(File file, File file2, Rectangle rectangle) {
        ImgUtil.cut((Image)ImgUtil.read(file), file2, rectangle);
    }

    public static void cut(InputStream inputStream, OutputStream outputStream, Rectangle rectangle) {
        ImgUtil.cut((Image)ImgUtil.read(inputStream), outputStream, rectangle);
    }

    public static void cut(ImageInputStream imageInputStream, ImageOutputStream imageOutputStream, Rectangle rectangle) {
        ImgUtil.cut((Image)ImgUtil.read(imageInputStream), imageOutputStream, rectangle);
    }

    public static void cut(Image image, File file, Rectangle rectangle) {
        ImgUtil.write(ImgUtil.cut(image, rectangle), file);
    }

    public static void cut(Image image, OutputStream outputStream, Rectangle rectangle) {
        ImgUtil.cut(image, ImgUtil.getImageOutputStream(outputStream), rectangle);
    }

    public static void cut(Image image, ImageOutputStream imageOutputStream, Rectangle rectangle) {
        ImgUtil.writeJpg(ImgUtil.cut(image, rectangle), imageOutputStream);
    }

    public static Image cut(Image image, Rectangle rectangle) {
        return Img.from(image).setPositionBaseCentre(false).cut(rectangle).getImg();
    }

    public static Image cut(Image image, int n2, int n3) {
        return ImgUtil.cut(image, n2, n3, -1);
    }

    public static Image cut(Image image, int n2, int n3, int n4) {
        return Img.from(image).cut(n2, n3, n4).getImg();
    }

    public static void slice(File file, File file2, int n2, int n3) {
        ImgUtil.slice(ImgUtil.read(file), file2, n2, n3);
    }

    public static void slice(Image image, File file, int n2, int n3) {
        if (n2 <= 0) {
            n2 = 200;
        }
        if (n3 <= 0) {
            n3 = 150;
        }
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        if (n4 < n2) {
            n2 = n4;
        }
        if (n5 < n3) {
            n3 = n5;
        }
        int n6 = n4 % n2 == 0 ? n4 / n2 : (int)Math.floor((double)n4 / (double)n2) + 1;
        int n7 = n5 % n3 == 0 ? n5 / n3 : (int)Math.floor((double)n5 / (double)n3) + 1;
        for (int i2 = 0; i2 < n7; ++i2) {
            for (int i3 = 0; i3 < n6; ++i3) {
                Image image2 = ImgUtil.cut(image, new Rectangle(i3 * n2, i2 * n3, n2, n3));
                ImgUtil.write(image2, FileUtil.file(file, "_r" + i2 + "_c" + i3 + ".jpg"));
            }
        }
    }

    public static void sliceByRowsAndCols(File file, File file2, int n2, int n3) {
        try {
            ImgUtil.sliceByRowsAndCols(ImageIO.read(file), file2, n2, n3);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static void sliceByRowsAndCols(Image image, File file, int n2, int n3) {
        if (!file.exists()) {
            FileUtil.mkdir(file);
        } else if (!file.isDirectory()) {
            throw new IllegalArgumentException("Destination Dir must be a Directory !");
        }
        try {
            if (n2 <= 0 || n2 > 20) {
                n2 = 2;
            }
            if (n3 <= 0 || n3 > 20) {
                n3 = 2;
            }
            BufferedImage bufferedImage = ImgUtil.toBufferedImage(image);
            int n4 = bufferedImage.getWidth();
            int n5 = bufferedImage.getHeight();
            int n6 = NumberUtil.partValue(n4, n3);
            int n7 = NumberUtil.partValue(n5, n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i3 = 0; i3 < n3; ++i3) {
                    Image image2 = ImgUtil.cut(bufferedImage, new Rectangle(i3 * n6, i2 * n7, n6, n7));
                    ImageIO.write(ImgUtil.toRenderedImage(image2), IMAGE_TYPE_JPEG, new File(file, "_r" + i2 + "_c" + i3 + ".jpg"));
                }
            }
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File file, File file2) {
        Assert.notNull(file);
        Assert.notNull(file2);
        Assert.isFalse(file.equals(file2), "Src file is equals to dest file!", new Object[0]);
        String string = FileUtil.extName(file);
        String string2 = FileUtil.extName(file2);
        if (StrUtil.equalsIgnoreCase(string, string2)) {
            FileUtil.copy(file, file2, true);
        }
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImgUtil.getImageOutputStream(file2);
            ImgUtil.convert(ImgUtil.read(file), string2, imageOutputStream, StrUtil.equalsIgnoreCase(IMAGE_TYPE_PNG, string));
        }
        finally {
            IoUtil.close(imageOutputStream);
        }
    }

    public static void convert(InputStream inputStream, String string, OutputStream outputStream) {
        ImgUtil.write((Image)ImgUtil.read(inputStream), string, ImgUtil.getImageOutputStream(outputStream));
    }

    public static void convert(Image image, String string, ImageOutputStream imageOutputStream, boolean bl) {
        try {
            ImageIO.write((RenderedImage)(bl ? ImgUtil.copyImage(image, 1) : ImgUtil.toBufferedImage(image)), string, imageOutputStream);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static void gray(File file, File file2) {
        ImgUtil.gray((Image)ImgUtil.read(file), file2);
    }

    public static void gray(InputStream inputStream, OutputStream outputStream) {
        ImgUtil.gray((Image)ImgUtil.read(inputStream), ImgUtil.getImageOutputStream(outputStream));
    }

    public static void gray(ImageInputStream imageInputStream, ImageOutputStream imageOutputStream) {
        ImgUtil.gray((Image)ImgUtil.read(imageInputStream), imageOutputStream);
    }

    public static void gray(Image image, File file) {
        ImgUtil.write(ImgUtil.gray(image), file);
    }

    public static void gray(Image image, OutputStream outputStream) {
        ImgUtil.gray(image, ImgUtil.getImageOutputStream(outputStream));
    }

    public static void gray(Image image, ImageOutputStream imageOutputStream) {
        ImgUtil.writeJpg(ImgUtil.gray(image), imageOutputStream);
    }

    public static Image gray(Image image) {
        return Img.from(image).gray().getImg();
    }

    public static void binary(File file, File file2) {
        ImgUtil.binary(ImgUtil.read(file), file2);
    }

    public static void binary(InputStream inputStream, OutputStream outputStream, String string) {
        ImgUtil.binary((Image)ImgUtil.read(inputStream), ImgUtil.getImageOutputStream(outputStream), string);
    }

    public static void binary(ImageInputStream imageInputStream, ImageOutputStream imageOutputStream, String string) {
        ImgUtil.binary((Image)ImgUtil.read(imageInputStream), imageOutputStream, string);
    }

    public static void binary(Image image, File file) {
        ImgUtil.write(ImgUtil.binary(image), file);
    }

    public static void binary(Image image, OutputStream outputStream, String string) {
        ImgUtil.binary(image, ImgUtil.getImageOutputStream(outputStream), string);
    }

    public static void binary(Image image, ImageOutputStream imageOutputStream, String string) {
        ImgUtil.write(ImgUtil.binary(image), string, imageOutputStream);
    }

    public static Image binary(Image image) {
        return Img.from(image).binary().getImg();
    }

    public static void pressText(File file, File file2, String string, Color color, Font font, int n2, int n3, float f2) {
        ImgUtil.pressText((Image)ImgUtil.read(file), file2, string, color, font, n2, n3, f2);
    }

    public static void pressText(InputStream inputStream, OutputStream outputStream, String string, Color color, Font font, int n2, int n3, float f2) {
        ImgUtil.pressText((Image)ImgUtil.read(inputStream), ImgUtil.getImageOutputStream(outputStream), string, color, font, n2, n3, f2);
    }

    public static void pressText(ImageInputStream imageInputStream, ImageOutputStream imageOutputStream, String string, Color color, Font font, int n2, int n3, float f2) {
        ImgUtil.pressText((Image)ImgUtil.read(imageInputStream), imageOutputStream, string, color, font, n2, n3, f2);
    }

    public static void pressText(Image image, File file, String string, Color color, Font font, int n2, int n3, float f2) {
        ImgUtil.write(ImgUtil.pressText(image, string, color, font, n2, n3, f2), file);
    }

    public static void pressText(Image image, OutputStream outputStream, String string, Color color, Font font, int n2, int n3, float f2) {
        ImgUtil.pressText(image, ImgUtil.getImageOutputStream(outputStream), string, color, font, n2, n3, f2);
    }

    public static void pressText(Image image, ImageOutputStream imageOutputStream, String string, Color color, Font font, int n2, int n3, float f2) {
        ImgUtil.writeJpg(ImgUtil.pressText(image, string, color, font, n2, n3, f2), imageOutputStream);
    }

    public static Image pressText(Image image, String string, Color color, Font font, int n2, int n3, float f2) {
        return Img.from(image).pressText(string, color, font, n2, n3, f2).getImg();
    }

    public static void pressImage(File file, File file2, Image image, int n2, int n3, float f2) {
        ImgUtil.pressImage((Image)ImgUtil.read(file), file2, image, n2, n3, f2);
    }

    public static void pressImage(InputStream inputStream, OutputStream outputStream, Image image, int n2, int n3, float f2) {
        ImgUtil.pressImage((Image)ImgUtil.read(inputStream), ImgUtil.getImageOutputStream(outputStream), image, n2, n3, f2);
    }

    public static void pressImage(ImageInputStream imageInputStream, ImageOutputStream imageOutputStream, Image image, int n2, int n3, float f2) {
        ImgUtil.pressImage((Image)ImgUtil.read(imageInputStream), imageOutputStream, image, n2, n3, f2);
    }

    public static void pressImage(Image image, File file, Image image2, int n2, int n3, float f2) {
        ImgUtil.write(ImgUtil.pressImage(image, image2, n2, n3, f2), file);
    }

    public static void pressImage(Image image, OutputStream outputStream, Image image2, int n2, int n3, float f2) {
        ImgUtil.pressImage(image, ImgUtil.getImageOutputStream(outputStream), image2, n2, n3, f2);
    }

    public static void pressImage(Image image, ImageOutputStream imageOutputStream, Image image2, int n2, int n3, float f2) {
        ImgUtil.writeJpg(ImgUtil.pressImage(image, image2, n2, n3, f2), imageOutputStream);
    }

    public static Image pressImage(Image image, Image image2, int n2, int n3, float f2) {
        return Img.from(image).pressImage(image2, n2, n3, f2).getImg();
    }

    public static Image pressImage(Image image, Image image2, Rectangle rectangle, float f2) {
        return Img.from(image).pressImage(image2, rectangle, f2).getImg();
    }

    public static void rotate(File file, int n2, File file2) {
        ImgUtil.rotate((Image)ImgUtil.read(file), n2, file2);
    }

    public static void rotate(Image image, int n2, File file) {
        ImgUtil.write(ImgUtil.rotate(image, n2), file);
    }

    public static void rotate(Image image, int n2, OutputStream outputStream) {
        ImgUtil.writeJpg(ImgUtil.rotate(image, n2), ImgUtil.getImageOutputStream(outputStream));
    }

    public static void rotate(Image image, int n2, ImageOutputStream imageOutputStream) {
        ImgUtil.writeJpg(ImgUtil.rotate(image, n2), imageOutputStream);
    }

    public static Image rotate(Image image, int n2) {
        return Img.from(image).rotate(n2).getImg();
    }

    public static void flip(File file, File file2) {
        ImgUtil.flip((Image)ImgUtil.read(file), file2);
    }

    public static void flip(Image image, File file) {
        ImgUtil.write(ImgUtil.flip(image), file);
    }

    public static void flip(Image image, OutputStream outputStream) {
        ImgUtil.flip(image, ImgUtil.getImageOutputStream(outputStream));
    }

    public static void flip(Image image, ImageOutputStream imageOutputStream) {
        ImgUtil.writeJpg(ImgUtil.flip(image), imageOutputStream);
    }

    public static Image flip(Image image) {
        return Img.from(image).flip().getImg();
    }

    public static void compress(File file, File file2, float f2) {
        Img.from(file).setQuality(f2).write(file2);
    }

    public static RenderedImage toRenderedImage(Image image) {
        if (image instanceof RenderedImage) {
            return (RenderedImage)((Object)image);
        }
        return ImgUtil.copyImage(image, 1);
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        return ImgUtil.copyImage(image, 1);
    }

    public static BufferedImage toBufferedImage(Image image, String string) {
        BufferedImage bufferedImage;
        if (!string.equalsIgnoreCase(IMAGE_TYPE_PNG)) {
            if (image instanceof BufferedImage) {
                bufferedImage = (BufferedImage)image;
                if (1 != bufferedImage.getType()) {
                    bufferedImage = ImgUtil.copyImage(image, 1);
                }
            } else {
                bufferedImage = ImgUtil.copyImage(image, 1);
            }
        } else {
            bufferedImage = ImgUtil.toBufferedImage(image);
        }
        return bufferedImage;
    }

    public static BufferedImage copyImage(Image image, int n2) {
        return ImgUtil.copyImage(image, n2, null);
    }

    public static BufferedImage copyImage(Image image, int n2, Color color) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n2);
        Graphics2D graphics2D = GraphicsUtil.createGraphics(bufferedImage, color);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage toImage(String string) {
        return ImgUtil.toImage(Base64.decode(string));
    }

    public static BufferedImage toImage(byte[] byArray) {
        return ImgUtil.read(new ByteArrayInputStream(byArray));
    }

    public static ByteArrayInputStream toStream(Image image, String string) {
        return IoUtil.toStream(ImgUtil.toBytes(image, string));
    }

    public static String toBase64DataUri(Image image, String string) {
        return URLUtil.getDataUri("image/" + string, "base64", ImgUtil.toBase64(image, string));
    }

    public static String toBase64(Image image, String string) {
        return Base64.encode(ImgUtil.toBytes(image, string));
    }

    public static byte[] toBytes(Image image, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImgUtil.write(image, string, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void createImage(String string, Font font, Color color, Color color2, ImageOutputStream imageOutputStream) {
        ImgUtil.writePng((Image)ImgUtil.createImage(string, font, color, color2, 2), imageOutputStream);
    }

    public static BufferedImage createImage(String string, Font font, Color color, Color color2, int n2) {
        Rectangle2D rectangle2D = ImgUtil.getRectangle(string, font);
        int n3 = (int)Math.floor(rectangle2D.getHeight());
        int n4 = (int)Math.round(rectangle2D.getWidth()) + 1;
        int n5 = n3 + 3;
        BufferedImage bufferedImage = new BufferedImage(n4, n5, n2);
        Graphics graphics = bufferedImage.getGraphics();
        if (null != color) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, n4, n5);
        }
        graphics.setColor((Color)ObjectUtil.defaultIfNull(color2, Color.BLACK));
        graphics.setFont(font);
        graphics.drawString(string, 0, font.getSize());
        graphics.dispose();
        return bufferedImage;
    }

    public static Rectangle2D getRectangle(String string, Font font) {
        return font.getStringBounds(string, new FontRenderContext(AffineTransform.getScaleInstance(1.0, 1.0), false, false));
    }

    public static Font createFont(File file) {
        return FontUtil.createFont(file);
    }

    public static Font createFont(InputStream inputStream) {
        return FontUtil.createFont(inputStream);
    }

    public static Graphics2D createGraphics(BufferedImage bufferedImage, Color color) {
        return GraphicsUtil.createGraphics(bufferedImage, color);
    }

    public static void writeJpg(Image image, ImageOutputStream imageOutputStream) {
        ImgUtil.write(image, IMAGE_TYPE_JPG, imageOutputStream);
    }

    public static void writePng(Image image, ImageOutputStream imageOutputStream) {
        ImgUtil.write(image, IMAGE_TYPE_PNG, imageOutputStream);
    }

    public static void writeJpg(Image image, OutputStream outputStream) {
        ImgUtil.write(image, IMAGE_TYPE_JPG, outputStream);
    }

    public static void writePng(Image image, OutputStream outputStream) {
        ImgUtil.write(image, IMAGE_TYPE_PNG, outputStream);
    }

    public static void write(ImageInputStream imageInputStream, String string, ImageOutputStream imageOutputStream) {
        ImgUtil.write((Image)ImgUtil.read(imageInputStream), string, imageOutputStream);
    }

    public static void write(Image image, String string, OutputStream outputStream) {
        ImgUtil.write(image, string, ImgUtil.getImageOutputStream(outputStream));
    }

    public static boolean write(Image image, String string, ImageOutputStream imageOutputStream) {
        return ImgUtil.write(image, string, imageOutputStream, 1.0f);
    }

    public static boolean write(Image image, String string, ImageOutputStream imageOutputStream, float f2) {
        if (StrUtil.isBlank(string)) {
            string = IMAGE_TYPE_JPG;
        }
        ImageWriter imageWriter = ImgUtil.getWriter(image, string);
        return ImgUtil.write((Image)ImgUtil.toBufferedImage(image, string), imageWriter, imageOutputStream, f2);
    }

    public static void write(Image image, File file) {
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImgUtil.getImageOutputStream(file);
            ImgUtil.write(image, FileUtil.extName(file), imageOutputStream);
        }
        finally {
            IoUtil.close(imageOutputStream);
        }
    }

    public static boolean write(Image image, ImageWriter imageWriter, ImageOutputStream imageOutputStream, float f2) {
        if (imageWriter == null) {
            return false;
        }
        imageWriter.setOutput(imageOutputStream);
        RenderedImage renderedImage = ImgUtil.toRenderedImage(image);
        ImageWriteParam imageWriteParam = null;
        if (f2 > 0.0f && f2 < 1.0f && (imageWriteParam = imageWriter.getDefaultWriteParam()).canWriteCompressed()) {
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionQuality(f2);
            ColorModel colorModel = renderedImage.getColorModel();
            imageWriteParam.setDestinationType(new ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(16, 16)));
        }
        try {
            if (null != imageWriteParam) {
                imageWriter.write(null, new IIOImage(renderedImage, null, null), imageWriteParam);
            } else {
                imageWriter.write(renderedImage);
            }
            imageOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        finally {
            imageWriter.dispose();
        }
        return true;
    }

    public static ImageReader getReader(String string) {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static BufferedImage read(String string) {
        return ImgUtil.read(FileUtil.file(string));
    }

    public static BufferedImage read(File file) {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        if (null == bufferedImage) {
            throw new IllegalArgumentException("Image type of file [" + file.getName() + "] is not supported!");
        }
        return bufferedImage;
    }

    public static BufferedImage read(Resource resource) {
        return ImgUtil.read(resource.getStream());
    }

    public static BufferedImage read(InputStream inputStream) {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(inputStream);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        if (null == bufferedImage) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return bufferedImage;
    }

    public static BufferedImage read(ImageInputStream imageInputStream) {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(imageInputStream);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        if (null == bufferedImage) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return bufferedImage;
    }

    public static BufferedImage read(URL uRL) {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        if (null == bufferedImage) {
            throw new IllegalArgumentException("Image type of [" + uRL.toString() + "] is not supported!");
        }
        return bufferedImage;
    }

    public static ImageOutputStream getImageOutputStream(OutputStream outputStream) {
        ImageOutputStream imageOutputStream;
        try {
            imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        if (null == imageOutputStream) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return imageOutputStream;
    }

    public static ImageOutputStream getImageOutputStream(File file) {
        ImageOutputStream imageOutputStream;
        try {
            imageOutputStream = ImageIO.createImageOutputStream(file);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        if (null == imageOutputStream) {
            throw new IllegalArgumentException("Image type of file [" + file.getName() + "] is not supported!");
        }
        return imageOutputStream;
    }

    public static ImageInputStream getImageInputStream(InputStream inputStream) {
        ImageOutputStream imageOutputStream;
        try {
            imageOutputStream = ImageIO.createImageOutputStream(inputStream);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        if (null == imageOutputStream) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return imageOutputStream;
    }

    public static ImageWriter getWriter(Image image, String string) {
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(ImgUtil.toRenderedImage(image));
        Iterator<ImageWriter> iterator = ImageIO.getImageWriters(imageTypeSpecifier, string);
        return iterator.hasNext() ? iterator.next() : null;
    }

    public static ImageWriter getWriter(String string) {
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        if (null == imageWriter && (iterator = ImageIO.getImageWritersBySuffix(string)).hasNext()) {
            imageWriter = iterator.next();
        }
        return imageWriter;
    }

    public static String toHex(Color color) {
        return ImgUtil.toHex(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static String toHex(int n2, int n3, int n4) {
        if (n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255 || n4 < 0 || n4 > 255) {
            throw new IllegalArgumentException("RGB must be 0~255!");
        }
        return String.format("#%02X%02X%02X", n2, n3, n4);
    }

    public static Color hexToColor(String string) {
        return ImgUtil.getColor(Integer.parseInt(StrUtil.removePrefix(string, "#"), 16));
    }

    public static Color getColor(int n2) {
        return new Color(n2);
    }

    public static Color getColor(String string) {
        if (StrUtil.isBlank(string)) {
            return null;
        }
        if ("BLACK".equals(string = string.toUpperCase())) {
            return Color.BLACK;
        }
        if ("WHITE".equals(string)) {
            return Color.WHITE;
        }
        if ("LIGHTGRAY".equals(string) || "LIGHT_GRAY".equals(string)) {
            return Color.LIGHT_GRAY;
        }
        if ("GRAY".equals(string)) {
            return Color.GRAY;
        }
        if ("DARKGRAY".equals(string) || "DARK_GRAY".equals(string)) {
            return Color.DARK_GRAY;
        }
        if ("RED".equals(string)) {
            return Color.RED;
        }
        if ("PINK".equals(string)) {
            return Color.PINK;
        }
        if ("ORANGE".equals(string)) {
            return Color.ORANGE;
        }
        if ("YELLOW".equals(string)) {
            return Color.YELLOW;
        }
        if ("GREEN".equals(string)) {
            return Color.GREEN;
        }
        if ("MAGENTA".equals(string)) {
            return Color.MAGENTA;
        }
        if ("CYAN".equals(string)) {
            return Color.CYAN;
        }
        if ("BLUE".equals(string)) {
            return Color.BLUE;
        }
        if ("DARKGOLD".equals(string)) {
            return ImgUtil.hexToColor("#9e7e67");
        }
        if ("LIGHTGOLD".equals(string)) {
            return ImgUtil.hexToColor("#ac9c85");
        }
        if (StrUtil.startWith((CharSequence)string, '#')) {
            return ImgUtil.hexToColor(string);
        }
        if (StrUtil.startWith((CharSequence)string, '$')) {
            return ImgUtil.hexToColor("#" + string.substring(1));
        }
        List list = StrUtil.split((CharSequence)string, ',');
        if (3 == list.size()) {
            Integer n2;
            Integer n3;
            Integer n4 = Convert.toInt(list.get(0));
            if (!ArrayUtil.hasNull(n4, n3 = Convert.toInt(list.get(1)), n2 = Convert.toInt(list.get(2)))) {
                return new Color(n4, n3, n2);
            }
        } else {
            return null;
        }
        return null;
    }

    public static Color randomColor() {
        return ImgUtil.randomColor(null);
    }

    public static Color randomColor(Random random) {
        if (null == random) {
            random = RandomUtil.getRandom();
        }
        return new Color(random.nextInt(256), random.nextInt(256), random.nextInt(256));
    }

    public static Point getPointBaseCentre(Rectangle rectangle, int n2, int n3) {
        return new Point(rectangle.x + Math.abs(n2 - rectangle.width) / 2, rectangle.y + Math.abs(n3 - rectangle.height) / 2);
    }

    public static boolean backgroundRemoval(String string, String string2, int n2) {
        return BackgroundRemoval.backgroundRemoval(string, string2, n2);
    }

    public static boolean backgroundRemoval(File file, File file2, int n2) {
        return BackgroundRemoval.backgroundRemoval(file, file2, n2);
    }

    public static boolean backgroundRemoval(File file, File file2, Color color, int n2) {
        return BackgroundRemoval.backgroundRemoval(file, file2, color, n2);
    }

    public static BufferedImage backgroundRemoval(BufferedImage bufferedImage, Color color, int n2) {
        return BackgroundRemoval.backgroundRemoval(bufferedImage, color, n2);
    }

    public static BufferedImage backgroundRemoval(ByteArrayOutputStream byteArrayOutputStream, Color color, int n2) {
        return BackgroundRemoval.backgroundRemoval(byteArrayOutputStream, color, n2);
    }
}

