/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.img;

import com.ccb.core.img.FontUtil;
import com.ccb.core.img.GraphicsUtil;
import com.ccb.core.img.ImgUtil;
import com.ccb.core.io.FileUtil;
import com.ccb.core.io.IoUtil;
import com.ccb.core.io.resource.Resource;
import com.ccb.core.lang.Assert;
import com.ccb.core.util.NumberUtil;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.StrUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class Img
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final BufferedImage srcImage;
    private Image targetImage;
    private String targetImageType;
    private boolean positionBaseCentre = true;
    private float quality = -1.0f;

    public static Img from(Path path) {
        return Img.from(path.toFile());
    }

    public static Img from(File file) {
        return new Img(ImgUtil.read(file));
    }

    public static Img from(Resource resource) {
        return Img.from(resource.getStream());
    }

    public static Img from(InputStream inputStream) {
        return new Img(ImgUtil.read(inputStream));
    }

    public static Img from(ImageInputStream imageInputStream) {
        return new Img(ImgUtil.read(imageInputStream));
    }

    public static Img from(URL uRL) {
        return new Img(ImgUtil.read(uRL));
    }

    public static Img from(Image image) {
        return new Img(ImgUtil.toBufferedImage(image));
    }

    public Img(BufferedImage bufferedImage) {
        this(bufferedImage, null);
    }

    public Img(BufferedImage bufferedImage, String string) {
        this.srcImage = bufferedImage;
        if (null == string) {
            string = bufferedImage.getType() == 2 || bufferedImage.getType() == 3 || bufferedImage.getType() == 6 || bufferedImage.getType() == 7 ? "png" : "jpg";
        }
        this.targetImageType = string;
    }

    public Img setTargetImageType(String string) {
        this.targetImageType = string;
        return this;
    }

    public Img setPositionBaseCentre(boolean bl) {
        this.positionBaseCentre = bl;
        return this;
    }

    public Img setQuality(double d2) {
        return this.setQuality((float)d2);
    }

    public Img setQuality(float f2) {
        this.quality = f2 > 0.0f && f2 < 1.0f ? f2 : 1.0f;
        return this;
    }

    public Img scale(float f2) {
        if (f2 < 0.0f) {
            f2 = -f2;
        }
        Image image = this.getValidSrcImg();
        if ("png".equals(this.targetImageType)) {
            AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance(f2, f2), null);
            this.targetImage = affineTransformOp.filter(ImgUtil.toBufferedImage(image), null);
        } else {
            String string = Float.toString(f2);
            int n2 = NumberUtil.mul(Integer.toString(image.getWidth(null)), string).intValue();
            int n3 = NumberUtil.mul(Integer.toString(image.getHeight(null)), string).intValue();
            this.scale(n2, n3);
        }
        return this;
    }

    public Img scale(int n2, int n3) {
        Image image = this.getValidSrcImg();
        int n4 = image.getHeight(null);
        int n5 = image.getWidth(null);
        if (n4 == n3 && n5 == n2) {
            this.targetImage = image;
            return this;
        }
        int n6 = n4 < n3 || n5 < n2 ? 4 : 1;
        double d2 = NumberUtil.div((float)n2, (float)n5);
        double d3 = NumberUtil.div((float)n3, (float)n4);
        if ("png".equals(this.targetImageType)) {
            AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance(d2, d3), null);
            this.targetImage = affineTransformOp.filter(ImgUtil.toBufferedImage(image), null);
        } else {
            this.targetImage = image.getScaledInstance(n2, n3, n6);
        }
        return this;
    }

    public Img scale(int n2, int n3, Color color) {
        double d2;
        Image image = this.getValidSrcImg();
        int n4 = image.getHeight(null);
        int n5 = image.getWidth(null);
        double d3 = NumberUtil.div((float)n3, (float)n4);
        if (NumberUtil.equals(d3, d2 = NumberUtil.div((float)n2, (float)n5))) {
            this.scale(n2, n3);
        } else if (d2 < d3) {
            this.scale(n2, (int)((double)n4 * d2));
        } else {
            this.scale((int)((double)n5 * d3), n3);
        }
        image = this.getValidSrcImg();
        n4 = image.getHeight(null);
        n5 = image.getWidth(null);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, this.getTypeInt());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (null != color) {
            graphics2D.setBackground(color);
            graphics2D.clearRect(0, 0, n2, n3);
        }
        graphics2D.drawImage(image, (n2 - n5) / 2, (n3 - n4) / 2, n5, n4, color, null);
        graphics2D.dispose();
        this.targetImage = bufferedImage;
        return this;
    }

    public Img cut(Rectangle rectangle) {
        Image image = this.getValidSrcImg();
        this.fixRectangle(rectangle, image.getWidth(null), image.getHeight(null));
        CropImageFilter cropImageFilter = new CropImageFilter(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Image image2 = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), cropImageFilter));
        this.targetImage = ImgUtil.toBufferedImage(image2);
        return this;
    }

    public Img cut(int n2, int n3) {
        return this.cut(n2, n3, -1);
    }

    public Img cut(int n2, int n3, int n4) {
        Image image = this.getValidSrcImg();
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        int n7 = n4 > 0 ? n4 * 2 : Math.min(n5, n6);
        BufferedImage bufferedImage = new BufferedImage(n7, n7, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(new Ellipse2D.Double(0.0, 0.0, n7, n7));
        if (this.positionBaseCentre) {
            n2 = n2 - n5 / 2 + n7 / 2;
            n3 = n3 - n6 / 2 + n7 / 2;
        }
        graphics2D.drawImage(image, n2, n3, null);
        graphics2D.dispose();
        this.targetImage = bufferedImage;
        return this;
    }

    public Img round(double d2) {
        Image image = this.getValidSrcImg();
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        d2 = NumberUtil.mul(d2, (float)Math.min(n2, n3));
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.fill(new RoundRectangle2D.Double(0.0, 0.0, n2, n3, d2, d2));
        graphics2D.setComposite(AlphaComposite.SrcAtop);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        this.targetImage = bufferedImage;
        return this;
    }

    public Img gray() {
        ColorConvertOp colorConvertOp = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        this.targetImage = colorConvertOp.filter(ImgUtil.toBufferedImage(this.getValidSrcImg()), null);
        return this;
    }

    public Img binary() {
        this.targetImage = ImgUtil.copyImage(this.getValidSrcImg(), 12);
        return this;
    }

    public Img pressText(String string, Color color, Font font, int n2, int n3, float f2) {
        BufferedImage bufferedImage = ImgUtil.toBufferedImage(this.getValidSrcImg());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (null == font) {
            font = FontUtil.createSansSerifFont((int)((double)bufferedImage.getHeight() * 0.75));
        }
        graphics2D.setComposite(AlphaComposite.getInstance(10, f2));
        if (this.positionBaseCentre) {
            GraphicsUtil.drawString((Graphics)graphics2D, string, font, color, new Rectangle(n2, n3, bufferedImage.getWidth(), bufferedImage.getHeight()));
        } else {
            GraphicsUtil.drawString((Graphics)graphics2D, string, font, color, new Point(n2, n3));
        }
        graphics2D.dispose();
        this.targetImage = bufferedImage;
        return this;
    }

    public Img pressImage(Image image, int n2, int n3, float f2) {
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        return this.pressImage(image, new Rectangle(n2, n3, n4, n5), f2);
    }

    public Img pressImage(Image image, Rectangle rectangle, float f2) {
        Image image2 = this.getValidSrcImg();
        this.targetImage = this.draw(ImgUtil.toBufferedImage(image2, this.targetImageType), image, rectangle, f2);
        return this;
    }

    public Img rotate(int n2) {
        Image image = this.getValidSrcImg();
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        Rectangle rectangle = Img.calcRotatedSize(n3, n4, n2);
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, this.getTypeInt());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.translate((double)(rectangle.width - n3) / 2.0, (double)(rectangle.height - n4) / 2.0);
        graphics2D.rotate(Math.toRadians(n2), (double)n3 / 2.0, (double)n4 / 2.0);
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        this.targetImage = bufferedImage;
        return this;
    }

    public Img flip() {
        Image image = this.getValidSrcImg();
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, this.getTypeInt());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, n2, n3, n2, 0, 0, n3, null);
        graphics2D.dispose();
        this.targetImage = bufferedImage;
        return this;
    }

    public Img stroke(Color color, float f2) {
        return this.stroke(color, new BasicStroke(f2));
    }

    public Img stroke(Color color, Stroke stroke) {
        BufferedImage bufferedImage = ImgUtil.toBufferedImage(this.getValidSrcImg());
        int n2 = bufferedImage.getWidth(null);
        int n3 = bufferedImage.getHeight(null);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor((Color)ObjectUtil.defaultIfNull(color, Color.BLACK));
        if (null != stroke) {
            graphics2D.setStroke(stroke);
        }
        graphics2D.drawRect(0, 0, n2 - 1, n3 - 1);
        graphics2D.dispose();
        this.targetImage = bufferedImage;
        return this;
    }

    public Image getImg() {
        return null == this.targetImage ? this.srcImage : this.targetImage;
    }

    public boolean write(OutputStream outputStream) {
        return this.write(ImgUtil.getImageOutputStream(outputStream));
    }

    public boolean write(ImageOutputStream imageOutputStream) {
        Assert.notBlank(this.targetImageType, "Target image type is blank !", new Object[0]);
        Assert.notNull(imageOutputStream, "Target output stream is null !", new Object[0]);
        Image image = null == this.targetImage ? this.srcImage : this.targetImage;
        Assert.notNull(image, "Target image is null !", new Object[0]);
        return ImgUtil.write(image, this.targetImageType, imageOutputStream, this.quality);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(File file) {
        String string = FileUtil.extName(file);
        if (StrUtil.isNotBlank(string)) {
            this.targetImageType = string;
        }
        if (file.exists()) {
            file.delete();
        }
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImgUtil.getImageOutputStream(file);
            boolean bl = this.write(imageOutputStream);
            return bl;
        }
        finally {
            IoUtil.close(imageOutputStream);
        }
    }

    private BufferedImage draw(BufferedImage bufferedImage, Image image, Rectangle rectangle, float f2) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GraphicsUtil.setAlpha(graphics2D, f2);
        Point point = this.positionBaseCentre ? ImgUtil.getPointBaseCentre(rectangle, bufferedImage.getWidth(), bufferedImage.getHeight()) : new Point(rectangle.x, rectangle.y);
        rectangle.setLocation(point.x, point.y);
        GraphicsUtil.drawImg((Graphics)graphics2D, image, rectangle);
        graphics2D.dispose();
        return bufferedImage;
    }

    private int getTypeInt() {
        switch (this.targetImageType) {
            case "png": {
                return 2;
            }
        }
        return 1;
    }

    private Image getValidSrcImg() {
        return (Image)ObjectUtil.defaultIfNull(this.targetImage, this.srcImage);
    }

    private Rectangle fixRectangle(Rectangle rectangle, int n2, int n3) {
        if (this.positionBaseCentre) {
            rectangle.setLocation(rectangle.x + Math.abs(n2 - rectangle.width) / 2, rectangle.y + Math.abs(n3 - rectangle.height) / 2);
        }
        return rectangle;
    }

    private static Rectangle calcRotatedSize(int n2, int n3, int n4) {
        if (n4 < 0) {
            n4 += 360;
        }
        if (n4 >= 90) {
            if (n4 / 90 % 2 == 1) {
                int n5 = n3;
                n3 = n2;
                n2 = n5;
            }
            n4 %= 90;
        }
        double d2 = Math.sqrt(n3 * n3 + n2 * n2) / 2.0;
        double d3 = 2.0 * Math.sin(Math.toRadians(n4) / 2.0) * d2;
        double d4 = (Math.PI - Math.toRadians(n4)) / 2.0;
        double d5 = Math.atan((double)n3 / (double)n2);
        double d6 = Math.atan((double)n2 / (double)n3);
        int n6 = (int)(d3 * Math.cos(Math.PI - d4 - d5));
        int n7 = (int)(d3 * Math.cos(Math.PI - d4 - d6));
        int n8 = n2 + n6 * 2;
        int n9 = n3 + n7 * 2;
        return new Rectangle(n8, n9);
    }
}

