/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.img;

import com.ccb.core.img.ImgUtil;
import com.ccb.core.io.FileTypeUtil;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.StrUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class BackgroundRemoval {
    public static String[] IMAGES_TYPE = new String[]{"jpg", "png"};

    public static boolean backgroundRemoval(String string, String string2, int n2) {
        return BackgroundRemoval.backgroundRemoval(new File(string), new File(string2), n2);
    }

    public static boolean backgroundRemoval(File file, File file2, int n2) {
        return BackgroundRemoval.backgroundRemoval(file, file2, null, n2);
    }

    public static boolean backgroundRemoval(File file, File file2, Color color, int n2) {
        if (BackgroundRemoval.fileTypeValidation(file, IMAGES_TYPE)) {
            return false;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(file);
            return ImageIO.write((RenderedImage)BackgroundRemoval.backgroundRemoval(bufferedImage, color, n2), "png", file2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static BufferedImage backgroundRemoval(BufferedImage bufferedImage, Color color, int n2) {
        n2 = Math.min(255, Math.max(n2, 0));
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        BufferedImage bufferedImage2 = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 6);
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
        Object[] objectArray = BackgroundRemoval.getRemoveRgb(bufferedImage);
        String string = BackgroundRemoval.getMainColor(bufferedImage);
        int n3 = 0;
        for (int i2 = bufferedImage2.getMinY(); i2 < bufferedImage2.getHeight(); ++i2) {
            for (int i3 = bufferedImage2.getMinX(); i3 < bufferedImage2.getWidth(); ++i3) {
                boolean bl;
                int n4 = bufferedImage2.getRGB(i3, i2);
                String string2 = ImgUtil.toHex((n4 & 0xFF0000) >> 16, (n4 & 0xFF00) >> 8, n4 & 0xFF);
                boolean bl2 = bl = ArrayUtil.contains(objectArray, string2) || BackgroundRemoval.areColorsWithinTolerance(BackgroundRemoval.hexToRgb(string), new Color(Integer.parseInt(string2.substring(1), 16)), n2);
                if (bl) {
                    n4 = color == null ? n3 + 1 << 24 | n4 & 0xFFFFFF : color.getRGB();
                }
                bufferedImage2.setRGB(i3, i2, n4);
            }
        }
        graphics.drawImage(bufferedImage2, 0, 0, imageIcon.getImageObserver());
        return bufferedImage2;
    }

    public static BufferedImage backgroundRemoval(ByteArrayOutputStream byteArrayOutputStream, Color color, int n2) {
        try {
            return BackgroundRemoval.backgroundRemoval(ImageIO.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())), color, n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static String[] getRemoveRgb(BufferedImage bufferedImage) {
        int n2 = bufferedImage.getWidth() - 1;
        int n3 = bufferedImage.getHeight() - 1;
        int n4 = bufferedImage.getRGB(1, 1);
        String string = ImgUtil.toHex((n4 & 0xFF0000) >> 16, (n4 & 0xFF00) >> 8, n4 & 0xFF);
        int n5 = bufferedImage.getRGB(n2 / 2, 1);
        String string2 = ImgUtil.toHex((n5 & 0xFF0000) >> 16, (n5 & 0xFF00) >> 8, n5 & 0xFF);
        int n6 = bufferedImage.getRGB(n2, 1);
        String string3 = ImgUtil.toHex((n6 & 0xFF0000) >> 16, (n6 & 0xFF00) >> 8, n6 & 0xFF);
        int n7 = bufferedImage.getRGB(n2, n3 / 2);
        String string4 = ImgUtil.toHex((n7 & 0xFF0000) >> 16, (n7 & 0xFF00) >> 8, n7 & 0xFF);
        int n8 = bufferedImage.getRGB(n2, n3);
        String string5 = ImgUtil.toHex((n8 & 0xFF0000) >> 16, (n8 & 0xFF00) >> 8, n8 & 0xFF);
        int n9 = bufferedImage.getRGB(n2 / 2, n3);
        String string6 = ImgUtil.toHex((n9 & 0xFF0000) >> 16, (n9 & 0xFF00) >> 8, n9 & 0xFF);
        int n10 = bufferedImage.getRGB(1, n3);
        String string7 = ImgUtil.toHex((n10 & 0xFF0000) >> 16, (n10 & 0xFF00) >> 8, n10 & 0xFF);
        int n11 = bufferedImage.getRGB(1, n3 / 2);
        String string8 = ImgUtil.toHex((n11 & 0xFF0000) >> 16, (n11 & 0xFF00) >> 8, n11 & 0xFF);
        return new String[]{string, string2, string3, string4, string5, string6, string7, string8};
    }

    public static Color hexToRgb(String string) {
        return new Color(Integer.parseInt(string.substring(1), 16));
    }

    public static boolean areColorsWithinTolerance(Color color, Color color2, int n2) {
        return BackgroundRemoval.areColorsWithinTolerance(color, color2, new Color(n2, n2, n2));
    }

    public static boolean areColorsWithinTolerance(Color color, Color color2, Color color3) {
        return color.getRed() - color2.getRed() < color3.getRed() && color.getRed() - color2.getRed() > -color3.getRed() && color.getBlue() - color2.getBlue() < color3.getBlue() && color.getBlue() - color2.getBlue() > -color3.getBlue() && color.getGreen() - color2.getGreen() < color3.getGreen() && color.getGreen() - color2.getGreen() > -color3.getGreen();
    }

    public static String getMainColor(String string) {
        return BackgroundRemoval.getMainColor(new File(string));
    }

    public static String getMainColor(File file) {
        try {
            return BackgroundRemoval.getMainColor(ImageIO.read(file));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    public static String getMainColor(BufferedImage bufferedImage) {
        int n2;
        String[] stringArray;
        if (bufferedImage == null) {
            throw new IllegalArgumentException("\u56fe\u7247\u6d41\u662f\u7a7a\u7684");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = bufferedImage.getMinY(); i2 < bufferedImage.getHeight(); ++i2) {
            for (int i3 = bufferedImage.getMinX(); i3 < bufferedImage.getWidth(); ++i3) {
                int n3 = bufferedImage.getRGB(i3, i2);
                arrayList.add(((n3 & 0xFF0000) >> 16) + "-" + ((n3 & 0xFF00) >> 8) + "-" + (n3 & 0xFF));
            }
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(arrayList.size());
        for (String string : arrayList) {
            Integer n4 = (Integer)hashMap.get(string);
            if (n4 == null) {
                n4 = 1;
            } else {
                stringArray = n4;
                Integer object2 = n4 = Integer.valueOf(n4 + 1);
            }
            hashMap.put(string, n4);
        }
        Object object = "";
        long l2 = 0L;
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            Integer n3 = (Integer)entry.getValue();
            if (!StrUtil.isBlank((CharSequence)object) && (long)n3.intValue() <= l2) continue;
            object = string;
            l2 = n3.intValue();
        }
        stringArray = ((String)object).split("-");
        if (stringArray.length == (n2 = 3)) {
            return ImgUtil.toHex(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
        }
        return "";
    }

    private static boolean fileTypeValidation(File file, String[] stringArray) {
        if (!file.exists()) {
            throw new IllegalArgumentException("\u7ed9\u5b9a\u6587\u4ef6\u4e3a\u7a7a");
        }
        String string = FileTypeUtil.getType(file);
        if (!ArrayUtil.contains(stringArray, string)) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"\u6587\u4ef6\u7c7b\u578b{}\u4e0d\u652f\u6301", string));
        }
        return false;
    }
}

