/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.exceptions;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.io.FastByteArrayOutputStream;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.ReflectUtil;
import com.ccb.core.util.StrUtil;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExceptionUtil {
    public static String getMessage(Throwable throwable) {
        if (null == throwable) {
            return "null";
        }
        return StrUtil.format((CharSequence)"{}: {}", throwable.getClass().getSimpleName(), throwable.getMessage());
    }

    public static String getSimpleMessage(Throwable throwable) {
        return null == throwable ? "null" : throwable.getMessage();
    }

    public static RuntimeException wrapRuntime(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        return new RuntimeException(throwable);
    }

    public static Throwable wrap(Throwable throwable, Class clazz) {
        if (clazz.isInstance(throwable)) {
            return throwable;
        }
        return (Throwable)ReflectUtil.newInstance(clazz, throwable);
    }

    public static void wrapAndThrow(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new UndeclaredThrowableException(throwable);
    }

    public static Throwable unwrap(Throwable throwable) {
        Throwable throwable2 = throwable;
        while (true) {
            if (throwable2 instanceof InvocationTargetException) {
                throwable2 = ((InvocationTargetException)throwable2).getTargetException();
                continue;
            }
            if (!(throwable2 instanceof UndeclaredThrowableException)) break;
            throwable2 = ((UndeclaredThrowableException)throwable2).getUndeclaredThrowable();
        }
        return throwable2;
    }

    public static StackTraceElement[] getStackElements() {
        return Thread.currentThread().getStackTrace();
    }

    public static StackTraceElement getStackElement(int n2) {
        return ExceptionUtil.getStackElements()[n2];
    }

    public static StackTraceElement getRootStackElement() {
        StackTraceElement[] stackTraceElementArray = ExceptionUtil.getStackElements();
        return stackTraceElementArray[stackTraceElementArray.length - 1];
    }

    public static String stacktraceToOneLineString(Throwable throwable) {
        return ExceptionUtil.stacktraceToOneLineString(throwable, 3000);
    }

    public static String stacktraceToOneLineString(Throwable throwable, int n2) {
        HashMap<Character, String> hashMap = new HashMap<Character, String>();
        hashMap.put(Character.valueOf('\r'), " ");
        hashMap.put(Character.valueOf('\n'), " ");
        hashMap.put(Character.valueOf('\t'), " ");
        return ExceptionUtil.stacktraceToString(throwable, n2, hashMap);
    }

    public static String stacktraceToString(Throwable throwable) {
        return ExceptionUtil.stacktraceToString(throwable, 3000);
    }

    public static String stacktraceToString(Throwable throwable, int n2) {
        return ExceptionUtil.stacktraceToString(throwable, n2, null);
    }

    public static String stacktraceToString(Throwable throwable, int n2, Map map) {
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(fastByteArrayOutputStream));
        String string = fastByteArrayOutputStream.toString();
        int n3 = string.length();
        if (n2 > 0 && n2 < n3) {
            n3 = n2;
        }
        if (CollUtil.isNotEmpty(map)) {
            StringBuilder stringBuilder = StrUtil.builder();
            for (int i2 = 0; i2 < n3; ++i2) {
                char c2 = string.charAt(i2);
                String string2 = (String)map.get(Character.valueOf(c2));
                if (null != string2) {
                    stringBuilder.append(string2);
                    continue;
                }
                stringBuilder.append(c2);
            }
            return stringBuilder.toString();
        }
        return StrUtil.subPre(string, n2);
    }

    public static boolean isCausedBy(Throwable throwable, Class ... classArray) {
        return null != ExceptionUtil.getCausedBy(throwable, classArray);
    }

    public static Throwable getCausedBy(Throwable throwable, Class ... classArray) {
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            for (Class clazz : classArray) {
                if (!clazz.isInstance(throwable2)) continue;
                return throwable2;
            }
        }
        return null;
    }

    public static boolean isFromOrSuppressedThrowable(Throwable throwable, Class clazz) {
        return ExceptionUtil.convertFromOrSuppressedThrowable(throwable, clazz, true) != null;
    }

    public static boolean isFromOrSuppressedThrowable(Throwable throwable, Class clazz, boolean bl) {
        return ExceptionUtil.convertFromOrSuppressedThrowable(throwable, clazz, bl) != null;
    }

    public static Throwable convertFromOrSuppressedThrowable(Throwable throwable, Class clazz) {
        return ExceptionUtil.convertFromOrSuppressedThrowable(throwable, clazz, true);
    }

    public static Throwable convertFromOrSuppressedThrowable(Throwable throwable, Class clazz, boolean bl) {
        Object[] objectArray;
        if (throwable == null || clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(throwable.getClass())) {
            return throwable;
        }
        if (bl && (objectArray = throwable.getCause()) != null && clazz.isAssignableFrom(objectArray.getClass())) {
            return objectArray;
        }
        objectArray = throwable.getSuppressed();
        if (ArrayUtil.isNotEmpty(objectArray)) {
            for (Object object : objectArray) {
                if (!clazz.isAssignableFrom(object.getClass())) continue;
                return object;
            }
        }
        return null;
    }

    public static List getThrowableList(Throwable throwable) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        while (throwable != null && !arrayList.contains(throwable)) {
            arrayList.add(throwable);
            throwable = throwable.getCause();
        }
        return arrayList;
    }

    public static Throwable getRootCause(Throwable throwable) {
        List list = ExceptionUtil.getThrowableList(throwable);
        return list.size() < 1 ? null : (Throwable)list.get(list.size() - 1);
    }

    public static String getRootCauseMessage(Throwable throwable) {
        return ExceptionUtil.getMessage(ExceptionUtil.getRootCause(throwable));
    }
}

