/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.date.format;

import com.ccb.core.lang.Assert;
import com.ccb.core.lang.Tuple;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

abstract class FormatCache {
    static final int NONE = -1;
    private final ConcurrentMap cInstanceCache = new ConcurrentHashMap(7);
    private static final ConcurrentMap C_DATE_TIME_INSTANCE_CACHE = new ConcurrentHashMap(7);

    FormatCache() {
    }

    public Format getInstance() {
        return this.getDateTimeInstance(3, 3, (TimeZone)null, (Locale)null);
    }

    public Format getInstance(String string, TimeZone timeZone, Locale locale) {
        Format format;
        Tuple tuple;
        Format format2;
        Assert.notBlank(string, "pattern must not be blank", new Object[0]);
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((format2 = (Format)this.cInstanceCache.get(tuple = new Tuple(string, timeZone, locale))) == null && (format = this.cInstanceCache.putIfAbsent(tuple, format2 = this.createInstance(string, timeZone, locale))) != null) {
            format2 = format;
        }
        return format2;
    }

    protected abstract Format createInstance(String var1, TimeZone var2, Locale var3);

    private Format getDateTimeInstance(Integer n2, Integer n3, TimeZone timeZone, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String string = FormatCache.getPatternForStyle(n2, n3, locale);
        return this.getInstance(string, timeZone, locale);
    }

    Format getDateTimeInstance(int n2, int n3, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance((Integer)n2, (Integer)n3, timeZone, locale);
    }

    Format getDateInstance(int n2, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance((Integer)n2, null, timeZone, locale);
    }

    Format getTimeInstance(int n2, TimeZone timeZone, Locale locale) {
        return this.getDateTimeInstance(null, (Integer)n2, timeZone, locale);
    }

    static String getPatternForStyle(Integer n2, Integer n3, Locale locale) {
        Tuple tuple = new Tuple(n2, n3, locale);
        String string = (String)C_DATE_TIME_INSTANCE_CACHE.get(tuple);
        if (string == null) {
            try {
                DateFormat dateFormat = n2 == null ? DateFormat.getTimeInstance(n3, locale) : (n3 == null ? DateFormat.getDateInstance(n2, locale) : DateFormat.getDateTimeInstance(n2, n3, locale));
                string = ((SimpleDateFormat)dateFormat).toPattern();
                String string2 = C_DATE_TIME_INSTANCE_CACHE.putIfAbsent(tuple, string);
                if (string2 != null) {
                    string = string2;
                }
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("No date time pattern for locale: " + locale);
            }
        }
        return string;
    }
}

