/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.date;

import com.ccb.core.date.TemporalUtil;
import com.ccb.core.util.StrUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;

public class TemporalAccessorUtil
extends TemporalUtil {
    public static int get(TemporalAccessor temporalAccessor, TemporalField temporalField) {
        if (temporalAccessor.isSupported(temporalField)) {
            return temporalAccessor.get(temporalField);
        }
        return (int)temporalField.range().getMinimum();
    }

    public static String format(TemporalAccessor temporalAccessor, DateTimeFormatter dateTimeFormatter) {
        if (null == temporalAccessor) {
            return null;
        }
        if (null == dateTimeFormatter) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        }
        return dateTimeFormatter.format(temporalAccessor);
    }

    public static String format(TemporalAccessor temporalAccessor, String string) {
        if (null == temporalAccessor) {
            return null;
        }
        DateTimeFormatter dateTimeFormatter = StrUtil.isBlank(string) ? null : DateTimeFormatter.ofPattern(string);
        return TemporalAccessorUtil.format(temporalAccessor, dateTimeFormatter);
    }

    public static long toEpochMilli(TemporalAccessor temporalAccessor) {
        return TemporalAccessorUtil.toInstant(temporalAccessor).toEpochMilli();
    }

    public static Instant toInstant(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        Instant instant = temporalAccessor instanceof Instant ? (Instant)temporalAccessor : (temporalAccessor instanceof LocalDateTime ? ((LocalDateTime)temporalAccessor).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof ZonedDateTime ? ((ZonedDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof OffsetDateTime ? ((OffsetDateTime)temporalAccessor).toInstant() : (temporalAccessor instanceof LocalDate ? ((LocalDate)temporalAccessor).atStartOfDay(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof LocalTime ? ((LocalTime)temporalAccessor).atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant() : (temporalAccessor instanceof OffsetTime ? ((OffsetTime)temporalAccessor).atDate(LocalDate.now()).toInstant() : Instant.from(temporalAccessor)))))));
        return instant;
    }
}

