/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.date;

import com.ccb.core.date.DatePattern;
import com.ccb.core.date.DateTime;
import com.ccb.core.date.TemporalAccessorUtil;
import com.ccb.core.date.TemporalUtil;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.ReUtil;
import com.ccb.core.util.StrUtil;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.TimeZone;

public class LocalDateTimeUtil {
    public static LocalDateTime now() {
        return LocalDateTime.now();
    }

    public static LocalDateTime of(Instant instant) {
        return LocalDateTimeUtil.of(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime ofUTC(Instant instant) {
        return LocalDateTimeUtil.of(instant, ZoneId.of("UTC"));
    }

    public static LocalDateTime of(ZonedDateTime zonedDateTime) {
        if (null == zonedDateTime) {
            return null;
        }
        return zonedDateTime.toLocalDateTime();
    }

    public static LocalDateTime of(Instant instant, ZoneId zoneId) {
        if (null == instant) {
            return null;
        }
        return LocalDateTime.ofInstant(instant, (ZoneId)ObjectUtil.defaultIfNull(zoneId, ZoneId.systemDefault()));
    }

    public static LocalDateTime of(Instant instant, TimeZone timeZone) {
        if (null == instant) {
            return null;
        }
        return LocalDateTimeUtil.of(instant, ((TimeZone)ObjectUtil.defaultIfNull(timeZone, TimeZone.getDefault())).toZoneId());
    }

    public static LocalDateTime of(long l2) {
        return LocalDateTimeUtil.of(Instant.ofEpochMilli(l2));
    }

    public static LocalDateTime ofUTC(long l2) {
        return LocalDateTimeUtil.ofUTC(Instant.ofEpochMilli(l2));
    }

    public static LocalDateTime of(long l2, ZoneId zoneId) {
        return LocalDateTimeUtil.of(Instant.ofEpochMilli(l2), zoneId);
    }

    public static LocalDateTime of(long l2, TimeZone timeZone) {
        return LocalDateTimeUtil.of(Instant.ofEpochMilli(l2), timeZone);
    }

    public static LocalDateTime of(Date date) {
        if (null == date) {
            return null;
        }
        if (date instanceof DateTime) {
            return LocalDateTimeUtil.of(date.toInstant(), ((DateTime)date).getZoneId());
        }
        return LocalDateTimeUtil.of(date.toInstant());
    }

    public static LocalDateTime of(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDate) {
            return ((LocalDate)temporalAccessor).atStartOfDay();
        }
        return LocalDateTime.of(TemporalAccessorUtil.get(temporalAccessor, ChronoField.YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.DAY_OF_MONTH), TemporalAccessorUtil.get(temporalAccessor, ChronoField.HOUR_OF_DAY), TemporalAccessorUtil.get(temporalAccessor, ChronoField.MINUTE_OF_HOUR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.SECOND_OF_MINUTE), TemporalAccessorUtil.get(temporalAccessor, ChronoField.NANO_OF_SECOND));
    }

    public static LocalDate ofDate(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDateTime) {
            return ((LocalDateTime)temporalAccessor).toLocalDate();
        }
        return LocalDate.of(TemporalAccessorUtil.get(temporalAccessor, ChronoField.YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.DAY_OF_MONTH));
    }

    public static LocalDateTime parse(CharSequence charSequence) {
        return LocalDateTimeUtil.parse(charSequence, (DateTimeFormatter)null);
    }

    public static LocalDateTime parse(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        if (null == charSequence) {
            return null;
        }
        if (null == dateTimeFormatter) {
            return LocalDateTime.parse(charSequence);
        }
        return LocalDateTimeUtil.of(dateTimeFormatter.parse(charSequence));
    }

    public static LocalDateTime parse(CharSequence charSequence, String string) {
        if (null == charSequence) {
            return null;
        }
        DateTimeFormatter dateTimeFormatter = null;
        if (StrUtil.isNotBlank(string)) {
            if (StrUtil.startWithIgnoreEquals(string, "yyyyMMddHHmmss")) {
                String string2 = StrUtil.removePrefix(string, "yyyyMMddHHmmss");
                if (ReUtil.isMatch("[S]{1,2}", (CharSequence)string2)) {
                    charSequence = charSequence + StrUtil.repeat('0', 3 - string2.length());
                }
                dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("yyyyMMddHHmmss").appendValue(ChronoField.MILLI_OF_SECOND, 3).toFormatter();
            } else {
                dateTimeFormatter = DateTimeFormatter.ofPattern(string);
            }
        }
        return LocalDateTimeUtil.parse(charSequence, dateTimeFormatter);
    }

    public static LocalDate parseDate(CharSequence charSequence) {
        return LocalDateTimeUtil.parseDate(charSequence, (DateTimeFormatter)null);
    }

    public static LocalDate parseDate(CharSequence charSequence, DateTimeFormatter dateTimeFormatter) {
        if (null == charSequence) {
            return null;
        }
        if (null == dateTimeFormatter) {
            return LocalDate.parse(charSequence);
        }
        return LocalDateTimeUtil.ofDate(dateTimeFormatter.parse(charSequence));
    }

    public static LocalDate parseDate(CharSequence charSequence, String string) {
        if (null == charSequence) {
            return null;
        }
        return LocalDateTimeUtil.parseDate(charSequence, DateTimeFormatter.ofPattern(string));
    }

    public static String formatNormal(LocalDateTime localDateTime) {
        return LocalDateTimeUtil.format(localDateTime, DatePattern.NORM_DATETIME_FORMATTER);
    }

    public static String format(LocalDateTime localDateTime, DateTimeFormatter dateTimeFormatter) {
        return TemporalAccessorUtil.format((TemporalAccessor)localDateTime, dateTimeFormatter);
    }

    public static String format(LocalDateTime localDateTime, String string) {
        if (null == localDateTime) {
            return null;
        }
        return LocalDateTimeUtil.format(localDateTime, DateTimeFormatter.ofPattern(string));
    }

    public static String formatNormal(LocalDate localDate) {
        return LocalDateTimeUtil.format(localDate, DatePattern.NORM_DATE_FORMATTER);
    }

    public static String format(LocalDate localDate, DateTimeFormatter dateTimeFormatter) {
        return TemporalAccessorUtil.format((TemporalAccessor)localDate, dateTimeFormatter);
    }

    public static String format(LocalDate localDate, String string) {
        if (null == localDate) {
            return null;
        }
        return LocalDateTimeUtil.format(localDate, DateTimeFormatter.ofPattern(string));
    }

    public static LocalDateTime offset(LocalDateTime localDateTime, long l2, TemporalUnit temporalUnit) {
        if (null == localDateTime) {
            return null;
        }
        return localDateTime.plus(l2, temporalUnit);
    }

    public static Duration between(LocalDateTime localDateTime, LocalDateTime localDateTime2) {
        return TemporalUtil.between(localDateTime, localDateTime2);
    }

    public static long between(LocalDateTime localDateTime, LocalDateTime localDateTime2, ChronoUnit chronoUnit) {
        return TemporalUtil.between(localDateTime, localDateTime2, chronoUnit);
    }

    public static Period betweenPeriod(LocalDate localDate, LocalDate localDate2) {
        return Period.between(localDate, localDate2);
    }

    public static LocalDateTime beginOfDay(LocalDateTime localDateTime) {
        return localDateTime.with(LocalTime.MIN);
    }

    public static LocalDateTime endOfDay(LocalDateTime localDateTime) {
        return localDateTime.with(LocalTime.MAX);
    }

    public static long toEpochMilli(TemporalAccessor temporalAccessor) {
        return TemporalAccessorUtil.toEpochMilli(temporalAccessor);
    }
}

