/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.date;

import com.ccb.core.date.BetweenFormater$Level;
import com.ccb.core.date.DateUnit;
import com.ccb.core.date.DateUtil;
import com.ccb.core.lang.Assert;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class DateBetween
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Date begin;
    private final Date end;

    public static DateBetween create(Date date, Date date2) {
        return new DateBetween(date, date2);
    }

    public static DateBetween create(Date date, Date date2, boolean bl) {
        return new DateBetween(date, date2, bl);
    }

    public DateBetween(Date date, Date date2) {
        this(date, date2, true);
    }

    public DateBetween(Date date, Date date2, boolean bl) {
        Assert.notNull(date, "Begin date is null !", new Object[0]);
        Assert.notNull(date2, "End date is null !", new Object[0]);
        if (bl && date.after(date2)) {
            this.begin = date2;
            this.end = date;
        } else {
            this.begin = date;
            this.end = date2;
        }
    }

    public long between(DateUnit dateUnit) {
        long l2 = this.end.getTime() - this.begin.getTime();
        return l2 / dateUnit.getMillis();
    }

    public long betweenMonth(boolean bl) {
        Calendar calendar = DateUtil.calendar(this.begin);
        Calendar calendar2 = DateUtil.calendar(this.end);
        int n2 = calendar2.get(1) - calendar.get(1);
        int n3 = calendar2.get(2) - calendar.get(2);
        int n4 = n2 * 12 + n3;
        if (!bl) {
            calendar2.set(1, calendar.get(1));
            calendar2.set(2, calendar.get(2));
            long l2 = calendar2.getTimeInMillis() - calendar.getTimeInMillis();
            if (l2 < 0L) {
                return n4 - 1;
            }
        }
        return n4;
    }

    public long betweenYear(boolean bl) {
        Calendar calendar = DateUtil.calendar(this.begin);
        Calendar calendar2 = DateUtil.calendar(this.end);
        int n2 = calendar2.get(1) - calendar.get(1);
        if (!bl) {
            if (1 == calendar.get(2) && 1 == calendar2.get(2) && calendar.get(5) == calendar.getActualMaximum(5) && calendar2.get(5) == calendar2.getActualMaximum(5)) {
                calendar.set(5, 1);
                calendar2.set(5, 1);
            }
            calendar2.set(1, calendar.get(1));
            long l2 = calendar2.getTimeInMillis() - calendar.getTimeInMillis();
            if (l2 < 0L) {
                return n2 - 1;
            }
        }
        return n2;
    }

    public String toString(BetweenFormater$Level betweenFormater$Level) {
        return DateUtil.formatBetween(this.between(DateUnit.MS), betweenFormater$Level);
    }

    public String toString() {
        return this.toString(BetweenFormater$Level.MILLISECOND);
    }
}

