/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.date;

import com.ccb.core.convert.NumberChineseFormatter;
import com.ccb.core.date.DateTime;
import com.ccb.core.date.DateUnit;
import com.ccb.core.date.DateUtil;
import com.ccb.core.date.Zodiac;
import com.ccb.core.date.chinese.ChineseMonth;
import com.ccb.core.date.chinese.GanZhi;
import com.ccb.core.date.chinese.LunarFestival;
import com.ccb.core.date.chinese.LunarInfo;
import com.ccb.core.date.chinese.SolarTerms;
import com.ccb.core.util.StrUtil;
import java.util.Date;

public class ChineseDate {
    private static final long BASE_DAY = -25538L;
    private final int year;
    private final int month;
    private final int day;
    private final int gyear;
    private final int gmonth;
    private final int gday;
    private boolean leap;

    public ChineseDate(Date date) {
        int n2;
        int n3;
        int n4;
        int n5 = (int)(date.getTime() / DateUnit.DAY.getMillis() - -25538L);
        for (n3 = 1900; n3 <= LunarInfo.MAX_YEAR && n5 >= (n4 = LunarInfo.yearDays(n3)); n5 -= n4, ++n3) {
        }
        this.year = n3;
        int n6 = LunarInfo.leapMonth(n3);
        int n7 = 0;
        for (n2 = 1; n2 < 13 && n5 > 0; ++n2) {
            if (n6 > 0 && n2 == n6 + 1 && !this.leap) {
                --n2;
                this.leap = true;
                n7 = LunarInfo.leapDays(this.year);
            } else {
                n7 = LunarInfo.monthDays(this.year, n2);
            }
            n5 -= n7;
            if (!this.leap || n2 != n6 + 1) continue;
            this.leap = false;
        }
        if (n5 == 0 && n6 > 0 && n2 == n6 + 1) {
            if (this.leap) {
                this.leap = false;
            } else {
                this.leap = true;
                --n2;
            }
        }
        if (n5 < 0) {
            n5 += n7;
            --n2;
        }
        this.month = n2;
        this.day = n5 + 1;
        DateTime dateTime = DateUtil.date(date);
        this.gyear = dateTime.year();
        this.gmonth = dateTime.month() + 1;
        this.gday = dateTime.dayOfMonth();
    }

    public ChineseDate(int n2, int n3, int n4) {
        this.day = n4;
        this.month = n3;
        this.year = n2;
        this.leap = DateUtil.isLeapYear(n2);
        int n5 = LunarInfo.leapMonth(n2);
        DateTime dateTime = this.lunar2solar(n2, n3, n4, n3 == n5);
        if (null != dateTime) {
            this.gday = dateTime.dayOfMonth();
            this.gmonth = dateTime.month() + 1;
            this.gyear = dateTime.year();
        } else {
            this.gday = -1;
            this.gmonth = -1;
            this.gyear = -1;
        }
    }

    public int getChineseYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public boolean isLeapMonth() {
        return ChineseMonth.isLeapMonth(this.year, this.month);
    }

    public String getChineseMonth() {
        return ChineseMonth.getChineseMonthName(this.isLeapMonth(), this.month, false);
    }

    public String getChineseMonthName() {
        return ChineseMonth.getChineseMonthName(this.isLeapMonth(), this.month, true);
    }

    public int getDay() {
        return this.day;
    }

    public String getChineseDay() {
        int n2;
        String[] stringArray = new String[]{"\u521d", "\u5341", "\u5eff", "\u5345"};
        int n3 = n2 = this.day % 10 == 0 ? 9 : this.day % 10 - 1;
        if (this.day > 30) {
            return "";
        }
        switch (this.day) {
            case 10: {
                return "\u521d\u5341";
            }
            case 20: {
                return "\u4e8c\u5341";
            }
            case 30: {
                return "\u4e09\u5341";
            }
        }
        return stringArray[this.day / 10] + NumberChineseFormatter.format(n2 + 1, false);
    }

    public String getFestivals() {
        return StrUtil.join(",", LunarFestival.getFestivals(this.year, this.month, this.day));
    }

    public String getChineseZodiac() {
        return Zodiac.getChineseZodiac(this.year);
    }

    public String getCyclical() {
        return GanZhi.cyclicalm(this.year - 1900 + 36);
    }

    public String getCyclicalYMD() {
        if (this.gyear >= 1900 && this.gmonth > 0 && this.gday > 0) {
            return this.cyclicalm(this.gyear, this.gmonth, this.gday);
        }
        return null;
    }

    public String toStringNormal() {
        return String.format("%04d-%02d-%02d", this.year, this.month, this.day);
    }

    public String toString() {
        return String.format("%s%s\u5e74 %s%s", this.getCyclical(), this.getChineseZodiac(), this.getChineseMonthName(), this.getChineseDay());
    }

    private String cyclicalm(int n2, int n3, int n4) {
        String string = GanZhi.cyclicalm(this.year - 1900 + 36);
        int n5 = SolarTerms.getTerm(n2, n3 * 2 - 1);
        String string2 = GanZhi.cyclicalm((n2 - 1900) * 12 + n3 + 11);
        if (n4 >= n5) {
            string2 = GanZhi.cyclicalm((n2 - 1900) * 12 + n3 + 12);
        }
        int n6 = (int)(DateUtil.parseDate(n2 + "-" + n3 + "-" + "1").getTime() / DateUnit.DAY.getMillis() - -25538L + 30L) + 10;
        String string3 = GanZhi.cyclicalm(n6 + n4 - 1);
        return string + "\u5e74" + string2 + "\u6708" + string3 + "\u65e5";
    }

    private DateTime lunar2solar(int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6;
        if (n2 == 2100 && n3 == 12 && n4 > 1 || n2 == 1900 && n3 == 1 && n4 < 31) {
            return null;
        }
        int n7 = n6 = LunarInfo.monthDays(n2, n3);
        if (bl) {
            n7 = LunarInfo.leapDays(n2);
        }
        if (n2 < 1900 || n2 > 2100 || n4 > n7) {
            return null;
        }
        int n8 = 0;
        for (n5 = 1900; n5 < n2; ++n5) {
            n8 += LunarInfo.yearDays(n5);
        }
        boolean bl2 = false;
        for (int i2 = 1; i2 < n3; ++i2) {
            n5 = LunarInfo.leapMonth(n2);
            if (!bl2 && n5 <= i2 && n5 > 0) {
                n8 += LunarInfo.leapDays(n2);
                bl2 = true;
            }
            n8 += LunarInfo.monthDays(n2, i2);
        }
        if (bl) {
            n8 += n6;
        }
        return DateUtil.date((long)(n8 + n4 - 31) * 86400000L - 2203804800000L);
    }
}

