/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.date;

import com.ccb.core.comparator.CompareUtil;
import com.ccb.core.convert.NumberChineseFormatter;
import com.ccb.core.date.DateException;
import com.ccb.core.date.DateField;
import com.ccb.core.date.DateModifier;
import com.ccb.core.date.DateModifier$ModifyType;
import com.ccb.core.date.DateTime;
import com.ccb.core.date.DateUtil;
import com.ccb.core.date.Month;
import com.ccb.core.date.format.FastDateParser;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.StrUtil;
import java.text.ParsePosition;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.TimeZone;

public class CalendarUtil {
    public static Calendar calendar() {
        return Calendar.getInstance();
    }

    public static Calendar calendar(Date date) {
        if (date instanceof DateTime) {
            return ((DateTime)date).toCalendar();
        }
        return CalendarUtil.calendar(date.getTime());
    }

    public static Calendar calendar(long l2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2);
        return calendar;
    }

    public static boolean isAM(Calendar calendar) {
        return 0 == calendar.get(9);
    }

    public static boolean isPM(Calendar calendar) {
        return 1 == calendar.get(9);
    }

    public static Calendar truncate(Calendar calendar, DateField dateField) {
        return DateModifier.modify(calendar, dateField.getValue(), DateModifier$ModifyType.TRUNCATE);
    }

    public static Calendar round(Calendar calendar, DateField dateField) {
        return DateModifier.modify(calendar, dateField.getValue(), DateModifier$ModifyType.ROUND);
    }

    public static Calendar ceiling(Calendar calendar, DateField dateField) {
        return DateModifier.modify(calendar, dateField.getValue(), DateModifier$ModifyType.CEILING);
    }

    public static Calendar beginOfSecond(Calendar calendar) {
        return CalendarUtil.truncate(calendar, DateField.SECOND);
    }

    public static Calendar endOfSecond(Calendar calendar) {
        return CalendarUtil.ceiling(calendar, DateField.SECOND);
    }

    public static Calendar beginOfDay(Calendar calendar) {
        return CalendarUtil.truncate(calendar, DateField.DAY_OF_MONTH);
    }

    public static Calendar endOfDay(Calendar calendar) {
        return CalendarUtil.ceiling(calendar, DateField.DAY_OF_MONTH);
    }

    public static Calendar beginOfWeek(Calendar calendar) {
        return CalendarUtil.beginOfWeek(calendar, true);
    }

    public static Calendar beginOfWeek(Calendar calendar, boolean bl) {
        calendar.setFirstDayOfWeek(bl ? 2 : 1);
        return CalendarUtil.truncate(calendar, DateField.WEEK_OF_MONTH);
    }

    public static Calendar endOfWeek(Calendar calendar) {
        return CalendarUtil.endOfWeek(calendar, true);
    }

    public static Calendar endOfWeek(Calendar calendar, boolean bl) {
        calendar.setFirstDayOfWeek(bl ? 2 : 1);
        return CalendarUtil.ceiling(calendar, DateField.WEEK_OF_MONTH);
    }

    public static Calendar beginOfMonth(Calendar calendar) {
        return CalendarUtil.truncate(calendar, DateField.MONTH);
    }

    public static Calendar endOfMonth(Calendar calendar) {
        return CalendarUtil.ceiling(calendar, DateField.MONTH);
    }

    public static Calendar beginOfQuarter(Calendar calendar) {
        calendar.set(2, calendar.get(DateField.MONTH.getValue()) / 3 * 3);
        calendar.set(5, 1);
        return CalendarUtil.beginOfDay(calendar);
    }

    public static Calendar endOfQuarter(Calendar calendar) {
        int n2 = calendar.get(1);
        int n3 = calendar.get(DateField.MONTH.getValue()) / 3 * 3 + 2;
        Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
        calendar2.set(n2, n3, Month.of(n3).getLastDay(DateUtil.isLeapYear(n2)));
        return CalendarUtil.endOfDay(calendar2);
    }

    public static Calendar beginOfYear(Calendar calendar) {
        return CalendarUtil.truncate(calendar, DateField.YEAR);
    }

    public static Calendar endOfYear(Calendar calendar) {
        return CalendarUtil.ceiling(calendar, DateField.YEAR);
    }

    public static boolean isSameDay(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return calendar.get(6) == calendar2.get(6) && calendar.get(1) == calendar2.get(1) && calendar.get(0) == calendar2.get(0);
    }

    public static boolean isSameMonth(Calendar calendar, Calendar calendar2) {
        if (calendar == null || calendar2 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        return calendar.get(1) == calendar2.get(1) && calendar.get(2) == calendar2.get(2);
    }

    public static boolean isSameInstant(Calendar calendar, Calendar calendar2) {
        if (null == calendar) {
            return null == calendar2;
        }
        if (null == calendar2) {
            return false;
        }
        return calendar.getTimeInMillis() == calendar2.getTimeInMillis();
    }

    public static LinkedHashSet yearAndQuarter(long l2, long l3) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Calendar calendar = CalendarUtil.calendar(l2);
        while (l2 <= l3) {
            linkedHashSet.add(CalendarUtil.yearAndQuarter(calendar));
            calendar.add(2, 3);
            l2 = calendar.getTimeInMillis();
        }
        return linkedHashSet;
    }

    public static String yearAndQuarter(Calendar calendar) {
        return StrUtil.builder().append(calendar.get(1)).append(calendar.get(2) / 3 + 1).toString();
    }

    public static int getBeginValue(Calendar calendar, DateField dateField) {
        return CalendarUtil.getBeginValue(calendar, dateField.getValue());
    }

    public static int getBeginValue(Calendar calendar, int n2) {
        if (7 == n2) {
            return calendar.getFirstDayOfWeek();
        }
        return calendar.getActualMinimum(n2);
    }

    public static int getEndValue(Calendar calendar, DateField dateField) {
        return CalendarUtil.getEndValue(calendar, dateField.getValue());
    }

    public static int getEndValue(Calendar calendar, int n2) {
        if (7 == n2) {
            return (calendar.getFirstDayOfWeek() + 6) % 7;
        }
        return calendar.getActualMaximum(n2);
    }

    public static Instant toInstant(Calendar calendar) {
        return null == calendar ? null : calendar.toInstant();
    }

    public static LocalDateTime toLocalDateTime(Calendar calendar) {
        return LocalDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
    }

    public static int compare(Calendar calendar, Calendar calendar2) {
        return CompareUtil.compare(calendar, calendar2);
    }

    public static int age(Calendar calendar, Calendar calendar2) {
        return CalendarUtil.age(calendar.getTimeInMillis(), calendar2.getTimeInMillis());
    }

    public static String formatChineseDate(Calendar calendar, boolean bl) {
        int n2;
        StringBuilder stringBuilder = StrUtil.builder();
        String string = String.valueOf(calendar.get(1));
        int n3 = string.length();
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuilder.append(NumberChineseFormatter.numberCharToChinese(string.charAt(n2), false));
        }
        stringBuilder.append('\u5e74');
        n2 = calendar.get(2) + 1;
        stringBuilder.append(NumberChineseFormatter.format(n2, false));
        stringBuilder.append('\u6708');
        int n4 = calendar.get(5);
        stringBuilder.append(NumberChineseFormatter.format(n4, false));
        stringBuilder.append('\u65e5');
        if (bl) {
            int n5 = calendar.get(11);
            stringBuilder.append(NumberChineseFormatter.format(n5, false));
            stringBuilder.append('\u65f6');
            int n6 = calendar.get(12);
            stringBuilder.append(NumberChineseFormatter.format(n6, false));
            stringBuilder.append('\u5206');
            int n7 = calendar.get(13);
            stringBuilder.append(NumberChineseFormatter.format(n7, false));
            stringBuilder.append('\u79d2');
        }
        return stringBuilder.toString().replace('\u96f6', '\u3007');
    }

    protected static int age(long l2, long l3) {
        if (l2 > l3) {
            throw new IllegalArgumentException("Birthday is after dateToCompare!");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l3);
        int n2 = calendar.get(1);
        int n3 = calendar.get(2);
        int n4 = calendar.get(5);
        boolean bl = n4 == calendar.getActualMaximum(5);
        calendar.setTimeInMillis(l2);
        int n5 = n2 - calendar.get(1);
        int n6 = calendar.get(2);
        if (n3 == n6) {
            boolean bl2;
            int n7 = calendar.get(5);
            boolean bl3 = bl2 = n7 == calendar.getActualMaximum(5);
            if (!(bl && bl2 || n4 >= n7)) {
                --n5;
            }
        } else if (n3 < n6) {
            --n5;
        }
        return n5;
    }

    public static Calendar parseByPatterns(String string, String ... stringArray) {
        return CalendarUtil.parseByPatterns(string, null, stringArray);
    }

    public static Calendar parseByPatterns(String string, Locale locale, String ... stringArray) {
        return CalendarUtil.parseByPatterns(string, locale, true, stringArray);
    }

    public static Calendar parseByPatterns(String string, Locale locale, boolean bl, String ... stringArray) {
        if (string == null || stringArray == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        TimeZone timeZone = TimeZone.getDefault();
        Locale locale2 = (Locale)ObjectUtil.defaultIfNull(locale, Locale.getDefault());
        ParsePosition parsePosition = new ParsePosition(0);
        Calendar calendar = Calendar.getInstance(timeZone, locale2);
        calendar.setLenient(bl);
        for (String string2 : stringArray) {
            FastDateParser fastDateParser = new FastDateParser(string2, timeZone, locale2);
            calendar.clear();
            try {
                if (fastDateParser.parse(string, parsePosition, calendar) && parsePosition.getIndex() == string.length()) {
                    return calendar;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            parsePosition.setIndex(0);
        }
        throw new DateException("Unable to parse the date: {}", string);
    }
}

