/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.convert.impl;

import com.ccb.core.convert.AbstractConverter;
import com.ccb.core.date.DateTime;
import com.ccb.core.date.DateUtil;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.StrUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

public class TemporalAccessorConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    private final Class targetType;
    private String format;

    public TemporalAccessorConverter(Class clazz) {
        this(clazz, null);
    }

    public TemporalAccessorConverter(Class clazz, String string) {
        this.targetType = clazz;
        this.format = string;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    @Override
    protected TemporalAccessor convertInternal(Object object) {
        if (object instanceof Long) {
            return this.parseFromLong((Long)object);
        }
        if (object instanceof TemporalAccessor) {
            return this.parseFromTemporalAccessor((TemporalAccessor)object);
        }
        if (object instanceof Date) {
            DateTime dateTime = DateUtil.date((Date)object);
            return this.parseFromInstant(dateTime.toInstant(), dateTime.getZoneId());
        }
        if (object instanceof Calendar) {
            Calendar calendar = (Calendar)object;
            return this.parseFromInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        return this.parseFromCharSequence(this.convertToStr(object));
    }

    private TemporalAccessor parseFromCharSequence(CharSequence charSequence) {
        ZoneId zoneId;
        Instant instant;
        if (StrUtil.isBlank(charSequence)) {
            return null;
        }
        if (null != this.format) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(this.format);
            instant = dateTimeFormatter.parse(charSequence, Instant::from);
            zoneId = dateTimeFormatter.getZone();
        } else {
            DateTime dateTime = DateUtil.parse(charSequence);
            instant = Objects.requireNonNull(dateTime).toInstant();
            zoneId = dateTime.getZoneId();
        }
        return this.parseFromInstant(instant, zoneId);
    }

    private TemporalAccessor parseFromLong(Long l2) {
        return this.parseFromInstant(Instant.ofEpochMilli(l2), null);
    }

    private TemporalAccessor parseFromTemporalAccessor(TemporalAccessor temporalAccessor) {
        TemporalAccessor temporalAccessor2 = null;
        if (temporalAccessor instanceof LocalDateTime) {
            temporalAccessor2 = this.parseFromLocalDateTime((LocalDateTime)temporalAccessor);
        } else if (temporalAccessor instanceof ZonedDateTime) {
            temporalAccessor2 = this.parseFromZonedDateTime((ZonedDateTime)temporalAccessor);
        }
        if (null == temporalAccessor2) {
            temporalAccessor2 = this.parseFromInstant(DateUtil.toInstant(temporalAccessor), null);
        }
        return temporalAccessor2;
    }

    private TemporalAccessor parseFromLocalDateTime(LocalDateTime localDateTime) {
        if (Instant.class.equals((Object)this.targetType)) {
            return DateUtil.toInstant(localDateTime);
        }
        if (LocalDate.class.equals((Object)this.targetType)) {
            return localDateTime.toLocalDate();
        }
        if (LocalTime.class.equals((Object)this.targetType)) {
            return localDateTime.toLocalTime();
        }
        if (ZonedDateTime.class.equals((Object)this.targetType)) {
            return localDateTime.atZone(ZoneId.systemDefault());
        }
        if (OffsetDateTime.class.equals((Object)this.targetType)) {
            return localDateTime.atZone(ZoneId.systemDefault()).toOffsetDateTime();
        }
        if (OffsetTime.class.equals((Object)this.targetType)) {
            return localDateTime.atZone(ZoneId.systemDefault()).toOffsetDateTime().toOffsetTime();
        }
        return null;
    }

    private TemporalAccessor parseFromZonedDateTime(ZonedDateTime zonedDateTime) {
        if (Instant.class.equals((Object)this.targetType)) {
            return DateUtil.toInstant(zonedDateTime);
        }
        if (LocalDateTime.class.equals((Object)this.targetType)) {
            return zonedDateTime.toLocalDateTime();
        }
        if (LocalDate.class.equals((Object)this.targetType)) {
            return zonedDateTime.toLocalDate();
        }
        if (LocalTime.class.equals((Object)this.targetType)) {
            return zonedDateTime.toLocalTime();
        }
        if (OffsetDateTime.class.equals((Object)this.targetType)) {
            return zonedDateTime.toOffsetDateTime();
        }
        if (OffsetTime.class.equals((Object)this.targetType)) {
            return zonedDateTime.toOffsetDateTime().toOffsetTime();
        }
        return null;
    }

    private TemporalAccessor parseFromInstant(Instant instant, ZoneId zoneId) {
        if (Instant.class.equals((Object)this.targetType)) {
            return instant;
        }
        zoneId = (ZoneId)ObjectUtil.defaultIfNull(zoneId, ZoneId.systemDefault());
        Comparable<ChronoLocalDateTime<?>> comparable = null;
        if (LocalDateTime.class.equals((Object)this.targetType)) {
            comparable = LocalDateTime.ofInstant(instant, zoneId);
        } else if (LocalDate.class.equals((Object)this.targetType)) {
            comparable = instant.atZone(zoneId).toLocalDate();
        } else if (LocalTime.class.equals((Object)this.targetType)) {
            comparable = instant.atZone(zoneId).toLocalTime();
        } else if (ZonedDateTime.class.equals((Object)this.targetType)) {
            comparable = instant.atZone(zoneId);
        } else if (OffsetDateTime.class.equals((Object)this.targetType)) {
            comparable = OffsetDateTime.ofInstant(instant, zoneId);
        } else if (OffsetTime.class.equals((Object)this.targetType)) {
            comparable = OffsetTime.ofInstant(instant, zoneId);
        }
        return comparable;
    }
}

