/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.convert.impl;

import com.ccb.core.convert.AbstractConverter;
import com.ccb.core.convert.ConvertException;
import com.ccb.core.io.IoUtil;
import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.XmlUtil;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.TimeZone;
import org.w3c.dom.Node;

public class StringConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;

    @Override
    protected String convertInternal(Object object) {
        if (object instanceof TimeZone) {
            return ((TimeZone)object).getID();
        }
        if (object instanceof Node) {
            return XmlUtil.toStr((Node)object);
        }
        if (object instanceof Clob) {
            return StringConverter.clobToStr((Clob)object);
        }
        if (object instanceof Blob) {
            return StringConverter.blobToStr((Blob)object);
        }
        return this.convertToStr(object);
    }

    private static String clobToStr(Clob clob) {
        Reader reader = null;
        try {
            reader = clob.getCharacterStream();
            String string = IoUtil.read(reader);
            return string;
        }
        catch (SQLException sQLException) {
            throw new ConvertException(sQLException);
        }
        finally {
            IoUtil.close(reader);
        }
    }

    private static String blobToStr(Blob blob) {
        InputStream inputStream = null;
        try {
            inputStream = blob.getBinaryStream();
            String string = IoUtil.read(inputStream, CharsetUtil.CHARSET_UTF_8);
            return string;
        }
        catch (SQLException sQLException) {
            throw new ConvertException(sQLException);
        }
        finally {
            IoUtil.close(inputStream);
        }
    }
}

