/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.convert.impl;

import com.ccb.core.convert.AbstractConverter;
import com.ccb.core.date.DateUtil;
import com.ccb.core.util.BooleanUtil;
import com.ccb.core.util.NumberUtil;
import com.ccb.core.util.StrUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

public class NumberConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    private final Class targetType;

    public NumberConverter() {
        this.targetType = Number.class;
    }

    public NumberConverter(Class clazz) {
        this.targetType = null == clazz ? Number.class : clazz;
    }

    @Override
    protected Number convertInternal(Object object) {
        return this.convertInternal(object, this.targetType);
    }

    private Number convertInternal(Object object, Class clazz) {
        if (Byte.class == clazz) {
            if (object instanceof Number) {
                return ((Number)object).byteValue();
            }
            if (object instanceof Boolean) {
                return BooleanUtil.toByteObj((Boolean)object);
            }
            String string = this.convertToStr(object);
            return StrUtil.isBlank(string) ? null : Byte.valueOf(string);
        }
        if (Short.class == clazz) {
            if (object instanceof Number) {
                return ((Number)object).shortValue();
            }
            if (object instanceof Boolean) {
                return BooleanUtil.toShortObj((Boolean)object);
            }
            String string = this.convertToStr(object);
            return StrUtil.isBlank(string) ? null : Short.valueOf(string);
        }
        if (Integer.class == clazz) {
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            if (object instanceof Boolean) {
                return BooleanUtil.toInteger((Boolean)object);
            }
            if (object instanceof Date) {
                return (int)((Date)object).getTime();
            }
            if (object instanceof Calendar) {
                return (int)((Calendar)object).getTimeInMillis();
            }
            if (object instanceof TemporalAccessor) {
                return (int)DateUtil.toInstant((TemporalAccessor)object).toEpochMilli();
            }
            String string = this.convertToStr(object);
            return StrUtil.isBlank(string) ? null : Integer.valueOf(NumberUtil.parseInt(string));
        }
        if (AtomicInteger.class == clazz) {
            Number number = this.convertInternal(object, Integer.class);
            if (null != number) {
                AtomicInteger atomicInteger = new AtomicInteger();
                atomicInteger.set(number.intValue());
                return atomicInteger;
            }
        } else {
            if (Long.class == clazz) {
                if (object instanceof Number) {
                    return ((Number)object).longValue();
                }
                if (object instanceof Boolean) {
                    return BooleanUtil.toLongObj((Boolean)object);
                }
                if (object instanceof Date) {
                    return ((Date)object).getTime();
                }
                if (object instanceof Calendar) {
                    return ((Calendar)object).getTimeInMillis();
                }
                if (object instanceof TemporalAccessor) {
                    return DateUtil.toInstant((TemporalAccessor)object).toEpochMilli();
                }
                String string = this.convertToStr(object);
                return StrUtil.isBlank(string) ? null : Long.valueOf(NumberUtil.parseLong(string));
            }
            if (AtomicLong.class == clazz) {
                Number number = this.convertInternal(object, Long.class);
                if (null != number) {
                    AtomicLong atomicLong = new AtomicLong();
                    atomicLong.set(number.longValue());
                    return atomicLong;
                }
            } else if (LongAdder.class == clazz) {
                Number number = this.convertInternal(object, Long.class);
                if (null != number) {
                    LongAdder longAdder = new LongAdder();
                    longAdder.add(number.longValue());
                    return longAdder;
                }
            } else {
                if (Float.class == clazz) {
                    if (object instanceof Number) {
                        return Float.valueOf(((Number)object).floatValue());
                    }
                    if (object instanceof Boolean) {
                        return BooleanUtil.toFloatObj((Boolean)object);
                    }
                    String string = this.convertToStr(object);
                    return StrUtil.isBlank(string) ? null : Float.valueOf(string);
                }
                if (Double.class == clazz) {
                    if (object instanceof Number) {
                        return ((Number)object).doubleValue();
                    }
                    if (object instanceof Boolean) {
                        return BooleanUtil.toDoubleObj((Boolean)object);
                    }
                    String string = this.convertToStr(object);
                    return StrUtil.isBlank(string) ? null : Double.valueOf(string);
                }
                if (DoubleAdder.class == clazz) {
                    Number number = this.convertInternal(object, Long.class);
                    if (null != number) {
                        DoubleAdder doubleAdder = new DoubleAdder();
                        doubleAdder.add(number.doubleValue());
                        return doubleAdder;
                    }
                } else {
                    if (BigDecimal.class == clazz) {
                        return this.toBigDecimal(object);
                    }
                    if (BigInteger.class == clazz) {
                        return this.toBigInteger(object);
                    }
                    if (Number.class == clazz) {
                        if (object instanceof Number) {
                            return (Number)object;
                        }
                        if (object instanceof Boolean) {
                            return BooleanUtil.toInteger((Boolean)object);
                        }
                        String string = this.convertToStr(object);
                        return StrUtil.isBlank(string) ? (Number)null : (Number)NumberUtil.parseNumber(string);
                    }
                }
            }
        }
        throw new UnsupportedOperationException(StrUtil.format((CharSequence)"Unsupport Number type: {}", this.targetType.getName()));
    }

    private BigDecimal toBigDecimal(Object object) {
        if (object instanceof Number) {
            return NumberUtil.toBigDecimal((Number)object);
        }
        if (object instanceof Boolean) {
            return new BigDecimal((Boolean)object != false ? 1 : 0);
        }
        return NumberUtil.toBigDecimal(this.convertToStr(object));
    }

    private BigInteger toBigInteger(Object object) {
        if (object instanceof Long) {
            return BigInteger.valueOf((Long)object);
        }
        if (object instanceof Boolean) {
            return BigInteger.valueOf((Boolean)object != false ? 1L : 0L);
        }
        return NumberUtil.toBigInteger(this.convertToStr(object));
    }

    @Override
    protected String convertToStr(Object object) {
        char c2;
        String string = StrUtil.trim(super.convertToStr(object));
        if (StrUtil.isNotEmpty(string) && ((c2 = Character.toUpperCase(string.charAt(string.length() - 1))) == 'D' || c2 == 'L' || c2 == 'F')) {
            return StrUtil.subPre(string, -1);
        }
        return string;
    }

    @Override
    public Class getTargetType() {
        return this.targetType;
    }
}

