/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.convert.impl;

import com.ccb.core.bean.BeanUtil;
import com.ccb.core.convert.AbstractConverter;
import com.ccb.core.convert.ConverterRegistry;
import com.ccb.core.map.MapUtil;
import com.ccb.core.util.StrUtil;
import com.ccb.core.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;

public class MapConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    private final Type mapType;
    private final Type keyType;
    private final Type valueType;

    public MapConverter(Type type) {
        this(type, TypeUtil.getTypeArgument(type, 0), TypeUtil.getTypeArgument(type, 1));
    }

    public MapConverter(Type type, Type type2, Type type3) {
        this.mapType = type;
        this.keyType = type2;
        this.valueType = type3;
    }

    @Override
    protected Map convertInternal(Object object) {
        Map map;
        if (object instanceof Map) {
            Type[] typeArray = TypeUtil.getTypeArguments(object.getClass());
            if (null != typeArray && 2 == typeArray.length && Objects.equals(this.keyType, typeArray[0]) && Objects.equals(this.valueType, typeArray[1])) {
                return (Map)object;
            }
            map = MapUtil.createMap(TypeUtil.getClass(this.mapType));
            this.convertMapToMap((Map)object, map);
        } else if (BeanUtil.isBean(object.getClass())) {
            map = BeanUtil.beanToMap(object);
            map = this.convertInternal(map);
        } else {
            throw new UnsupportedOperationException(StrUtil.format((CharSequence)"Unsupport toMap value type: {}", object.getClass().getName()));
        }
        return map;
    }

    private void convertMapToMap(Map map, Map map2) {
        ConverterRegistry converterRegistry = ConverterRegistry.getInstance();
        for (Map.Entry entry : map.entrySet()) {
            Object k2 = TypeUtil.isUnknown(this.keyType) ? entry.getKey() : converterRegistry.convert(this.keyType, entry.getKey());
            Object v2 = TypeUtil.isUnknown(this.valueType) ? entry.getValue() : converterRegistry.convert(this.valueType, entry.getValue());
            map2.put(k2, v2);
        }
    }

    @Override
    public Class getTargetType() {
        return TypeUtil.getClass(this.mapType);
    }
}

